const mix = require('laravel-mix');

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */

mix.js('resources/js/app.js', 'public/js')
    .sass('resources/sass/app.scss', 'public/css')
mix.combine([
    'public/plugins/AdminLTE/bootstrap/js/bootstrap.min.js',
    'public/plugins/AdminLTE/plugins/slimScroll/jquery.slimscroll.min.js',
    'public/plugins/AdminLTE/dist/js/app.min.js',
    'public/plugins/jquery-pjax/jquery.pjax.js',
    'public/plugins/nprogress/nprogress.js',
    'public/plugins/nestable/jquery.nestable.js',
    'public/plugins/toastr/build/toastr.min.js',
    'public/plugins/bootstrap3-editable/js/bootstrap-editable.min.js',
    'public/plugins/sweetalert2/dist/sweetalert2.min.js',
    'public/plugins/laravel-admin/laravel-admin.js',
    'public/plugins/AdminLTE/plugins/iCheck/icheck.min.js',
    'public/plugins/AdminLTE/plugins/colorpicker/bootstrap-colorpicker.min.js',
    'public/plugins/AdminLTE/plugins/input-mask/jquery.inputmask.bundle.min.js',
    'public/plugins/moment/min/moment-with-locales.min.js',
    'public/plugins/AdminLTE/plugins/datepicker/bootstrap-datepicker.min.js',
    'public/plugins/AdminLTE/plugins/daterangepicker/daterangepicker.js',
    'public/plugins/eonasdan-bootstrap-datetimepicker/build/js/bootstrap-datetimepicker.min.js',
    'public/plugins/bootstrap-fileinput/js/plugins/canvas-to-blob.min.js',
    'public/plugins/bootstrap-fileinput/js/fileinput.min.js',
    'public/plugins/AdminLTE/plugins/select2/select2.full.min.js',
    'public/plugins/number-input/bootstrap-number-input.js',
    'public/plugins/AdminLTE/plugins/ionslider/ion.rangeSlider.min.js',
    'public/plugins/bootstrap-switch/dist/js/bootstrap-switch.min.js',
    'public/plugins/fontawesome-iconpicker/dist/js/fontawesome-iconpicker.min.js',
    'public/plugins/bootstrap-fileinput/js/plugins/sortable.min.js',
    'public/plugins/bootstrap-duallistbox/dist/jquery.bootstrap-duallistbox.min.js',
    'public/plugins/jquery-play-sound/jquery.playSound.js',
    'public/plugins/AdminLTE/plugins/DataTables/datatables.min.js',
    'public/plugins/AdminLTE/plugins/DataTables/pdfmake-0.1.32/pdfmake.min.js',
    'public/plugins/AdminLTE/plugins/DataTables/pdfmake-0.1.32/vfs_fonts.js',
    'public/plugins/AdminLTE/plugins/tel-input/build/js/intlTelInput.js',
], 'public/js/alladmin.js')
mix.combine([
        'public/plugins/AdminLTE/plugins/iCheck/all.css',
        'public/plugins/AdminLTE/plugins/colorpicker/bootstrap-colorpicker.min.css',
        'public/plugins/AdminLTE/plugins/datepicker/bootstrap-datepicker.min.css',
        'public/plugins/AdminLTE/plugins/daterangepicker/daterangepicker.css',
        'public/plugins/eonasdan-bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css',
        'public/plugins/bootstrap-fileinput/css/fileinput.min.css',
        'public/plugins/AdminLTE/plugins/select2/select2.min.css',
        'public/plugins/AdminLTE/plugins/ionslider/ion.rangeSlider.css',
        'public/plugins/AdminLTE/plugins/ionslider/ion.rangeSlider.skinNice.css',
        'public/plugins/bootstrap-switch/dist/css/bootstrap3/bootstrap-switch.min.css',
        'public/plugins/fontawesome-iconpicker/dist/css/fontawesome-iconpicker.min.css',
        'public/plugins/bootstrap-duallistbox/dist/bootstrap-duallistbox.min.css',
        'public/plugins/AdminLTE/dist/css/skins/_all-skins.min.css',
        'public/plugins/AdminLTE/bootstrap/css/bootstrap.min.css',
        'public/plugins/font-awesome/css/font-awesome.min.css',
        'public/plugins/laravel-admin/laravel-admin.css',
        'public/plugins/nprogress/nprogress.css',
        'public/plugins/sweetalert2/dist/sweetalert2.css',
        'public/plugins/nestable/nestable.css',
        'public/plugins/toastr/build/toastr.min.css',
        'public/plugins/bootstrap3-editable/css/bootstrap-editable.css',
        'public/plugins/google-fonts/fonts.css',
        'public/plugins/AdminLTE/dist/css/AdminLTE.min.css',
        'public/plugins/AdminLTE/plugins/tel-input/build/css/intlTelInput.css',
        'public/plugins/AdminLTE/plugins/DataTables/datatables.min.css',
        'public/plugins/AdminLTE/plugins//tel-input/build/css/intlTelInput.css',
    ], 'public/css/alladmin.css')
    .copy('public/plugins/AdminLTE/bootstrap/fonts/glyphicons-halflings-regular.woff2', 'public/css/fonts/')
    .copy('public/plugins/AdminLTE/bootstrap/fonts/glyphicons-halflings-regular.woff', 'public/css/fonts/')
    .copy('public/plugins/AdminLTE/bootstrap/fonts/glyphicons-halflings-regular.ttf', 'public/css/fonts/')
    .copy('public/plugins/AdminLTE/bootstrap/fonts/glyphicons-halflings-regular.eot', 'public/css/fonts/')
    .copy('public/plugins/AdminLTE/bootstrap/fonts/glyphicons-halflings-regular.svg', 'public/css/fonts/')
    .copy('public/plugins/AdminLTE/bootstrap/fonts/glyphicons-halflings-regular.woff2', 'public/fonts/')
    .copy('public/plugins/AdminLTE/bootstrap/fonts/glyphicons-halflings-regular.woff', 'public/fonts/')
    .copy('public/plugins/AdminLTE/bootstrap/fonts/glyphicons-halflings-regular.ttf', 'public/fonts/')
    //google fonts
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Bold.ttf', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro.ttf', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Semibold.ttf', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Bold.woff', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro.woff', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Semibold.woff', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Bold.woff2', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro.woff2', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Light.woff2', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Semibold.woff2', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Light.woff', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Italic.woff2', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Italic.woff', 'public/css/fonts/')
    .copy('public/plugins/google-fonts/fonts/Source-Sans-Pro-Italic.ttf', 'public/css/fonts/')
    //font awesome
    .copy('public/plugins/font-awesome/fonts/fontawesome-webfont.woff', 'public/fonts/')
    .copy('public/plugins/font-awesome/fonts/fontawesome-webfont.ttf', 'public/fonts/')
    .copy('public/plugins/font-awesome/fonts/fontawesome-webfont.woff2', 'public/fonts/')
    //all css
    .copy('public/plugins/AdminLTE/plugins/iCheck/square/_all.css', 'public/css/square/')
    .copy('public/plugins/AdminLTE/plugins/iCheck/minimal/_all.css', 'public/css/minimal/')
    .copy('public/plugins/AdminLTE/plugins/iCheck/polaris/polaris.css', 'public/css/polaris')
    .copy('public/plugins/AdminLTE/plugins/iCheck/line/_all.css', 'public/css/line/')
    .copy('public/plugins/AdminLTE/plugins/iCheck/square/blue.css', 'public/css/square/')
    .copy('public/plugins/AdminLTE/plugins/iCheck/flat/_all.css', 'public/css/flat/')
    .copy('public/plugins/AdminLTE/plugins/iCheck/futurico/futurico.css', 'public/css/futurico')
    .setResourceRoot('../');

//.sourceMaps();