<?php

use Illuminate\Support\Facades\Route;


Route::get('/clear', function() {
    Artisan::call('cache:clear');
    Artisan::call('config:cache');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    return redirect('/');
});

// Route::get('/key-genrate', function() {
// 	$exitCode = Artisan::call('key:generate');
// });
/*
|--------------------------------------------------------------------------
| Admin Panel Routes
|--------------------------------------------------------------------------
|
| Here is where you can register Admin routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "Admin" middleware group. Now create something great!
|
*/
Auth::routes();



Route::prefix('admin')->group(function () {
	Route::middleware(['auth'])->group(function () {
	//Admin user Routes after login
	Route::get('/dashboard', [App\Http\Controllers\Admin\AdminController::class,'dashboard'])->name('admin.dashboard');
    Route::post('/productSaleReport', [App\Http\Controllers\Admin\AdminController::class,'productSaleReport']);
	Route::get('/profile', [App\Http\Controllers\Admin\AdminController::class,'Profile'])->name('user.profile');
	Route::post('/profile', [App\Http\Controllers\Admin\AdminController::class,'updateProfile'])->name('user.profile');
	Route::post('/adminStatus', [App\Http\Controllers\Admin\AdminController::class,'adminStatus'])->name('user.adminStatus');
	Route::resource('user', App\Http\Controllers\Admin\AdminController::class);
	
	//Admin roles Routes after login
	Route::resource('/role', App\Http\Controllers\Admin\RoleController::class);
	Route::post('/roleStatus', [App\Http\Controllers\Admin\RoleController::class,'roleStatus'])->name('admin.roleStatus');
	
	//Admin permissions Routes after login
	Route::resource('/permission', App\Http\Controllers\Admin\PermissionController::class);

	//Menu Routes after login
	Route::resource('/menu', App\Http\Controllers\Admin\MenuController::class);

	//Languages Routes after login
	Route::resource('/language', App\Http\Controllers\Admin\LanguageController::class);
	Route::post('/defaultlanguage', [App\Http\Controllers\Admin\LanguageController::class,'defaultLanguage'])->name('admin.defaultlanguage');
	Route::post('/languageStatus', [App\Http\Controllers\Admin\LanguageController::class,'languageStatus'])->name('admin.languageStatus');
	//Languages Routes after login
	Route::resource('/customer', App\Http\Controllers\Admin\CustomerController::class);
	Route::post('/customerStatus', [App\Http\Controllers\Admin\CustomerController::class,'customerStatus'])->name('customer.customerStatus');
	Route::get('/customerProfile/{id}', [App\Http\Controllers\Admin\CustomerController::class,'customerProfile']);
	//Categories Routes after login
	Route::resource('/category', App\Http\Controllers\Admin\CategoriesController::class);
	Route::get('/subCategory', [App\Http\Controllers\Admin\CategoriesController::class,'subCategory'])->name('subCategory');

    Route::resource('/brand', App\Http\Controllers\Admin\BrandController::class);
	//Products Routes after login
	Route::get('product/inventory', [App\Http\Controllers\Admin\ProductsController::class,'inventory'])->name('product.inventory');
	Route::post('product/inventory', [App\Http\Controllers\Admin\ProductsController::class,'addInventory'])->name('product.inventory');
	Route::post('product/addminmax', [App\Http\Controllers\Admin\ProductsController::class,'addminmax'])->name('product.addminmax');
	Route::get('product/inventory/ajax_min_max/{id}', [App\Http\Controllers\Admin\ProductsController::class,'ajax_min_max']);
	Route::get('product/inventory/ajax_attr/{id}', [App\Http\Controllers\Admin\ProductsController::class,'ajax_attr']);
	Route::post('product/inventory/currentstock', [App\Http\Controllers\Admin\ProductsController::class,'currentstock']);
	//ProductAttribute
	Route::get('product/productAttribute/{id}', [App\Http\Controllers\Admin\ProductsController::class,'addProductAttribute']);
	Route::post('product/getOptionsValue', [App\Http\Controllers\Admin\ProductsController::class,'getOptionsValue']);
	Route::post('product/productAditionalAttribute', [App\Http\Controllers\Admin\ProductsController::class,'productAditionalAttribute']);
	Route::post('product/productAditionalAttributeEdit', [App\Http\Controllers\Admin\ProductsController::class,'productAditionalAttributeEdit']);
	Route::post('product/productAditionalAttributeUpdate', [App\Http\Controllers\Admin\ProductsController::class,'productAditionalAttributeUpdate']);
	Route::post('product/defaultOption', [App\Http\Controllers\Admin\ProductsController::class,'defaultOption'])->name('product.defaultOption');
	
	Route::DELETE('product/productAditionalAttributeDestroy/{product_id}/{attribute_id}', [App\Http\Controllers\Admin\ProductsController::class,'productAditionalAttributeDestroy']);
	
	Route::resource('/product', App\Http\Controllers\Admin\ProductsController::class);
	Route::post('/productStatus', [App\Http\Controllers\Admin\ProductsController::class,'productStatus'])->name('product.productStatus');
	
	
	Route::get('product/images/{id}', [App\Http\Controllers\Admin\ProductsController::class,'images']);
	Route::get('product/createImage/{id}', [App\Http\Controllers\Admin\ProductsController::class,'createImage']);
	Route::post('product/storeImage', [App\Http\Controllers\Admin\ProductsController::class,'storeImage'])->name('product.storeImage');
	Route::get('product/editImage/{id}', [App\Http\Controllers\Admin\ProductsController::class,'editImage']);
    Route::post('product/updateImage', [App\Http\Controllers\Admin\ProductsController::class,'updateImage'])->name('product.updateImage');
    Route::post('product/statusImage', [App\Http\Controllers\Admin\ProductsController::class,'statusImage'])->name('product.statusImage');
    Route::DELETE('product/destroyImage/{id}', [App\Http\Controllers\Admin\ProductsController::class,'destroyImage']);
    //Product Attribute routes
    Route::resource('attribute', App\Http\Controllers\Admin\ProductAttributesController::class);
    Route::get('attribute/values/{id}', [App\Http\Controllers\Admin\ProductAttributesController::class,'values']);
	Route::post('attribute/storeValue', [App\Http\Controllers\Admin\ProductAttributesController::class,'storeValue'])->name('attribute.storeValue');
	Route::get('attribute/editValue/{id}', [App\Http\Controllers\Admin\ProductAttributesController::class,'editValue']);
    Route::post('attribute/updateValue', [App\Http\Controllers\Admin\ProductAttributesController::class,'updateValue'])->name('attribute.updateValue');
    Route::DELETE('attribute/destroyValue/{id}', [App\Http\Controllers\Admin\ProductAttributesController::class,'destroyValue']);
  
    Route::resource('/order', App\Http\Controllers\Admin\OrdersController::class);
  
    Route::resource('/coupon', App\Http\Controllers\Admin\CouponsController::class);
   
    Route::resource('/payment', App\Http\Controllers\Admin\PaymentsController::class);
    //Tax Location routes
    Route::resource('/country', App\Http\Controllers\Admin\CountriesController::class);
    Route::resource('/zone', App\Http\Controllers\Admin\ZonesController::class);
	//Menu Routes after login
	Route::get('/logs', [App\Http\Controllers\Admin\MenuController::class,'logs'])->name('admin.logs');
	Route::post('/deleteLogs/{id?}', [App\Http\Controllers\Admin\MenuController::class,'deleteLogs'])->name('admin.deleteLogs');
	Route::get('markAsRead', [App\Http\Controllers\Admin\NotificationController::class,'markAsRead'])->name('admin.markAsRead');
	//Slider Routes
	Route::resource('slider', App\Http\Controllers\Admin\SlidersController::class);
	Route::post('/slider', [App\Http\Controllers\Admin\SlidersController::class,'Status'])->name('slider.status');
	//News routes
	Route::resource('news', App\Http\Controllers\Admin\NewsController::class);
	Route::post('/news', [App\Http\Controllers\Admin\NewsController::class,'Status'])->name('news.status');
	
	Route::resource('gift', App\Http\Controllers\Admin\GiftController::class);
	Route::get('gift/colors/{id}', [App\Http\Controllers\Admin\GiftController::class,'colors']);
	Route::post('gift/storeColor', [App\Http\Controllers\Admin\GiftController::class,'storeColor'])->name('gift.storeColor');
	Route::DELETE('gift/destroyColor/{id}', [App\Http\Controllers\Admin\GiftController::class,'destroyColor']);
  
	//Settings Routes
	Route::get('generalSettings', [App\Http\Controllers\Admin\SettingsController::class,'generalSettings'])->name('generalSettings');
	Route::post('generalSettings', [App\Http\Controllers\Admin\SettingsController::class,'updateGeneralSettings'])->name('generalSettings');
	Route::get('socialSettings', [App\Http\Controllers\Admin\SettingsController::class,'socialSettings'])->name('socialSettings');
	Route::post('socialSettings', [App\Http\Controllers\Admin\SettingsController::class,'updatesocialSettings'])->name('socialSettings');
	Route::get('socialLinks', [App\Http\Controllers\Admin\SettingsController::class,'socialLinks'])->name('socialLinks');
	Route::post('socialLinks', [App\Http\Controllers\Admin\SettingsController::class,'updateSocialLinks'])->name('socialLinks');
	
	//Content Pages Routes after login
	Route::resource('/page', App\Http\Controllers\Admin\PagesController::class);
	Route::post('/pageStatus', [App\Http\Controllers\Admin\PagesController::class,'pageStatus'])->name('page.pageStatus');
	
	//Database Baclup Routes
	Route::get('backup', [App\Http\Controllers\Admin\BackupController::class,'index'])->name('backup.index');
    Route::put('backup/create', [App\Http\Controllers\Admin\BackupController::class,'create'])->name('backup.store');
    Route::get('backup/download/{file_name?}', [App\Http\Controllers\Admin\BackupController::class,'download'])->name('backup.download');
    Route::delete('backup/delete/{file_name?}', [App\Http\Controllers\Admin\BackupController::class,'delete'])->where('file_name', '(.*)')->name('backup.destroy');

	//Logout user
	Route::post('logout', [App\Http\Controllers\Auth\LoginController::class,'logout'])->name('logout');
	});
});


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// Route::get('welcome/{locale}', function ($locale) {
//     App::setLocale($locale);
// });
    //Change Language
    Route::get('/testMail', [App\Http\Controllers\Web\AlertController::class, 'testMail']);
   
	Route::post('/changeLanguage', [App\Http\Controllers\Web\WebSettingController::class, 'changeLanguage']);
	Route::get('/notify', [App\Http\Controllers\Web\CustomerController::class, 'notify'])->name('web.notify');

	Route::get('/', [App\Http\Controllers\Web\DefaultController::class, 'index'])->name('web.index');
	Route::get('/brands', [App\Http\Controllers\Web\DefaultController::class, 'brands']);
	//Products Routes
	Route::get('/shop', [App\Http\Controllers\Web\ProductController::class, 'shop']);
	Route::get('/product/{slug}', [App\Http\Controllers\Web\ProductController::class, 'product']);
	Route::post('/getquantity', [App\Http\Controllers\Web\ProductController::class, 'productQuantity']);
	Route::post('/filterProducts', [App\Http\Controllers\Web\ProductController::class, 'filterProducts']);
	//Cart Roputes
	Route::post('/addToCart', [App\Http\Controllers\Web\CartController::class, 'addToCart']);
	Route::post('/addToCartFixed', [App\Http\Controllers\Web\CartController::class, 'addToCartFixed']);
	Route::post('/addToCartResponsive', [App\Http\Controllers\Web\CartController::class, 'addToCartResponsive']);
	Route::get('/viewCart', [App\Http\Controllers\Web\CartController::class, 'viewCart'])->name('web.viewCart');
	Route::post('/updateCart', [App\Http\Controllers\Web\CartController::class, 'updateCart'])->name('web.updateCart');
	Route::get('/cartButton', [App\Http\Controllers\Web\CartController::class, 'cartButton']);
	Route::get('/deleteCart', [App\Http\Controllers\Web\CartController::class, 'deleteCart']);
	Route::post('/addGift', [App\Http\Controllers\Web\CartController::class, 'addGift'])->name('web.addGift');
	Route::get('/deleteGift', [App\Http\Controllers\Web\CartController::class, 'deleteGift']);
	
	Route::get('/contact-us', [App\Http\Controllers\Web\DefaultController::class, 'contactUs'])->name('web.contact-us');
	Route::post('/contactUs', [App\Http\Controllers\Web\DefaultController::class, 'processContactUs'])->name('web.contactUs');
	Route::get('/page', [App\Http\Controllers\Web\DefaultController::class, 'page']);
	Route::get('/news-detail/{slug}', [App\Http\Controllers\Web\DefaultController::class, 'newsDetail']);
	//Customers routes
	Route::post('/likeProduct', [App\Http\Controllers\Web\CustomerController::class, 'likeProduct']);
	
	//Customers routes about login
	Route::get('/signin', [App\Http\Controllers\Web\CustomerController::class, 'showLogin'])->name('web.signin');
	Route::post('/signin', [App\Http\Controllers\Web\CustomerController::class, 'login'])->name('web.signin');
	Route::post('/signup', [App\Http\Controllers\Web\CustomerController::class, 'signup'])->name('web.signup');
	
	Route::get('/showResetPasswordForm', [App\Http\Controllers\Web\PasswordController::class, 'showResetPasswordForm'])->name('web.showResetPasswordForm');
	Route::post('/sendResetLinkEmail', [App\Http\Controllers\Web\PasswordController::class, 'sendResetLinkEmail'])->name('web.sendResetLinkEmail');
    Route::get('resetPassword/{token}', [App\Http\Controllers\Web\PasswordController::class, 'showResetForm'])->name('web.resetPassword');
    Route::post('resetPassword', [App\Http\Controllers\Web\PasswordController::class, 'resetPassword'])->name('web.resetPassword');
	// Email Verification Routes...
    Route::get('email/verify', [App\Http\Controllers\Web\VerificationController::class, 'show'])->name('verification.notice');
    Route::get('email/verify/{id}/{hash}', [App\Http\Controllers\Web\VerificationController::class, 'verify'])->name('verification.verify');
    Route::get('email/resend', [App\Http\Controllers\Web\VerificationController::class, 'resend'])->name('verification.resend');

Route::group(['middleware' => 'customer.auth'], function() {
	Route::get('/home', [App\Http\Controllers\Web\DefaultController::class, 'home'])->name('web.home');
	//Orders route
	Route::get('/checkout', [App\Http\Controllers\Web\OrderController::class, 'checkout'])->name('web.checkout');
	Route::post('/checkout_shipping_address', [App\Http\Controllers\Web\OrderController::class, 'checkout_shipping_address'])->name('web.checkout_shipping_address');
	Route::post('/checkout_billing_address', [App\Http\Controllers\Web\OrderController::class, 'checkout_billing_address'])->name('web.checkout_billing_address');
	Route::post('/paymentComponent', [App\Http\Controllers\Web\OrderController::class, 'paymentComponent'])->name('web.paymentComponent');
	
	Route::post('/place_order', [App\Http\Controllers\Web\OrderController::class, 'place_order'])->name('web.place_order');
	
	//Customers routes after login
	Route::get('/orders', [App\Http\Controllers\Web\OrderController::class, 'orders'])->name('web.orders');
	Route::post('/updatestatus', [App\Http\Controllers\Web\OrderController::class, 'updateOrder'])->name('web.updatestatus');
	Route::get('/view-order/{id}', [App\Http\Controllers\Web\OrderController::class, 'viewOrder']);
	
	Route::get('/wishlist', [App\Http\Controllers\Web\CustomerController::class, 'wishlist'])->name('web.wishlist');
	Route::get('UnlikeMyProduct/{id}', [App\Http\Controllers\Web\CustomerController::class, 'unlikeMyProduct']);
	
	Route::get('/account', [App\Http\Controllers\Web\CustomerController::class, 'account'])->name('web.account');
	Route::post('/account', [App\Http\Controllers\Web\CustomerController::class, 'updateAccount'])->name('web.account');
	Route::get('/updatePassword', [App\Http\Controllers\Web\PasswordController::class, 'updatePassword'])->name('web.updatePassword');
	Route::post('/logout', [App\Http\Controllers\Web\CustomerController::class, 'logout'])->name('web.logout');
});