@extends('web.layout') @section('content')
<div class="content" style="transform: none; min-height: 775px;">
				<div class="container-fluid" style="transform: none;">
				    <form method="get" enctype="multipart/form-data" id="load_products_form">
				    @if(!empty(app('request')->input('search')))
                        <input type="hidden" name="search" value="{{ app('request')->input('search') }}">
                    @endif
                    @if(!empty(app('request')->input('category')))
                        <input type="hidden" name="category"
                               value="@if(app('request')->input('category')!='all'){{ app('request')->input('category') }} @endif">
                    @endif
                    <input type="hidden" name="load_products" value="1">
                    
                    <div class="row" style="transform: none;">
						<div class="col-md-5 col-lg-3 col-xl-3">
						@include('web.common.sidebar_shop')
						</div>
						<div class="col-md-7 col-lg-9 col-xl-9">

							<div class="row align-items-center pb-3">	
								<div class="col-12 d-md-block d-none custom-short-by">
									<h3 class="title pharmacy-title text-center">@lang('website.Shop The Full Collections')</h3>
								</div>
							</div>

							<div class="row" id="listing-products">
							    @if(count($products['product_data'])>0)
								@foreach ($products['product_data'] as $key=>$product)
								<div class="col-6 col-md-4 col-lg-4 col-xl-3 col-sm-6 product-custom">
	                                <div class="profile-widget">
										<div class="doc-img">
											<a href="{{URL::to('/product')}}/{{$product->slug}}" >
												<img class="img-fluid" alt="Product image" src="{{asset(''.$product->image)}}">
											</a>
											<a href="javascript:void(0)" class="fav-btn is_liked" product_id="{{ $product->id}}" ><i class="far fa-heart" @if($product->isLiked == 1) style="font-weight:600;color:#000;" @endif></i></a>
										</div>
											<div class="pro-content">
        									<h2 class="title"><a href="{{URL::to('/product')}}" tabindex="0">{{$product->name}}</a></h2>
        									<p class="speciality" style="min-height: 0px;">{{$product->short_description}}</p>
        									    @if(!empty($product->discount_price))	
            									<h3 class="title product-custom">{{$web_setting[0]->code}} {{ $product->discount_price+0 }}
            									<span class="price-strike">{{$web_setting[0]->code}} {{ $product->price+0 }}</span>
            									</h3>
            									@else
            										<h3 class="title">{{$web_setting[0]->code}} {{ $product->price+0 }}</h3>
            									@endif
        									<div class="row row-sm justify-content-center">
        										 <a href="{{URL::to('/product')}}/{{$product->slug}}" class="btn book-btn" tabindex="0">@lang('website.Buy Now')</a>
        									</div>
        								</div>
									</div>		
                            	</div>
								@endforeach
								@else
								<div class="col-12 d-md-block d-none custom-short-by">
									<h3 class="title pharmacy-title text-center">@lang('website.No product found search with different inputs')</h3>
								</div><br>
								@endif
                            </div>
                            <!--Load more pagination-->
                            <div class="row">
                                <div class="col-md-12 text-center">
								    <input id="page_number"  type="hidden" value="1" name="page_number">
								    <input id="record_limit" type="hidden" value="{{$result['limit']}}">
                                    <input id="total_record" type="hidden" value="{{$products['total_record']}}">
                                    <?php
                                        if(!empty(app('request')->input('limit'))){
                                            $record = app('request')->input('limit');
                                        }else{
                                            $record = 12;
                                        }
                                    ?>
    								<div class="load-more text-center" @if(count($products['product_data']) < $record )style="display:none"@endif>
            							<a class="btn btn-primary btn-sm" id="load_products" href="javascript:void(0);">Load More</a>	
            						</div>
                         	    </div>
                            </div>
                            <!--Load more pagination end--> 
						</div>
					</div>
					</form>
				</div>
			</div>
@endsection