@extends('web.layout') @section('content')

<div class="content">
				<div class="container-fluid">
				    <h1 class="text-center" style="margin-bottom:30px;">@lang('website.Shopping Bag') ({{$total_carts}} @lang('website.items'))</h1>	
				    @if(Session::has('message'))
                            <div class="row justify-content-center">
                                <div class="col-md-8"> 
                                    <div class="alert alert-dismissible" style="border:1px solid #000;">
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close">x</a>
                                    <strong>Success!</strong> {{ Session::get('message') }}
                                    </div>
                                </div>
                            </div>
                        @endif
					<div class="row">
					     
					    <?php $price = 0; ?>
						<div class="col-md-7 col-lg-9">
						    @if(count($result['cart'])>0)
						    <form method="POST" id="update_cart_form" action="{{ route('web.updateCart')}}" >
						        @csrf
					            <div class="card card-table">
						    <div class="card-body">
						    
							<div class="table-responsive">
								<table class="table table-hover table-center mb-0">
									<thead>
										<tr>
											<th>@lang('website.Product')</th>
											<th></th>
											<th>@lang('website.Price')</th>
											<th class="text-center">@lang('website.Quantity')</th>
											@if(count($gifts)>0)
											<th class="text-center">@lang('website.Send as Gift')</th>
											@endif
											<th class="text-center">@lang('website.Total')</th>
											<th></th>
										</tr>
									</thead>
									<tbody>
									    @foreach($result['cart'] as $products)
									    <?php 
                                        $price+= ($products->final_price * $products->basket_quantity) + ($products->basket_quantity * $products->gift_price);		
                                        ?>
                                        <input type="hidden" name="cart[]" value="{{$products->basket_id}}">
                                        <input type="hidden" name="gift_id[]" value="{{$products->gift_id}}">
                                        <tr>
											<td>
												<h2 class="table-avatar"><a href="{{URL::to('/product')}}/{{$products->slug}}" class="avatar avatar-sm mr-2"><img class="avatar-img" src="{{asset('').$products->image}}" alt="User Image"></a></h2>
											</td>
											<td>
											    <div class="pro-content text-left ">
												    <h3 class="title"><a href="{{URL::to('/product')}}/{{$products->slug}}">{{$products->name}}</a></h3>
												</div>
												<p class="mb-0" style="max-width: 250px;overflow: hidden;text-overflow: ellipsis;">{{$products->short_description}}</p>
												<div class="item-attributes">
                                                      @if(isset($products->attributes))
                                                      @foreach($products->attributes as $attributes)
                                                        <strong style="font-weight: 100;">{{$attributes->attribute_name}} :</strong> <small>{{$attributes->attribute_value}}</small>
                                                      @endforeach
                                                      @endif
                                                </div>
											</td>
											<td>{{$web_setting[0]->code}} {{ $products->final_price+0 }} </td>					
											<td class="text-center">
    											<div class="custom-increment cart">
    			                                    <div class="input-group1">
    				                                    <span class="input-group-btn qtyminus">
    				                                        <button type="button" class="qtyminus qtyminuscart btn btn-danger btn-number" data-type="minus" data-field="">
    				                                          <span><i class="fas fa-minus"></i></span>
    				                                        </button>
    				                                    </span>
    				                                    <input type="text"  readonly name="quantity[]" class="input-number qty" value="{{$products->basket_quantity}}" min="{{$products->min_order}}" max="{{$products->max_order}}">
    				                                    <span class="input-group-btn qtyplus">
    				                                        <button type="button" class="qtypluscart btn btn-success btn-number" data-type="plus" data-field="">
    				                                            <span><i class="fas fa-plus"></i></span>
    				                                        </button>
    				                                    </span>
    			                                	</div>
    		                        			</div>
											</td>
											<td class="text-center">
											    @if(!empty($products->gift_price) && !empty($products->gift_image))
											    <h2 class="table-avatar">
											        <a href="#" class="avatar avatar-sm"><img class="avatar-img" src="{{asset(''.$products->gift_image)}}" alt="Gift Image"></a>
											    </h2>
											    <div class="item-attributes">
                                                    <small>{{$web_setting[0]->code}} {{$products->gift_price+0}}</small>
                                                    <a href="{{ URL::to('/deleteGift?gift_id='.$products->gift_id.'&basket_id='.$products->basket_id)}}"><i class="fas fa-times"></i></a>
                                                </div>
                                                @else
                                                <input type="checkbox" name="gift" value="Yes" null class="option-input checkbox" product_id="{{$products->product_id}}" basket_id="{{$products->basket_id}}"><label></label>
                                                @endif
											</td>
										    <td class="text-center">{{$web_setting[0]->code}} {{($products->final_price * $products->basket_quantity) + ($products->basket_quantity*$products->gift_price)}}</td>
											<td class="text-right">
												<div class="table-action">
													<a href="{{ URL::to('/deleteCart?id='.$products->basket_id)}}" class="btn btn-sm"><i class="fas fa-times"></i></a>
												</div>
											</td>
										</tr>
										@endforeach
									</tbody>
								</table>		
							</div>
						
        										      
        									
						</div>
					</div>
					           <div class="row row-sm">
					               <div class="col-7 col-md-3 text-left">
            								<a href="{{URL::to('/shop')}}" class="btn book-btn" > @lang('website.< Continue Shopping') </a>
            						</div>
        		                    <div class="col-5 col-md-9 text-right">
            						    <button type="button" class="btn book-btn" id="update_cart">@lang('website.Update Cart')</button>
            						</div>
        						</div><br>
					</form>
                    @endif
					
					</div>
						<div class="col-md-5 col-lg-3 view-cart-header">
						    <div class="card booking-card gift" style="display:none;">
								<div class="card-header" style="background:#fff !important;">
									<h4 class="card-title text-center">@lang('website.Packaging & Gift Wrapping')</h4>
								</div>
								<div>
								<form method="POST" id="add_gift_packing" action="{{ route('web.addGift')}}" >
        						    <div class="shopping-gift show-cart">
        						        <input type="hidden" name="product_id"  value="" />
        						        <input type="hidden" name="basket_id"  value="" />
        								<ul class="shopping-cart-items list-unstyled">
        								    @foreach($gifts as $gift)
        									<li class="clearfix">
        										<img class="avatar-img rounded" src="{{asset(''.$gift->image)}}" alt="Gift Image">
        										<span class="item-name">{{$gift->description}}</span>
        									    <span class="item-price">{{$web_setting[0]->code}} {{$gift->price+0}}</span>
        									 </li>
        									<li style="border-bottom: 1px solid #e4e4e4;">
												<div class="clinic-booking">
													<select name="gift_color" class="custom-select" style="width: 90px;background-color: #fff;border: 4px solid #000;font-size: 13px;color: #000;padding: 1.5px 15px 1px 15px;height: 35px;margin-top: 3px;">
            									        <option value="">Color</option>
            									        @foreach($gift->colors as $color)
            									        <option value="{{$color->name}}">{{$color->name}}</option>
            									        @endforeach
            									    </select>
            									    <span class="item-quantity"><input type="radio" id="radio-{{$gift->id}}" name="gift_id" class="regular-radio" value="{{$gift->id}}" /><label for="radio-{{$gift->id}}">@lang('website.Select')</label></span>
												</div>
											</li>
                                            @endforeach
        								</ul>
        								<textarea class="form-control" name="gift_comments" placeholder="@lang('website.Gift message')..."></textarea>
        							    <div class="clinic-booking pt-4">
    										<a class="apt-btn add_gift_packing" href="javascript:void(0)">@lang('website.Add Gift Packing')</a>
    									</div>
        							</div>
        						</form>
					            </div>
							</div>
								
							<!-- Booking Summary -->
							<div class="card booking-card">
								<div class="card-header" style="background-color:#fff !important;">
									<h4 class="card-title text-center">@lang('website.Order Summary')</h4>
								</div>
								<div class="card-body">
									<div class="booking-summary">
										<div class="booking-item-wrap">
											<ul class="booking-date">
												<li>@lang('website.Subtotal') <span>{{$web_setting[0]->code}} {{$price+0}}</span></li>
												<li>@lang('website.Shipping Cost') <span>{{$web_setting[0]->code}} 0.00</span></li>
												<li>@lang('website.Tax') <span>{{$web_setting[0]->code}} 0.00</span></li>
											</ul>
										    <div class="booking-total">
										        <ul class="booking-total-list">
													<li>
														<span>@lang('website.Order Total')</span>
														<span class="total-cost">{{$web_setting[0]->code}} {{$price+0-number_format((float)session('coupon_discount'), 2, '.', '')}}</span>
													</li><br>
													<li>
														<div class="clinic-booking pt-4">
														    @if(Auth::guard('customer')->check())
															<a class="apt-btn" href="{{route('web.checkout')}}">@lang('website.Proceed to checkout')</a>
															@else
															<a class="apt-btn" href="{{route('web.signin')}}">@lang('website.Proceed to checkout')</a>
															@endif
														</div>
													</li>
												</ul>
											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- /Booking Summary -->
						</div>
					</div>
				</div>
			</div>
@endsection