@if ($paginator->hasPages())
<div class="col-md-12 text-center">
    <div class="row">
	    <div class="col-md-12">
			<div class="blog-pagination">
				<nav>
					<ul class="pagination justify-content-center">
					@if ($paginator->onFirstPage())
						<li class="page-item disabled"><a class="page-link" href="javascript:void(0);" ><i class="fas fa-angle-double-left"></i></a></li>
					@else
						<li class="page-item"><a class="page-link" href="{{ $paginator->previousPageUrl() }}" ><i class="fas fa-angle-double-left"></i></a></li>						
					@endif
					@foreach ($elements as $element)
                        {{-- "Three Dots" Separator --}}
                        @if (is_string($element))
                	        <li class="page-item disabled"><a class="page-link" href="javascript:void(0);">{{ $element }}</a></li>
                        @endif
                        {{-- Array Of Links --}}
                        @if (is_array($element))
                            @foreach ($element as $page => $url)
                                @if ($page == $paginator->currentPage())
                                	<li class="page-item active"><a class="page-link" href="javascript:void(0);">{{ $page }} <span class="sr-only"></span></a></li>
                                @else
                                    <li class="page-item"><a class="page-link" href="{{ $url }}">{{ $page }}</a></li>
                                @endif
                            @endforeach
                        @endif
                    @endforeach
					@if ($paginator->hasMorePages())
						<li class="page-item"><a class="page-link" href="{{ $paginator->nextPageUrl() }}"><i class="fas fa-angle-double-right"></i></a></li>
                    @else
                        <li class="page-item disabled"><a class="page-link" href="javascript:void(0);"><i class="fas fa-angle-double-right"></i></a></li>
                    @endif
					</ul>
				</nav>
			</div>
        </div>
    </div>
</div>
@endif