@extends('web.layout') @section('content')
<div class="content">
	<div class="container-fluid">
		<h1 class="text-center" style="margin-bottom:30px;">@lang('website.Total Liked') ({{count($result['products']['product_data'])}} @lang('website.items'))</h1>
		@if(Session::has('message'))
		<div class="row justify-content-center">
			<div class="col-md-8">
				<div class="alert alert-dismissible" style="border: 1px solid #000;">
					<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
					<strong>@lang('website.Success')!</strong> {{ Session::get('message') }}
				</div>
			</div>
		</div>
		@endif
		<div class="row">
			<div class="col-md-8 col-lg-8">
				<div class="card card-table">
					<div class="card-body">
						<div class="table-responsive">
							<table class="table table-hover table-center mb-0">
								<thead>
									<tr>
										<th>@lang('website.Product')</th>
										<th></th>
										<th>@lang('website.Price')</th>
										<th class="text-center">@lang('website.Total')</th>
										<th></th>
									</tr>
								</thead>
								<tbody>
									@if(!empty($result['products']['product_data']) and count($result['products']['product_data'])>0)
									@foreach($result['products']['product_data'] as $key=>$products)
									
									<tr>
										<td>
											<h2 class="table-avatar"><a href="{{URL::to('/product')}}/{{$products->slug}}" class="avatar avatar-sm mr-2"><img class="avatar-img" src="{{asset('').$products->image}}" alt="User Image"></a></h2>
										</td>
										<td>
											<div class="pro-content text-left ">
												<h3 class="title"><a href="{{URL::to('/product')}}/{{$products->slug}}">{{$products->name}}</a></h3>
											</div>
											<?php
											if(!empty($products->discount_price)){
											    $discount_price = $products->discount_price;
											}
											    $orignal_price = $products->price;
											if(!empty($products->discount_price)){
    											if(($orignal_price+0)>0){
        											$discounted_price = $orignal_price-$discount_price;
        											$discount_percentage = $discounted_price/$orignal_price*100;
    											}else{
        											$discount_percentage = 0;
        											$discounted_price = 0;
    											}
											}
											?>
											<small class="mb-0">{{$products->short_description}}</small>
											
										</td>
										<td>
											@if(!empty($products->discount_price))
											<span>{{$web_setting[0]->code}} {{$discount_price+0}}</span>
											<del>{{$web_setting[0]->code}} {{$orignal_price+0}}</del>
											@else
											<span><small>{{$web_setting[0]->code}}</small> {{$orignal_price+0}}</span>
										    @endif  </td>
										<td class="text-center">
											
										</td>
										<td class="text-center"><small>{{$web_setting[0]->code}}</small> {{$orignal_price}}</td>
										<td class="text-right">
											<div class="table-action">
												<a href="{{ URL::to('/UnlikeMyProduct')}}/{{$products->id}}" class="btn btn-sm"><i class="fas fa-times"></i></a>
											</div>
										</td>
									</tr>
									@endforeach
									@else
									<tr>
									    <td colspan="5" class="text-center">
									    <h5>@lang('website.No Record Found')</h5>
									</td>
        							
        							</tr>
        						@endif
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-4 col-lg-4">
			@include('web.common.sidebar_profile')
			</div>
		</div>
		<div class="row row-sm">
			<div class="col-12 col-md-3 col-lg-3 text-left">
				<a href="{{URL::to('/shop')}}" class="btn book-btn" >@lang('website.< Continue Shopping') </a>
			</div>
		</div>
	</div>
</div>
<br>
<section class="section">
	<div class="container-fluid">
		<div class="row ">
			<div class="col-12" style="background-image: url('images/WEB_BANNER.jpeg');background-position: center center;background-repeat: no-repeat;background-size: cover;background-attachment: scroll;min-height: 500px;">
				
				<!-- Blog Post -->
			</div>
			<div class="card-section absolute" style="width: 100%;height: auto;transform: translateY(-300%);top: 50%;z-index: 9;padding: 1rem;">
				<div class="container text-center">
					<h3 class="h2" style="color: #fff;text-shadow: 1px 1px 5px #4a4a4a;font-weight:100;font-family: 'Neutraface Diplay Light', sans-serif;">@lang('website.Enter the World of NS JEWELRY')</h3>
					<p></p>
					<a class="btn btn-primary" href="{{URL::to('shop')}}">@lang('website.Shop Now')</a>
				</div>
			</div>
			<!-- /Blog Post -->
		</div>
		
	</div>
	
	
	
</section>
@endsection