@extends('web.layout') @section('content')
<div class="content">
	<div class="container-fluid">
		<h1 class="text-center" style="margin-bottom:30px;">My Orders</h1>
		@if(Session::has('message'))
		<div class="row justify-content-center">
			<div class="col-md-8">
				<div class="alert alert-dismissible" style="background-color: #ded9cf;">
					<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
					<strong>Success!</strong> {{ Session::get('message') }}
				</div>
			</div>
		</div>
		@endif
		@error('order_id')
		<div class="row justify-content-center">
			<div class="col-md-8">
				<div class="alert alert-dismissible" style="background-color: #ded9cf;">
					<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
					<strong>Error !</strong> {{ $message }}
				</div>
			</div>
		</div>
		@enderror
		@error('status')
		<div class="row justify-content-center">
			<div class="col-md-8">
				<div class="alert alert-dismissible" style="background-color: #ded9cf;">
					<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
					<strong>Error !</strong> {{ $message }}
				</div>
			</div>
		</div>
		@enderror
		<div class="row">
			
			<?php $price = 0; ?>
			<div class="col-md-8 col-lg-8">
			
					<div class="card card-table">
						<div class="card-body">
							
							<div class="table-responsive">
								<table class="table table-hover table-center mb-0">
									<thead>
										<tr>
											<th>@lang('website.Order ID')</th>
											<th>@lang('website.Order Date')</th>
											<th>@lang('website.Price')</th>
											<th>@lang('website.Status')</th>
										</tr>
									</thead>
									<tbody>
										@if(count($orders) > 0)
										@foreach($orders as $order)
										<tr>
											<th>{{$order->id}}</th>
											<td>{{ date('d M Y', strtotime($order->created_at))}}</td>
											<td>{{$order->currency}} {{$order->order_price}}</td>
											<td>
												@if($order->status == 'Completed')
												<span class="badge badge-success">{{$order->status}}</span>
												@elseif($order->status == 'Cancelled')
												<span class="badge badge-danger">{{$order->status}} </span>
												@elseif($order->status == 'Confirmed')
												<span class="badge badge-primary">{{$order->status}}</span>&nbsp;&nbsp;/&nbsp;&nbsp;
												@else
                                                <span class="badge badge-warning">{{$order->status}}</span>&nbsp;&nbsp;/&nbsp;&nbsp;
												<form action="{{ route('web.updatestatus')}}" method="post" style="display: inline-block">
												    @csrf
													<input type="hidden" name="order_id" value="{{$order->id}}">
													<input type="hidden" name="status" value="Cancelled">
													<button type="submit" class="btn book-btn" style="text-transform:capitalize; cursor:pointer">@lang('website.Cancel Order') </button>
												</form>
												@endif
											</td>
											<td class="text-right">
												<div class="table-action">
													<a href="{{ URL::to('/view-order/'.$order->id)}}" class="btn book-btn">@lang('website.View Order')</a>
												</div>
											</td>
										</tr>
										@endforeach
										@else
										<tr>
											<td colspan="5">@lang('website.No order is placed yet')</td>
										</tr>
										@endif
									</tbody>
								</table>
							</div>
							
							
							
						</div>
					</div>
					<div class="row row-sm">
					    <div class="col-6 col-md-3 text-left">
								<a href="{{URL::to('/shop')}}" class="btn book-btn" > @lang('website.< Continue Shopping') </a>
						</div>
						<div class="col-6 col-md-9 text-right">
							<button type="button" class="btn book-btn" id="update_cart">@lang('website.Update Cart')</button>
						</div>
					</div><br>
				
				
			</div>
			<div class="col-md-4 col-lg-4">
			@include('web.common.sidebar_profile')
			</div>
		</div>
	
	</div>
</div>
@endsection