@extends('web.layout') @section('content')
<div class="content" style="transform: none; min-height: 775px;">
	<div class="container-fluid" style="transform: none;">
		@if(Session::has('message'))
		<div class="row justify-content-center">
			<div class="col-md-8">
				<div class="alert alert-dismissible" style="background-color: #ded9cf;">
					<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
					<strong>Success!</strong> {{ Session::get('message') }}
				</div>
			</div>
		</div>
		@endif
		<div class="row" style="transform: none;">
			<div class="col-md-8 col-lg-8 theiaStickySidebar" style="position: relative; overflow: visible; box-sizing: border-box; min-height: 1px;">
				<div class="theiaStickySidebar" style="padding-top: 0px; padding-bottom: 1px; position: static; transform: none; left: 1011.5px; top: 0px;">
					<div class="card booking-card" style="border:none;box-shadow: 0 0 30px rgb(0 0 0 / 20%);border-radius: 10px;">
						<div class="card-header">
							<h3 class="card-title">@lang('website.Order Information')</h3>
						</div>
						<div class="card-body">
						    <div class="row invoice-info">
                                <div class="col-sm-4 invoice-col">
                                  <strong>@lang('website.Shipping Info')</strong>
                                   <address>
                                        {{ $orders[0]->delivery_street_address }} <br>
                                        {{ $orders[0]->delivery_city }}, {{ $orders[0]->delivery_state }} {{ $orders[0]->delivery_postcode }}, {{ $orders[0]->delivery_country }}<br>
                                        @lang('website.Phone'): {{ $orders[0]->delivery_phone }}<br>
                                        @lang('website.Shipping Method'): {{ $orders[0]->shipping_method }} <br>
                                        @lang('website.Shipping Cost'):  @if(!empty($orders[0]->shipping_cost)) {{$web_setting[0]->code}} {{ $orders[0]->shipping_cost }} @endif           
                                    </address>
                                </div>
                                <div class="col-sm-4 invoice-col">
                                    <strong>@lang('website.Billing Info')</strong>
                                    <address>
                                        {{$orders[0]->billing_name}}<br>
                                        {{ $orders[0]->billing_street_address }}<br>
                                        @lang('website.Phone'): {{$orders[0]->billing_phone}}<br>
                                        {{$orders[0]->billing_city }}, {{ $orders[0]->billing_state }} {{ $orders[0]->billing_postcode }}, {{ $orders[0]->billing_country }}
                                    </address>
                                </div>
                                <div class="col-sm-4 invoice-col">
                                    <strong>@lang('website.Payment/Shipping Method')</strong>
                                   <address>
                                    {{ $orders[0]->name }}<br>
                                    {{ $orders[0]->street_address }} <br>
                                    {{ $orders[0]->city }}, {{ $orders[0]->state }} {{ $orders[0]->postcode }}, {{ $orders[0]->country }}<br>
                                    @lang('website.Phone'): {{ $orders[0]->phone }}<br>
                                    @lang('website.Email'): {{ $orders[0]->email }}
                                  </address>
                                </div>
                              </div>
							<div class="table-responsive">
								<table class="table table-center mb-0">
									<tbody><tr>
									    <th>@lang('website.Product')</th>
									    <th></th>
										<th>@lang('website.Quantity')</th>
										<th>@lang('website.Payment Method')</th>
										<th></th>
										<th class="text-right">@lang('website.Total')</th>
									</tr>
								</tbody>
								<tbody>
								     <?php $price = 0;?>
								    @if(count($orders) > 0)
                                    @foreach( $orders[0]->products as $products)
                                    <?php $price+= $products->final_price; ?>
							        <tr>
							            <td><h2 class="table-avatar avatar avatar-sm mr-2"><img class="avatar-img" src="{{asset('').$products->image}}" alt="User Image"></h2></td>
							            <td>{{$products->product_name}}<br>
							                <small></msall>
										    <div class="item-attributes">
                                                @if(isset($products->attributes))
                                                @foreach($products->attributes as $attributes)
                                                    <strong>{{$attributes->product_option}}</strong>: <small>{{$attributes->product_option_value}}</small>
                                                @endforeach
                                                @endif
                                            </div>
										</td>
										<td>{{$products->product_quantity }}</td>
										<td>{{$orders[0]->payment_method}}</td>
										
										<td>
										    @if($products->gift_price > 0)
										    <span style="font-size: 12px;color: #000;width: 100%;">@lang('website.Gift Color')</span><small> {{$products->gift_color}}</small><br>
										    <span style="font-size: 12px;color: #000;width: 100%;">@lang('website.Gift Price')</span><small> {{$web_setting[0]->code}} {{$products->gift_price}}</small><br>
										    <span style="font-size: 12px;color: #000;width: 100%;">@lang('website.Comments')</span><small> {{$products->gift_comments}}</small>
										    @endif
										</td>
										<td class="text-right">{{$web_setting[0]->code}} {{$products->final_price}}</td>
									</tr>
									@endforeach
                                    @endif
								</tbody>
							</table>
						</div>
						<div class="booking-summary">
							<div class="booking-item-wrap">
							<div class="booking-total">
									<ul class="booking-total-list">
										<li>
											<span>@lang('website.Total')</span>
											<span class="total-cost">{{$web_setting[0]->code}} {{$orders[0]->order_price}}</span>
										</li>
									</ul>
								</div>
							</div>
						</div>
						<div class="booking-summary pt-5">
						<div class="row">
                        <div class="col-xs-12 col-sm-12">
                            @if(count($orders[0]->statusess)>0)
                                <div style="border-radius:5px;"class="card">
                                    <div style="background: none;" class="card-header">
                                      @lang('website.Comments')
                                    </div>
                                    <div class="card-body">
                                        @foreach($orders[0]->statusess as $key=>$statusess)
                                            @if(!empty($statusess->comments))
                                                @if(++$key==1)
                                                  <h6>@lang('website.Order Comments'): {{ date('d M Y', strtotime($statusess->date_added))}}</h6>
                                                @else
                                                  <h6>@lang('website.Admin Comments'): {{ date('d M Y', strtotime($statusess->date_added))}}</h6>
                                                @endif
                                                <p class="card-text">{{$statusess->comments}}</p>
                                            @endif
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                    </div>
				</div>
				</div>
				<div class="resize-sensor" style="position: absolute; inset: 0px; overflow: hidden; z-index: -1; visibility: hidden;">
					<div class="resize-sensor-expand" style="position: absolute; left: 0; top: 0; right: 0; bottom: 0; overflow: hidden; z-index: -1; visibility: hidden;">
						<div style="position: absolute; left: 0px; top: 0px; transition: all 0s ease 0s; width: 485px; height: 1121px;">
							
						</div>
					</div>
					<div class="resize-sensor-shrink" style="position: absolute; left: 0; top: 0; right: 0; bottom: 0; overflow: hidden; z-index: -1; visibility: hidden;">
						<div style="position: absolute; left: 0; top: 0; transition: 0s; width: 200%; height: 200%">
							
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="col-md-4 col-lg-4">
		@include('web.common.sidebar_profile')
			<div class="row row-sm">
        				<div class="col-12 text-left">
        					<a href="{{URL::to('/shop')}}" class="btn book-btn" >@lang('website.< Continue Shopping') </a><br>
        				</div>
        		    </div>
		</div>
		
	</div>
</div>

</div>

<section class="section">
	<div class="container-fluid">
		<div class="row ">
			<div class="col-12" style="background-image: url('images/WEB_BANNER.jpeg');background-position: center center;background-repeat: no-repeat;background-size: cover;background-attachment: scroll;min-height: 500px;">
			</div>
			<div class="card-section absolute" style="width: 100%;height: auto;transform: translateY(-300%);top: 50%;z-index: 9;padding: 1rem;">
				<div class="container text-center">
					<h3 class="h2" style="color: #fff;text-shadow: 1px 1px 5px #4a4a4a;font-weight:100;font-family: 'Neutraface Diplay Light', sans-serif;">Enter the World of Sartoro</h3>
					<p></p>
					<a class="btn btn-primary" href="{{URL::to('shop')}}">Shop Now</a>
				</div>
			</div>
			<!-- /Blog Post -->
		</div>
	</div>
</section>
@endsection