@extends('web.layout')
@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div><h2 class="footer-title">@lang('website.Account Details')</h2></div>
    </div><br>
    @if(Session::has('message'))
    <div class="row justify-content-center">
        <div class="col-md-8"> 
            <div class="alert alert-dismissible" style="background-color: #ded9cf;">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
            <strong>Success!</strong> {{ Session::get('message') }}
            </div>
        </div>
    </div>
    @endif
    <div class="row justify-content-center">
               
        <div class="col-md-8 col-lg-4 ">
            <div class="card login-card">
                <div class="card-header">@lang('website.Update')</div>
                <div class="card-body">
                    <form method="POST" action="{{ route('web.account') }}">
                        @csrf
                        <div class="form-group row">
                            <label for="email" class="col-md-12 col-form-label">@lang('website.First Name')</label>
                            <div class="col-md-12">
                                <input type="text" class="form-control @error('first_name') is-invalid @enderror" name="first_name" value="{{ Auth::guard('customer')->user()->first_name }}" autocomplete="first_name" autofocus>
                                @error('first_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                            </div>
                        </div>
                       <div class="form-group row">
                            <label for="email" class="col-md-12 col-form-label">@lang('website.Last Name')</label>
                            <div class="col-md-12">
                                <input type="text" class="form-control @error('last_name') is-invalid @enderror" name="last_name" value="{{ Auth::guard('customer')->user()->last_name }}" autocomplete="last_name" autofocus>
                                @error('last_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="email" class="col-md-12 col-form-label">@lang('website.E-Mail Address')</label>
                            <div class="col-md-12">
                                <input  type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ Auth::guard('customer')->user()->email }}" autocomplete="email" autofocus>
                                @error('email')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="email" class="col-md-12 col-form-label">@lang('website.Phone')</label>
                            <div class="col-md-12">
                                <input type="text"  class="form-control @error('phone') is-invalid @enderror" name="phone" value="{{substr(Auth::guard('customer')->user()->phone, 4) }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" oninput="javascript: if (this.value.length > 8) this.value = this.value.slice(0, this.maxLength);">
                                @error('phone')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="password" class="col-md-12 col-form-label">@lang('website.Password')</label>
                            <div class="col-md-12">
                                <input type="password" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="current-password">
                                @error('password')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                            </div>
                        </div>
                        
                        <div class="form-group row mb-0">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">@lang('website.Save Changes')</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-4 col-lg-4">
            @include('web.common.sidebar_profile')
        </div>
    </div>
    
</div>
<section class="section">
			<div class="container-fluid">
				<div class="row ">
				    <div class="col-12" style="background-image: url(https://sartorojewelry.com/wp-content/uploads/2021/02/WEB_BANNER_1800x846px_4.jpg);background-position: center center;background-repeat: no-repeat;background-size: cover;background-attachment: scroll;min-height: 500px;">
				        
						<!-- Blog Post -->
					</div>
					<div class="card-section absolute" style="width: 100%;height: auto;transform: translateY(-300%);top: 50%;z-index: 9;padding: 1rem;">
				            <div class="container text-center">
				                <h3 class="h2" style="color: #fff;text-shadow: 1px 1px 5px #4a4a4a;font-weight:100;font-family: 'Neutraface Diplay Light', sans-serif;">@lang('website.Enter the World of NS JEWELRY')</h3>
				                <p></p>
				                <a class="btn btn-primary" href="{{URL::to('shop')}}">@lang('website.Shop Now')</a>
                            </div>
                        </div>
						<!-- /Blog Post -->
					</div>
				
				</div>
		
				
			</div>
		</section>
@endsection
