@extends('web.layout') @section('content')
		<section class="section section-blogs">
			<div class="container-fluid">
				<!-- Section Header -->
				<div class="section-header text-center">
					<h2>@lang('website.The Brand')</h2>
				</div>
				<!-- /Section Header -->
				<div class="row blog-grid-row">
				    @foreach ($brands as $brand)
					<div class="col-md-4 col-lg-4 col-sm-6">
						<!-- Blog Post -->
						<div class="blog grid-blog">
							<div class="blog-image">
								<a href="{{URL::to('/shop')}}?brand={{$brand->slug}}">
								    @if(
								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'jpeg' || 
								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'JPEG' ||
								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'jpg'  ||
								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'JPG'  ||
								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'png'  || 
								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'PNG'  || 
								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'gif'  || 
								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'svg') 
									<img class="img-fluid" src="{{asset(''.$brand->image)}}" alt="Post Image">
									@else
									<video playsinline="" autoplay="" muted="" loop="" poster="" id="herovid" style="width:100%;">
                                        <source src="{{asset(''.$brand->image)}}" type="video/webm">
                                    </video>
									@endif
									
								</a>
							</div>
							<div class="blog-content">
								<h3 class="blog-title"><a href="{{URL::to('/shop')}}?brand={{$brand->slug}}">{{$brand->name}}</a></h3>
							</div>
						</div>
						<!-- /Blog Post -->
					</div>
					@endforeach
				</div>
			</div>
		</section>
		<section class="section">
			<div class="container-fluid">
				<div class="row ">
				    <div class="col-12" style="background-image: url('images/WEB_BANNER.jpeg');background-position: center center;background-repeat: no-repeat;background-size: cover;background-attachment: scroll;min-height: 500px;">
					</div>
					<div class="card-section absolute" style="width: 100%;height: auto;transform: translateY(-300%);top: 50%;z-index: 9;padding: 1rem;">
				            <div class="container text-center">
				                <h3 class="h2" style="color: #fff;text-shadow: 1px 1px 5px #4a4a4a;font-weight:100;font-family: 'Neutraface Diplay Light', sans-serif;">Enter the World of Sartoro</h3>
				                <p></p>
				                <a class="btn btn-primary" href="{{URL::to('shop')}}">@lang('website.Shop Now')</a>
                            </div>
                        </div>
					</div>
				</div>
		    </div>
		</section>
@endsection