<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta name="color-scheme" content="light">
<meta name="supported-color-schemes" content="light">
<style>
    /* Base */

body,
body *:not(html):not(style):not(br):not(tr):not(code) {
    box-sizing: border-box;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif,
    'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    position: relative;
}

body {
    -webkit-text-size-adjust: none;
    background-color: #ffffff;
    color: #718096;
    height: 100%;
    line-height: 1.4;
    margin: 0;
    padding: 0;
    width: 100% !important;
}
.body {
    -premailer-cellpadding: 0;
    -premailer-cellspacing: 0;
    -premailer-width: 100%;
    background-color: #edf2f7;
    border-bottom: 1px solid #edf2f7;
    border-top: 1px solid #edf2f7;
    margin: 0;
    padding: 0;
    width: 100%;
}

.inner-body {
    -premailer-cellpadding: 0;
    -premailer-cellspacing: 0;
    -premailer-width: 570px;
    background-color: #ffffff;
    border-color: #e8e5ef;
    border-radius: 2px;
    border-width: 1px;
    box-shadow: 0 2px 0 rgba(0, 0, 150, 0.025), 2px 4px 0 rgba(0, 0, 150, 0.015);
    margin: 0 auto;
    padding: 0;
    width: 570px;
}

.content {
    min-height: 200px;
}

.container-fluid {
    width: 100%;
    margin-right: auto;
    margin-left: auto;
}
.text-center{
    text-align:center;
}
.row {
    display: -ms-flexbox;
    display: flex;
    -ms-flex-wrap: wrap;
    flex-wrap: wrap;
    margin-right: -15px;
    margin-left: -15px;
}
.col, .col-1, .col-10, .col-11, .col-12, .col-2, .col-3, .col-4, .col-5, .col-6, .col-7, .col-8, .col-9, .col-auto, .col-lg, .col-lg-1, .col-lg-10, .col-lg-11, .col-lg-12, .col-lg-2, .col-lg-3, .col-lg-4, .col-lg-5, .col-lg-6, .col-lg-7, .col-lg-8, .col-lg-9, .col-lg-auto, .col-md, .col-md-1, .col-md-10, .col-md-11, .col-md-12, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6, .col-md-7, .col-md-8, .col-md-9, .col-md-auto, .col-sm, .col-sm-1, .col-sm-10, .col-sm-11, .col-sm-12, .col-sm-2, .col-sm-3, .col-sm-4, .col-sm-5, .col-sm-6, .col-sm-7, .col-sm-8, .col-sm-9, .col-sm-auto, .col-xl, .col-xl-1, .col-xl-10, .col-xl-11, .col-xl-12, .col-xl-2, .col-xl-3, .col-xl-4, .col-xl-5, .col-xl-6, .col-xl-7, .col-xl-8, .col-xl-9, .col-xl-auto {
    position: relative;
    width: 100%;
    padding-right: 15px;
    padding-left: 15px;
}

.ml-auto, .mx-auto {
    margin-left: auto!important;
}
.text-right {
    text-align: right!important;
}
.invoice-content {
    background-color: #fff;
    border: 1px solid #f0f0f0;
    border-radius: 4px;
    margin-bottom: 30px;
    padding: 10px;
}
.invoice-item .invoice-logo {
    margin-bottom: 30px;
}
.invoice-item .invoice-logo img {
    width: auto;
    max-height: 52px;
}
.invoice-item .invoice-details {
    color: #757575;
    font-weight: 500;
}
p {
    margin-top: 0;
    margin-bottom: 1rem;
}
.invoice-item .invoice-details-two {
    text-align: left;
}
.invoice-info.invoice-info2 {
    text-align: right;
}
.invoice-item .invoice-details strong {
    color: #272b41;
}
strong {
    font-weight: bolder;
}
.invoice-info {
    margin-bottom: 30px;
}

.table {
    color: #272b41;
    max-width: 100%;
    margin-bottom: 0;
    width: 100%;
}
.table thead tr th {
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
}
.table th {
    vertical-align: top;
}
.table thead th {
    vertical-align: bottom;
}
.table-bordered th, .table-bordered td {
    border-color: rgba(0, 0, 0, 0.05);
}
.table-bordered {
    border: 1px solid rgba(0, 0, 0, 0.05) !important;
}
table {
    border-collapse: collapse;
}

.table-responsive {
    display: block;
    width: 100%;
    overflow-x: auto;
}
.other-info {
    margin-top: 10px;
}
.text-muted {
    color: #757575 !important;
}
.invoice-table-two {
    margin-bottom: 0;
}
.invoice-table tr th, .invoice-table tr td, .invoice-table-two tr th, .invoice-table-two tr td {
    color: #272b41;
    font-weight: 600;
    padding: 10px 20px;
    line-height: inherit;
}
.invoice-table-two tr td {
    text-align: right;
}
.invoice-item .customer-text {
    font-size: 18px;
    color: #272b41;
    font-weight: 600;
    margin-bottom: 0px;
    display: block;
}
/* Utilities */

.break-all {
    word-break: break-all;
}
@media only screen and (max-width: 767.98px){
    .content {
        padding: 15px 0 0;
    }
    .invoice-item .customer-text {
        font-size: 16px;
    }
    .invoice-item .invoice-details {
        text-align: left;
    }
    .container-fluid {
        padding-left: 15px;
        padding-right: 15px;
    }
}

@media (min-width: 768px){
    .col-md-12 {
        -ms-flex: 0 0 100%;
        flex: 0 0 100%;
        max-width: 100%;
    }
    .col-md-6 {
        -ms-flex: 0 0 50%;
        flex: 0 0 50%;
        max-width: 50%;
    }
}

@media only screen and (max-width: 600px) {
        .inner-body {
        width: 100% !important;
        }
        .footer {
        width: 100% !important;
        }
    }
    
@media only screen and (max-width: 575.98px){
    body {
        font-size: 0.8125rem;
    }
    .invoice-content {
    padding: 10px;
}
}

@media only screen and (max-width: 500px) {
        .button {
        width: 100% !important;
        }
    }
    
</style>
</head>
<body>
      <div class="content body" style="min-height: 168px;">
           <div class="row">
                <div class="col-md-12 text-center">
                    <h1>
                      <img src="{{asset('images/site/'.$settings[2]->value)}}" alt="logo" style="max-width:200px">  
                    </h1>
                    
                    </div>
                </div>
				<div class="container">
                    <div class="row">
						<div class="col-lg-8 offset-lg-2">
							<div class="invoice-content">
								<div class="invoice-item">
									<div class="row">
										<div class="col-md-6">
											<p class="invoice-details text-left">
												<strong>Order ID:</strong> {{ $ordersData['orders_data'][0]->order_id }} <br>
												<strong>Order Date:</strong> {{ date('m/d/Y', strtotime($ordersData['orders_data'][0]->created_at)) }}
											</p>
										</div>
										<div class="col-md-6">
											<div class="invoice-info invoice-info2">
												<strong class="customer-text">Payment Method</strong>
												<p class="invoice-details">{{ str_replace('_',' ', $ordersData['orders_data'][0]->payment_method) }}</p>
											</div>
										</div>
										
									</div>
								</div>
								
								<!-- Invoice Item -->
								<div class="invoice-item">
									<div class="row">
										<div class="col-md-6">
											<div class="invoice-info">
												<strong class="customer-text">Shipping Info</strong>
												<p class="invoice-details invoice-details-two">
													{{ $ordersData['orders_data'][0]->delivery_name }} <br>
													{{ $ordersData['orders_data'][0]->delivery_street_address }} <br>
													{{ $ordersData['orders_data'][0]->delivery_city }}, {{ $ordersData['orders_data'][0]->delivery_state }} {{ $ordersData['orders_data'][0]->delivery_postcode }}, {{ $ordersData['orders_data'][0]->delivery_country }}<br>
                                                    Phone: {{ $ordersData['orders_data'][0]->delivery_phone }}
												</p>
											</div>
										</div>
										<div class="col-md-6">
											<div class="invoice-info invoice-info2">
												<strong class="customer-text">Billing Info</strong>
												<p class="invoice-details">
													{{ $ordersData['orders_data'][0]->billing_name }}<br>
													{{ $ordersData['orders_data'][0]->billing_street_address }}<br>
													{{ $ordersData['orders_data'][0]->billing_city }}, {{ $ordersData['orders_data'][0]->billing_state }}, {{ $ordersData['orders_data'][0]->billing_postcode }}, {{ $ordersData['orders_data'][0]->billing_country }}<br>
                                                    Phone: {{ $ordersData['orders_data'][0]->billing_phone }}
												</p>
											</div>
										</div>
									</div>
								</div>
								<!-- /Invoice Item -->
								
								
								
								<!-- Invoice Item -->
								<div class="invoice-item invoice-table-wrap">
									<div class="row">
										<div class="col-md-12" style="margin-right:0px;margin-left:0px;">
											<div class="table-responsive">
												<table class="invoice-table table table-bordered">
													<thead>
														<tr>
														    <th class="text-center">Image</th>
															<th class="text-left">Product</th>
															<th class="text-center">Qty</th>
															<th class="text-center">Additional Attributes</th>
															<th class="text-right">Total</th>
														</tr>
													</thead>
													<tbody>
													    @foreach($ordersData['orders_data'][0]->data as $key=>$products)
														<tr>
															<td class="text-center"><img src="{{ asset('').$products->image }}" width="60px"> </td></td>
															<td class="text-center">{{  $products->product_name }}</td>
															<td class="text-center">{{  $products->product_quantity }}</td>
															<td class="text-left">
															    @foreach($products->attribute as $attributes)
                                                                <b>Name:</b> {{ $attributes->product_option }}<br>
                                                                <b>Value:</b> {{ $attributes->product_option_value }}<br>
                                                                <b>Price:</b> {{ $attributes->price_prefix }}{{ $attributes->option_value_price }}<br>
                                                                @endforeach
                                                            </td>
                                                            <td class="text-right">{{ $ordersData['orders_data'][0]->currency }} {{ $products->final_price }}</td>
														</tr>
														@endforeach
													
													</tbody>
												</table>
											</div>
										</div>
										
									</div>
									<div clss="row">
									    @if(!empty($ordersData['orders_data'][0]->coupon_code))
									    <div class="col-md-6 col-xl-4 ">
									        <strong>Coupons</strong>
									        <div class="table-responsive">
												<table class="invoice-table-two table">
												    <thead>
												        <tr>
												            <th>Code</th>
												            <th>Amount</th>
												        </tr>
												    </thead>
													<tbody>
													    @foreach( json_decode($ordersData['orders_data'][0]->coupon_code) as $couponData)
    													<tr>
    														<td>{{ $couponData->code}}</td>
    														<td><span>{{ $ordersData['orders_data'][0]->currency }} {{ $couponData->amount}} </span></td>
    														<td>
    														    @if($couponData->discount_type=='percent_product')
                                                                    (Percent)
                                                                @elseif($couponData->discount_type=='percent')
                                                                    (Percent)
                                                                @elseif($couponData->discount_type=='fixed_cart')
                                                                    (Fixed)
                                                                @elseif($couponData->discount_type=='fixed_product')
                                                                    (Fixed)
                                                                @endif
                                                            </td>
    													</tr>
												        @endforeach
													</tbody>
												</table>
											</div>
									    </div>
									    @endif
									    <div class="col-md-6 col-xl-4 ml-auto">
											<div class="table-responsive">
												<table class="invoice-table-two table">
													<tbody>
													<tr>
														<th>Subtotal:</th>
														<td><span>{{ $ordersData['orders_data'][0]->currency }} {{ $ordersData['subtotal'] }}</span></td>
													</tr>
													<tr>
														<th>Shipping Cost:</th>
														<td><span>{{ $ordersData['orders_data'][0]->currency }} {{ $ordersData['orders_data'][0]->shipping_cost }}</span></td>
													</tr>
													@if(!empty($ordersData['orders_data'][0]->coupon_code))
													<tr>
														<th>Dicount Coupon:</th>
														<td><span>{{ $ordersData['orders_data'][0]->currency }} {{ $ordersData['orders_data'][0]->coupon_amount }}</span></td>
													</tr>
													@endif
													<tr>
														<th>Total Amount:</th>
														<td><span>{{ $ordersData['orders_data'][0]->currency }} {{ $ordersData['orders_data'][0]->order_price }}</span></td>
													</tr>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
								<!-- /Invoice Item -->
								<!-- Invoice Information -->
								<div class="other-info">
									<h4>Other information</h4>
									<p class="text-muted mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus sed dictum ligula, cursus blandit risus. Maecenas eget metus non tellus dignissim aliquam ut a ex. Maecenas sed vehicula dui, ac suscipit lacus. Sed finibus leo vitae lorem interdum, eu scelerisque tellus fermentum. Curabitur sit amet lacinia lorem. Nullam finibus pellentesque libero.</p>
								</div>
								<!-- /Invoice Information -->
							</div>
						</div>
					</div>

				</div>

			</div>  
            <div class="row">
                <div class="col-md-12 text-center">
                    <p>© {{ date('Y') }} {{ config('app.name') }}. @lang('All rights reserved.')</p>
                </div>
            </div><br>
</body>
</html>


