@extends('auth.app') @section('content')
<div class="login-box">
    <div class="login-logo">
        <a href="{{route('login')}}"><b>{{ config('app.name') }} Admin</b></a>
    </div>
    <!-- /.login-logo -->
    <div class="login-box-body">
        <p class="login-box-msg">{{ __('Reset Password') }}</p>
        <form method="POST" action="{{ route('password.update') }}">
            {{ csrf_field() }}
            <input type="hidden" name="token" value="{{ $token }}">

            <div class="form-group  @error('email') has-error @enderror">
                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus>
                <span class="glyphicon glyphicon-envelope form-control-feedback"></span> @error('email')
                <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span>@enderror
            </div>
            <div class="form-group @error('password') has-error @enderror">
                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
                <span class="glyphicon glyphicon-lock form-control-feedback"></span> @error('password')
                <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span>@enderror
            </div>
            <div class="form-group @error('password') has-error @enderror">
                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                <span class="glyphicon glyphicon-lock form-control-feedback"></span> @error('password')
                <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span>@enderror
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <div class="checkbox icheck">
                        <label>
                                <input type="checkbox" name="remember" value="1" {{ old('remember') ? 'checked' : '' }} >
                                {{ __('Remember Me') }}
                            </label>
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-xs-6">

                    <button type="submit" class="btn btn-primary btn-block btn-flat">{{ __('Reset Password') }}</button>
                </div>
                <!-- /.col -->
            </div>
        </form>
        <div class="row">
            <div class="col-md-12 text-center">
                <a href="{{ route('login') }}">Back</a>
            </div>
        </div>
    </div>
    <!-- /.login-box-body -->
</div>

@endsection