@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Zones<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li> Zones</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['zone.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('zone.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['zone.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{ url('/admin/zone') }}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover  grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['zone.edit','zone.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID<a class="fa fa-fw fa-sort" href="#"></a></th>
                                        <th>Name</th>
                                        <th>Name (العربية)</th>
                                        <th>Code</th>
                                        <th>Country</th>
                                        <th>Created At</th>
                                        <th>Updated At</th>
                                        @canany(['zone.edit','zone.destroy','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($zones as $key=>$zone)
                                    <tr data-key="{{ $zone->id }}">
                                    @canany(['zone.destroy','all'])
                                        <td class="column-__row_selector__"><input type="checkbox" class="grid-row-checkbox" data-id="{{ $zone->id }}" style="position: absolute; opacity: 0;"></td>
                                    @endcanany
                                        <td>{{ $zone->id }}</td>
                                        <td>{{ $zone->name }}</td>
                                        <td>{{ $zone->name_ar }}</td>
                                        <td>{{ $zone->code }}</td>
                                        <td>{{ $zone->c_name }}</td>
                                        <td>{{ date('Y-m-d',strtotime($zone->created_at)) }}</td>
                                        <td>{{ date('Y-m-d',strtotime($zone->updated_at)) }}</td>
                                    @canany(['zone.edit','zone.destroy','all'])
                                        <td class="column-__actions__">
                                            <a href="{{ route('zone.edit',$zone->id) }}"><i class="fa fa-edit"></i></a>&nbsp;
                                            <a data-id="{{ $zone->id }}" route="{{ route('zone.destroy',$zone->id) }}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                        </td>
                                    @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div> 
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection