@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Categories<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Sliders</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['slider.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('slider.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['slider.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{url('public/admin/slider')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['slider.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Title</th>
                                        <th>Image</th>
                                        <th>Type</th>
                                        <th>Added/Modified Date</th>
                                        <th>Language</th>
                                        @canany(['user.edit','all'])
                                        <th class="column-__actions__">Status</th>
                                        @endcanany
                                        @canany(['slider.destroy','slider.edit','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sliders as $slider)
                                    <tr data-key="{{ $slider->id }}">
                                        @canany(['slider.destroy','slider.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $slider->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td class="column-id">{{ $slider->id }}</td>
                                        <td class="column-name">{{ $slider->title }}</td>
                                        <td><img src="{{asset('').$slider->image}}" width="200px" alt=""></td>
                                        <td>{{$slider->type}}</td>
                                        <td>
                                            <strong>Added Date:</strong>{{ date('d M Y',strtotime($slider->created_at)) }}<br>
                                            <strong>Modified Date:</strong> {{ date('d M Y',strtotime($slider->updated_at)) }} <br>
                                            <strong>Expiry Date:</strong> {{ date('d M Y',strtotime($slider->expires_date)) }}
                                        </td>
                                        <td>@if($slider->language_id=='en') English @else العربية @endif</td>
                                        @canany(['slider.edit','all'])
                                        <td class="column-updated_at">
                                            <div class="status-toggle"> 
                                                <input type="checkbox" route="{{ route('slider.status') }}" id="{{ $slider->id }}" class="check"  value="{{ $slider->id }}" @if($slider->status=='Active') checked @endif>
                                                <label for="{{ $slider->id }}" class="checktoggle change_status">checkbox</label>
                                            </div>                                      
                                        </td>
                                       @endcanany
                                        @canany(['slider.destroy','slider.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['slider.edit','all'])
                                            <a href="{{route('slider.edit',$slider->id)}}"><i class="fa fa-edit"></i></a>&nbsp;
                                            @endcan
                                            @canany(['slider.destroy','all'])
                                            <a data-id="{{ $slider->id }}" route="{{route('slider.destroy',$slider->id)}}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                             @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection