@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Roles<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li> Roles</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['role.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('role.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['role.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{ url('/public/admin/role') }}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['role.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th class="column-id">ID</th>
                                        <th class="column-admin_type">Admin Roles</th>
                                        <th class="column-name">Slug</th>
                                        <th class="column-permissions">Permissions</th>
                                        <th class="column-created_at">Created At</th>
                                        <th class="column-updated_at">Updated At</th>
                                        @canany(['role.destroy','role.edit','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($roles as $role)
                                    <tr data-key="{{ $role->id }}">
                                        @canany(['role.destroy','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $role->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td class="column-id">
                                            {{ $role->id }}
                                        </td>
                                        <td class="column-name">
                                            {{ $role->name }}
                                        </td>
                                        <td class="column-slug">
                                            {{ $role->slug }}
                                        </td>
                                        <td class="column-roles">
                                            <div class="btn-group" style="margin-right: 10px">
                                                <a href="#" class="btn btn-xs btn-twitter" title="Export"><span class="hidden-xs">Permission List</span></a>
                                                <button type="button" class="btn btn-xs btn-twitter dropdown-toggle" data-toggle="dropdown">
                                                    <span class="caret"></span>
                                                    <span class="sr-only"></span>
                                                </button>
                                                <ul class="dropdown-menu" role="menu" style="max-height: 250px;overflow: hidden;overflow-y: scroll;">
                                                    @foreach($role->permissions as $permission)
                                                    <li><a href="#">{{ $permission->name }}</a></li>
                                                    @endforeach
                                                </ul>
                                            </div>

                                        </td>
                                        <td class="column-created_at">
                                            {{ date('Y-m-d',strtotime($role->created_at)) }}
                                        </td>
                                        <td class="column-updated_at">
                                            {{ date('Y-m-d',strtotime($role->updated_at)) }}
                                        </td>
                                        @canany(['role.destroy','role.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['role.edit','all'])
                                            <a href="{{ route('role.edit',$role->id) }}"><i class="fa fa-edit"></i></a>&nbsp; @endcanany 
                                            @canany(['role.destroy','all'])
                                            <a data-id="{{ $role->id }}" route="{{ route('role.destroy',$role->id) }}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a> 
                                            @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection