@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>
                Product Inventory
                <small>Create</small>
            </h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>
                    Auth
                </li>
                <li>
                    Inventory
                </li>
                <li>
                    Create
                </li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <!-- /.box-header -->
                        <!-- form start -->
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-6">
                                        <div class="box-header with-border">
                                            <h3 class="box-title" style="color:#525f7f;">Add Stock</h3>
                                        </div>
                        
                                        <form action="{{ route('product.inventory') }}" method="POST" name="addewinventoryfrom" id="addewinventoryfrom" class="form-horizontal form-validate" accept-charset="UTF-8" enctype="multipart/form-data">
                                        {{ csrf_field() }}
                                                                 
                                        <div class="form-group @error('product_id') has-error @enderror ">
                                            <label for="roles" class="control-label ">Products</label>
                                            <select class="form-control field-validate product-type select2" name="product_id">
                                                <option value="">Choose Product</option>
                                                @foreach ($result['products'] as $pro)
                                                <option value="{{$pro->id}}" @if(old('product_id') == $pro->id) selected @endif>{{$pro->name}}</option>
                                                @endforeach
                                            </select>
                                            @error('product_id')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        <div id="attribute" style="display:none">

                                        </div>
                                        <div class="form-group">
                                           <label for="name" class="col-sm-8 col-md-8 control-label " style="text-align:left;">Current Stock</label>
                                            <div class="col-sm-4 col-md-4 text-right">
                                                <p id="current_stocks" style="width:100%">{{$result['stocks']}}</p><br>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="name" class="col-sm-8 col-md-8 control-label" style="text-align:left;">Total Purchase Price</label>
                                            <div class="col-sm-4 col-md-4 text-right">
                                                <p class="purchase_price_content" style="width:100%">@if(!empty($setting[0]->code)) {{$setting[0]->code}} @endif<span id="total_purchases">{{$result['purchase_price']}}</span></p><br>
                                            </div>
                                        </div>
                                        <div class="form-group  @error('stock') has-error @enderror">
                                            <label for="name" class="asterisk control-label">Enter Stock</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="stock" class="form-control stock-validate" value="{{ old('stock') ? : '1' }}" autocomplete="off">
                                                </div>
                                            @error('stock') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        <div class="form-group @error('purchase_price') has-error @enderror">
                                                <label for="name" class=" asterisk control-label">Purchase Price</label>
                                                <div class="input-group">
                                                        <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                        <input type="text" name="purchase_price" value="{{ old('purchase_price') ? : '1' }}" class="form-control price-validate" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off">
                                                    </div>
                                                    @error('purchase_price')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                            <div class="form-group @error('reference_code') has-error @enderror">
                                                <label for="name" class="control-label">Reference / Purchase Code</label>
                                                    <div class="input-group">
                                                        <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                        <input type="text" name="reference_code" class="form-control" value="{{old('reference_code') ? : '0' }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57">
                                                    </div>
                                                @error('reference_code')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                            <div class="form-group" >
                                                @if(count($result['products'])> 0)
                                                    @if(count($result['attributes'])>0 and $result['products'][0]->type=='Variable' or $result['products'][0]->type=='Simple')
                                                    <div class="box-footer text-center">
                                                        <button type="submit" id="attribute-btn" class="btn btn-primary pull-right">Add Stock</button>
                                                    </div>
                                                    @endif
                                                @endif
                                                
                                            </div>
                                        </div>
                                       
                                    </form>
                                        <div class="col-md-6">
                                    <div class="box-header with-border">
                                        <h3 class="box-title" style="color:#525f7f;">Manage Min/Max Quantity</h3>
                                    </div>
                                    <form action="{{ route('product.addminmax') }}" method="POST" id="addminmax" name="addminmax" class="form-horizontal form-validate-level model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" >
                                        {{ csrf_field() }}
                                        <input class="form-control check_reference_id" id="inventory_ref_id" name="inventory_ref_id" type="hidden" value="">
                                        <input class="form-control check_reference_id" id="inventory_pro_id" name="product_id" type="hidden" value="">
                                        @error('product_id')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        @error('inventory_ref_id')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        <div class="form-group  @error('min_level') has-error @enderror">
                                            <label for="password" class="asterisk control-label">Min Level</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-eye-slash fa-fw"></i></span>
                                                    <input type="text" name="min_level" id="min_level" class="form-control number-validate-level" value="{{old('min_level') ? : '0' }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off">
                                                </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">Please enter min quantity level for the product.</span>
                                                @error('min_level')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        <div class="form-group  @error('max_level') has-error @enderror">
                                            <label for="password" class="asterisk control-label">Min Level</label>
                                          
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-eye-slash fa-fw"></i></span>
                                                    <input type="text" name="max_level" id="max_level" class="form-control number-validate-level" value="{{old('max_level') ? : '0' }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off">
                                                </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom: 0;">Please enter max  quantity level for the product.</span>
                                                @error('max_level')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        <div class="alert alert-danger alert-dismissible" id="minmax-error" role="alert" style="display: none">
                                            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            This stock is not asscociated with any attributes. Please choose products attributes first.
                                        </div>
                                         <div class="form-group">
                                            
                                                @if(count($result['products'])> 0)
                                                <div class="box-footer text-center">
                                                    <button type="submit" class="btn btn-primary pull-right">Submit</button>
                                                </div>
                                                @endif
                                            
                                        </div>
                                    </form>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                          
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection