@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Products<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Products</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['product.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('product.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['product.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{url('public/admin/product')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['product.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Image</th>
                                        <th>Product</th>
                                        <th>Other</th>
                                        <th>Price</th>
                                        <th>Vendor</th>
                                        @canany(['product.edit','all'])
                                        <th>Status</th>
                                        @endcanany
                                        @canany(['product.destroy','product.edit','all'])
                                        <th>Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($products as $product)
                                    <tr data-key="{{ $product->id }}">
                                        @canany(['product.destroy','product.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $product->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{ $product->id }}</td>
                                        <td><img src="{{asset('').$product->image}}" width="100px" alt=""></td>
                                        <td>
                                            <strong>Name: </strong>{{ $product->name }}<br>
                                            <strong>Type: </strong>{{ $product->type }}<br>
                                            <strong>Liked: </strong>{{ $product->liked }}<br>
                                            @if(!empty($product->special_id))
                                            <strong class="badge bg-yellow">Special Price: </strong> QR {{ $product->special_price }}<br>
                                                @if(($product->special_id) !== null)
                                                        @if($product->expires_date > strtotime(date('Y-m-d')))
                                                         <strong class="badge bg-light-blue">Expiry Date:</strong>
                                                            {{ date('Y-m-d', $product->expires_date) }}
                                                         @else
                                                        <strong class="badge bg-red">Expired</strong>
                                                        {{ date('Y-m-d', $product->expires_date) }}
                                                        @endif 
                                                @endif
                                            @endif
                                        </td>
                                        <td>
                                            <Strong>Category:</Strong> {{ $product->category_name }}<br>
                                            <Strong>current Stock:</Strong> {{ $product->in_stock =  $product->out_stock }}
                                        </td>
                                        <td>QR {{ $product->price }}</td>
                                        <td>{{ $product->first_name }} {{ $product->last_name }}</td>
                                         @canany(['product.edit','all'])
                                        <td class="column-updated_at">
                                            <div class="status-toggle"> 
                                                <input type="checkbox" route="{{ route('product.productStatus') }}" id="{{ $product->id }}" class="check"  value="{{ $product->id }}" @if($product->status=='Active') checked @endif>
                                                <label for="{{ $product->id }}" class="checktoggle change_status">checkbox</label>
                                            </div>                                      
                                        </td>
                                       @endcanany
                                        @canany(['product.destroy','product.edit','all'])
                                        <td class="column-__actions__">
                                           <div class="btn-group" style="margin-right: 10px">
                                                <a href="#" class="btn btn-xs btn-twitter" title="Export"><span class="hidden-xs">Action</span></a>
                                                <button type="button" class="btn btn-xs btn-twitter dropdown-toggle" data-toggle="dropdown">
                                                    <span class="caret"></span>
                                                    <span class="sr-only"></span>
                                                </button>
                                                <ul class="dropdown-menu" role="menu">
                                                    @canany(['product.edit','all'])
                                                    <li><a href="{{route('product.edit',$product->id)}}">Edit Product</a></li>
                                                    @if($product->type=='Variable')
                                                    <li><a href="{{URL::to('admin/product/productAttribute')}}/{{$product->id}}">Product Attributes</a></li>
                                                    @endif
                                                    <li><a href="#">Add Inventory</a></li>
                                                    <li><a href="{{URL::to('admin/product/images')}}/{{$product->id}}">Product Images</a></li>
                                                    @endcanany
                                                    @canany(['product.destroy','all'])
                                                    <li><a data-id="{{ $product->id }}" route="{{route('product.destroy',$product->id)}}" href="#" class="grid-batch-0" >Delete Product</a></li>
                                                    @endcanany
                                                </ul>
                                            </div>
                                            
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection