@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Products<small>Create</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>Auth</li>
                <li>Products</li>
                <li>Update</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update</h3>
                            
                                <div class="btn-group pull-right" style="margin-right: 5px">
                                    <a href="{{ route('product.index') }}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><span
                                            class="hidden-xs">&nbsp;List</span></a>
                                </div>
                            
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form action="{{ route('product.update',$product->id) }}" method="post" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                        {{ csrf_field() }}
                        {{ method_field('PATCH') }}
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-6">
                                        <div class="form-group @error('type') has-error @enderror">
                                            <label for="name" class=" control-label">Product Type</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control" name="type">
                                                        <option value="Simple"   @if($product->type == 'Simple') selected @endif>Simple</option>
                                                        <option value="Variable" @if($product->type == 'Variable') selected @endif>Variable</option>
                                                        <option value="External" @if($product->type == 'External') selected @endif>External</option>
                                                    </select>
                                                </div>
                                                @error('type') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                        </div>
                                        <div class="form-group  @error('parent_id') has-error @enderror">
                                            <label for="name" class=" asterisk control-label">Categories</label>
                                                <ul class="list-group list-group-root well">    
                                                    @foreach ($categories as $category)                                    
                                                    <li href="#" class="list-group-item">
                                                        <label style="width:100%">
                                                        <input @if(in_array($category->id,$mainCategories)) checked @endif id="categories_<?=$category->id?>" type="checkbox" class=" required_one categories" name="categories[]" value="{{ $category->id }}" > 
                                                        {{ $category->name }}
                                                        </label>
                                                    </li>
                                                    @if($category->subCategories)
                                                        <ul class="list-group">
                                                            <li class="list-group-item">
                                                                @foreach ($category->subCategories as $child)
                                                                <label>
                                                                    <input @if(in_array($child->sub_id,$subCategories)) checked @endif type="checkbox" name="categories[]" class="required_one sub_categories sub_categories_<?=$child->sub_id?>" parents_id = '<?=$category->id?>' value="{{ $child->sub_id }}"> 
                                                                    {{ $child->sub_name }}
                                                                </label>
                                                                @endforeach
                                                            </li>
                                                        </ul>
                                                    @endif
                                                    @endforeach                                          
                                                </ul>     
                                        </div>
                                        @foreach($description as $description_data)
                                        <div class="form-group  @error('name_'.$description_data['language_id']) has-error @enderror">
                                            <label for="name" class="asterisk control-label">Name ({{ $description_data['language_name'] }})</label>
                                            
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" id="name" name="name_<?=$description_data['language_id']?>" class="form-control name"  value="{{$description_data['name']}}" autocomplete="off" autofocus>
                                                </div>
                                                @error('name_'.$description_data['language_id']) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            
                                        </div>
                                        @endforeach
                                        @foreach($description as $description_data)
                                        <div class="form-group  @error('short_description_'.$description_data['language_id']) has-error @enderror">
                                            <label for="name" class="  control-label">Short Description ({{ $description_data['language_name'] }})</label>
                                            
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" id="name" name="short_description_<?=$description_data['language_id']?>" class="form-control name"  value="{{$description_data['short_description']}}" autocomplete="off" autofocus>
                                                </div>
                                                @error('short_description_'.$description_data['language_id']) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            
                                        </div>
                                        @endforeach
                                        @foreach($description as $description_data)
                                        <div class="form-group  @error('description_'.$description_data['language_id']) has-error @enderror">
                                            <label for="name" class="asterisk control-label">Description ({{ $description_data['language_name'] }})</label>
                                            
                                                
                                                    <textarea  name="description_<?=$description_data['language_id']?>" class="form-control editer{{$description_data['language_id']}}" placeholder="Input Description" autocomplete="off" autofocus>{{ $description_data['description'] }}</textarea>
                                                
                                                @error('description_'.$description_data['language_id']) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            
                                        </div>
                                        @endforeach
                                        
                                       
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                                <label for="name" class="control-label">Brand</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control" name="brand_id">
                                                        <option value="">Select Brand</option>
                                                        @foreach($brands as $brand)
                                                        <option value="{{$brand->id}}" @if($brand->id == $product->brand_id) selected @endif>{{$brand->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                        </div>
                                        <div class="form-group  @error('price') has-error @enderror">
                                            <label for="name" class=" asterisk control-label">Price</label>
                                            
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="price" class="form-control" value="{{ $product->price }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" autofocus>
                                                </div>
                                                @error('price') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            
                                        </div>
                                        <div class="form-group  @error('min_order') has-error @enderror">
                                            <label for="name" class=" asterisk control-label">Min Order Limit</label>
                                            
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="min_order" class="form-control number-validate" value="{{ $product->min_order }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" autofocus>
                                                </div>
                                                @error('min_order') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            
                                        </div>
                                        <div class="form-group  @error('max_stock') has-error @enderror">
                                            <label for="name" class="asterisk control-label">Max Order Limit</label>
                                            
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="max_stock" class="form-control" value="{{ $product->max_stock }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" autofocus>
                                                </div>
                                                @error('max_stock') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            
                                        </div>
                                        <div class="form-group special-link">
                                            <label for="name" class=" control-label">Special</label>
                                            
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control showSpecial" name="isSpecial" id="isSpecial">
                                                        <option value="no" @if($product->product_id != $specialProduct[0]->product_id && $specialProduct[0]->status == 'Active') selected @endif>No</option>
                                                        <option value="yes" @if($product->product_id == $specialProduct[0]->product_id && $specialProduct[0]->status == 'Active') selected @endif>Yes</option>
                                                    </select>
                                                </div>
        
                                            
                                        </div>
                                        <div class="special-container" style="display: none;">
                                            <div class="form-group">
                                                <label for="name" class=" control-label">Special Price<span style="color:red;">*</span></label>
                                                
                                                    <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input class="form-control" type="text" name="special_new_product_price" id="special-price" value="{{$specialProduct[0]->special_new_product_price}}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off">
                                                </div>
                                                
                                            </div>
                                            <div class="form-group @error('dob') has-error @enderror">
                                            <label for="name" class="asterisk control-label">Expiry Date</label>
                                            
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-calendar fa-fw"></i></span>
                                                    <input type="text" id="dob" name="expires_date" placeholder="Expiry Date" value="{{ date('Y-m-d',((int)$specialProduct[0]->expires_date)) }}" class="form-control datepicker" readonly>
                                                </div>
                                                @error('dob')<span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            
                                        </div>
                                                   
                                            <div class="form-group">
                                                <label for="name" class=" control-label">Status<span style="color:red;">*</span></label>
                                                
                                                    <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select class="form-control" name="status">
                                                        <option value="Active" @if($specialProduct[0]->status == 'Active') selected @endif>Active</option>
                                                        <option value="InActive" @if($specialProduct[0]->status == 'InActive') selected @endif>InActive</option>
                                                    </select>
                                                    </div>
                                               
                                            </div>
                                        </div>
                                        <div class="form-group  @error('image') has-error @enderror">
                                            <label for="avatar" class=" control-label">Image</label>
                                           
                                                <div class="input-group-btn input-group-append">
                                                    <input type="file" class="avatar" name="image" data-initial-preview="{{asset('').'/'.$product->image }}" data-initial-caption="{{ $product->image }}" id="1600892307492_72"> 
                                                </div>
                                                @error('image') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                         
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                 
                                    <div class="btn-group pull-left">
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection