@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Product Options Values<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Options Values</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-4">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <span>Options Value for @foreach($data['options'] as $key=>$option) <strong>{{$option->option_name}}</strong> @if(count($data['options']) != $key+1)<span> / </span> @endif  @endforeach</span>
                        </div>
                        <form action="{{ route('attribute.storeValue') }}" method="post" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                        {{ csrf_field() }}
                        <input type="hidden"  name="option_id"  value="{{$data['options'][0]->option_id}}" >
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-12">
                                        @foreach($data['languages'] as $languages)
                                        <div class="form-group  @error('name_'.$languages->code) has-error @enderror" >
                                            <label for="name" class="col-md-12 asterisk control-label " style="text-align:left;">Option Value ({{ $languages->name}})</label>
                                            <div class="col-md-12">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" id="name" name="name_<?=$languages->code?>" class="form-control name" value="{{old('name_'.$languages->code)}}" autocomplete="off" autofocus>
                                                </div>
                                                @error('name_'.$languages->code) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                 
                                    <div class="btn-group pull-left">
                                        
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="box grid-box">
                        <div class="box-header">
                           
                            @canany(['attribute.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{URL::to('admin/attribute/destroyValue')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['attribute.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Values</th>
                                        @canany(['attribute.destroy','attribute.edit','all'])
                                        <th>Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($data['content'])>0)
                                    @foreach($data['content'] as $data)
                                    
                                    <tr data-key="{{$data->option_value_id}}">
                                        @canany(['attribute.destroy','attribute.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{$data->option_value_id}}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{$data->option_value_id}}</td>
                                        <td dir="ltr">
                                            @foreach($data->data as $language)
                                                <p><strong>{{$language->name}}:</strong>
                                                    @if(count($language->values)>0)
                                                        @foreach($language->values as $value)
                                                            {{$value->option_value_name}}<br>
                                                        @endforeach
                                                    @else
                                                    --- <br>
                                                    @endif
                                                </p>
                                            @endforeach
                                           
                                        </td>
                                      
                                        @canany(['attribute.destroy','category.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['attribute.destroy','all'])
                                            <a href="{{ URL::to('admin/attribute/editValue')}}/{{$data->option_value_id}}"><i class="fa fa-edit" style="font-size: 20px;"></i></a>&nbsp;
                                            @endcanany
                                            @canany(['attribute.destroy','all'])
                                            
                                            <a data-id="{{ $data->option_value_id }}" route="{{URL::to('admin/attribute/destroyValue')}}/{{$data->option_value_id}}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger" style="font-size: 20px;background-color:#fff !important;color:#d9534f !important;"></i></a>
                                             @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection