@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Permissions<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li> Permissions</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['language.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('permission.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['language.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;vertical-align:unset;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{ URL::to('admin/permission') }}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                                <form action="{{URL::to('admin/permission')}}" pjax-container="" style="display: inline-block;">
                                    <div class="input-group input-group-sm hidden-xs" style="width: 170px;">
                                        <div class="input-group-btn">
                                            <a href="{{ URL::to('admin/permission') }}" class="btn btn-danger"><i class="fa fa-times"></i></a>
                                        </div>
                                        <input type="text" name="search" class="form-control pull-right grid-quick-search" style="width: 170px;" value="{{$search}}" placeholder="Search...">
                                        <div class="input-group-btn">
                                            <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i></button>
                                        </div>
                                        
                                    </div>
                                </form>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover  grid-table">
                                <thead>
                                    <tr>
                                        @canany(['permission.edit','permission.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th class="column-id">ID</th>
                                        <th class="column-name">Name</th>
                                        <th class="column-slug">Slug</th>
                                        <th class="column-created_at">Created At</th>
                                        <th class="column-updated_at">Updated At</th>
                                        @canany(['permission.edit','permission.destroy','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                @if(count($permissions)>0)
                                @foreach($permissions as $key=>$permission)
                                    <tr data-key="{{ $permission->id }}">
                                    @canany(['permission.destroy','all'])
                                        <td class="column-__row_selector__"><input type="checkbox" class="grid-row-checkbox" data-id="{{ $permission->id }}" style="position: absolute; opacity: 0;"></td>
                                    @endcanany
                                        <td class="column-id">{{ $permission->id }}</td>
                                        <td class="column-slug">{{ $permission->name }}</td>
                                        <td class="column-name">{{ $permission->slug }}</td>
                                        <td class="column-created_at">{{ date('Y-m-d',strtotime($permission->created_at)) }}</td>
                                        <td class="column-updated_at">{{ date('Y-m-d',strtotime($permission->updated_at)) }}</td>
                                    @canany(['permission.edit','permission.destroy','all'])
                                        <td class="column-__actions__">
                                            <a href="{{ route('permission.edit',$permission->id) }}"><i class="fa fa-edit"></i></a>&nbsp;
                                            <a data-id="{{ $permission->id }}" route="{{ route('permission.destroy',$permission->id) }}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                        </td>
                                    @endcanany
                                    </tr>
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="7" class="text-center">No Record Found</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                            <div class="col-xs-12 text-right">
                                {{$permissions->links('admin.pagination.default')}}
                            </div>
                        </div> 
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection