@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Orders<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Orders</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                              
                            </div>
                            @canany(['order.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{url('public/admin/order')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['order.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Customer</th>
                                        <th>Order Total</th>
                                        <th>Purchased At</th>
                                        <th>Status</th>
                                        <th>Comments</th>
                                        @canany(['order.destroy','order.edit','all'])
                                        <th>Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($orders as $key=>$order)
                                    <tr data-key="{{ $order->id }}">
                                        @canany(['order.destroy','order.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $order->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{ $order->id }}</td>
                                        <td>{{ $order->name }}</td>
                                        <td>{{$order->currency}} {{$order->total_price}}</td>
                                        <td>{{date('d M Y',strtotime($order->created_at))}}</td>
                                        <td>
                                            @if($order->status == 'Pending')
                                            <span class="label label-warning">
                                            @elseif($order->status == 'Confirmed')
                                            <span class="label label-primary">
                                            @elseif($order->status == 'Completed')
                                            <span class="label label-success">
                                            @elseif($order->status == 'Cancelled')
                                            <span class="label label-danger">
                                            @endif
                                            {{$order->status}}
                                            </span>
                                        </td>
                                        <td>{{$order->comments}} @if($order->status == 'Cancelled')<br><strong>Cancelled at:</strong> {{$order->date_added}} @endif</td>
                                        @canany(['order.destroy','order.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['order.edit','all'])
                                            <a data-toggle="tooltip" data-placement="bottom" title="View Order" href="{{route('order.edit',$order->id)}}"><i class="fa fa-edit"></i></a>&nbsp;
                                            @endcan
                                            @canany(['order.destroy','all'])
                                            <a data-toggle="tooltip" data-placement="bottom" title="Delete Order" data-id="{{ $order->id }}" route="{{route('order.destroy',$order->id)}}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                             @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection