@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Order<small>Edit</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>Auth</li>
                <li>Orders</li>
                <li>Update</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h2 class="box-title"><i class="fa fa-globe" style="font-size: 22px;"></i> Order ID# {{$order->id}} <small style="display: inline-block">Ordered Date: {{date('d M Y', strtotime($order->created_at))}}</small></h3>
                            
                            <div class="btn-group pull-right" style="margin-right: 5px">
                                <a href="{{URL::to('admin/order')}}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><spanclass="hidden-xs">&nbsp;List</span></a>
                                <a href="{{ URL::to('admin/orders/invoiceprint/'.$order->order_id)}}" class="btn btn-sm btn-default" title="List"><i class="fa fa-print"></i><spanclass="hidden-xs">&nbsp;Print</span></a>
                            </div>
                            
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        
                            <div class="box-body">
                                <div class="invoice-info">
                                    <div class="col-sm-4 invoice-col">
                                      Customer Info
                                       <address>
                                        <strong>{{ $order->name }}</strong><br>
                                        {{ $order->street_address }} <br>
                                        {{ $order->city }}, {{ $order->state }} {{ $order->postcode }}, {{ $order->country }}<br>
                                        <strong>Phone:</strong> {{ $order->phone }}<br>
                                        <strong>Email:</strong> {{ $order->email }}
                                      </address>
                                    </div>
                                    <div class="col-sm-4 invoice-col">
                                      Shipping Info
                                       <address>
                                        <strong>{{ $order->delivery_name }}</strong><br>
                                        {{ $order->delivery_street_address }} <br>
                                        {{ $order->delivery_city }}, {{ $order->delivery_state }} {{ $order->delivery_postcode }}, {{ $order->delivery_country }}<br>
                                        <strong>Phone: </strong>{{ $order->delivery_phone }}<br>
                                        <strong>Shipping Method:</strong> {{ $order->shipping_method }} <br>
                                        <strong>Shipping Cost:</strong> @if(!empty($order->shipping_cost)) QAR {{ $order->shipping_cost }} @endif
                                      </address>
                                    </div>
                                    <div class="col-sm-4 invoice-col">
                                      Billing Info
                                      <address>
                                        <strong>{{ $order->billing_name }}</strong><br>
                                        {{ $order->billing_street_address }} <br>
                                        <strong>Phone: </strong>{{ $order->billing_phone }}<br>
                                        {{$order->billing_city }}, {{ $order->billing_state }} {{ $order->billing_postcode }}, {{ $order->billing_country }}<br>
                                      </address>
                                    </div>
                                </div>
                                
                                <div class="table-responsive no-padding" style="overflow-x:unset;">
                               <table class="table table-hover grid-table">
                                <thead>
                                    <tr>
                                        <th>Vendor</th>
                                        <th>Qty</th>
                                        <th>Product</th>
                                        <th>Image</th>
                                        <th>Description</th>
                                        <th></th>
                                        <th>Total</th>
                                        <th>Subtotal</th>
                                    </tr>
                                </thead>
                                <tbody>
                                  @foreach($ordersData['orders_data'][0]->data as $products)
                                    <tr>
                                        <td>{{  $products->first_name }} {{$products->last_name}}</td>
                                        <td>{{  $products->product_quantity }}</td>
                                        <td><img src="{{ asset('').$products->image }}" width="60px"></td>
                                        <td>{{  $products->product_name }}<br></td>
                                        <td>
                                            @foreach($products->attribute as $attributes)
                                            	<b>Option:</b> {{ $attributes->product_option }}<br>
                                                <b>Value:</b> {{ $attributes->product_option_value }}<br>
                                                <b>Price:</b> {{$web_setting[0]->code}} {{ $attributes->option_value_price }}<br>
                                            @endforeach
                                        </td>
                                        <td>
                                            @if($products->gift_price > 0)
                                                <span style="font-size: 12px;color: #bb7a5c;display: inline-block;">@lang('website.Gift Price')</span><br>{{$web_setting[0]->code}} {{ $products->gift_price }}
                                            @endif
                                        </td>
                                        <td>{{$web_setting[0]->code}} {{ $products->final_price }}</td>
                                        <td>{{$web_setting[0]->code}} {{ $products->final_price + $products->gift_price}}</td>
                                     </tr>
                                    @endforeach
                                </tbody>
                            </table>
                                  </div> 
                                <div class="row">
                                    <!-- accepted payments column -->
                                    <div class="col-xs-6">
                                      <p class="lead">Payment Methods:</p>
                                     <p class="text-muted well well-sm no-shadow" style="text-transform:capitalize">
                                       	{{ str_replace('_',' ', $ordersData['orders_data'][0]->payment_method) }}
                                      </p>
                                        @if(!empty($ordersData['orders_data'][0]->coupon_code))
                                        <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                                          <p class="lead" style="margin-bottom:10px">Coupons:</p>
                                            <table class="text-muted well well-sm no-shadow stripe-border table table-striped" style="text-align: center; ">
                                            	<tr>
                                                    <th style="text-align: center; ">Code</th>
                                                    <th style="text-align: center; ">Amount</th>
                                                </tr>
                                            	@foreach( json_decode($ordersData['orders_data'][0]->coupon_code) as $couponData)
                                                	<tr>
                                                    	<td>{{ $couponData->code}}</td>
                                                        <td>{{ $couponData->amount}}
                                                            @if($couponData->discount_type=='percent_product')
                                                                (Percent)
                                                            @elseif($couponData->discount_type=='percent')
                                                                (Percent)
                                                            @elseif($couponData->discount_type=='fixed_cart')
                                                                (Fixed)
                                                            @elseif($couponData->discount_type=='fixed_product')
                                                                (Fixed)
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                            				</table>
                                           <!-- {{ $data['orders_data'][0]->coupon_code }}-->
                                        </p>
                                      @endif
                                      <p class="lead" style="margin-bottom:10px">Order information:</p>
                                      <p class="text-muted well well-sm no-shadow" style="text-transform:capitalize; word-break:break-all;">
                                       @if(trim($ordersData['orders_data'][0]->order_information) != '[]' or !empty($ordersData['orders_data'][0]->order_information))
                                       		{{ $ordersData['orders_data'][0]->order_information }}
                                       @endif
                                      </p>
                                    </div>
                                    <!-- /.col -->
                                    <div class="col-xs-6">
                                      <p class="lead">Subtotal</p>
                            
                                      <div class="table-responsive">
                                        <table class="table">
                                          <tbody><tr>
                                            <th style="width:50%">Subtotal:</th>
                                            <td class="text-center">{{$web_setting[0]->code}} {{ $ordersData['subtotal'] }}</td>
                                          </tr>
                                          <tr>
                                            <th>Tax</th>
                                            <td class="text-center">{{$web_setting[0]->code}} {{ $ordersData['orders_data'][0]->total_tax }}</td>
                                          </tr>
                                          <tr>
                                            <th>Shipping Cost:</th>
                                            <td class="text-center">{{$web_setting[0]->code}} {{ $ordersData['orders_data'][0]->shipping_cost }}</td>
                                          </tr>
                                          @if(!empty($ordersData['orders_data'][0]->coupon_code))
                                          <tr>
                                            <th>DicountCoupon:</th>
                                            <td class="text-center"> {{ $ordersData['orders_data'][0]->coupon_amount }}</td>
                                          </tr>
                                          @endif
                                          <tr>
                                            <th>Total:</th>
                                            <td class="text-center">{{$web_setting[0]->code}} {{ $ordersData['total_price'] }}</td>
                                          </tr>
                                        </tbody>
                                        </table>
                                      </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="box-footer">
                                    
                                        <form method="POST" action="{{route('order.update',$order->id)}}" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                                            {{ csrf_field() }}
                                            {{ method_field('PATCH') }}
                                          <p class="lead">Change Status:</p>
                                            
                                              <div class="form-group">
                                                <label>Payment Status:</label>
                                                <select class="form-control select2" id="status_id" name="order_status" style="width: 100%;">
                                                    <option value="{{ $ordersData['orders_data'][0]->status }}" @if( $ordersData['orders_data'][0]->status == 'Pending') selected @endif >Pending</option>
                                                    <option value="{{ $ordersData['orders_data'][0]->status }}" @if( $ordersData['orders_data'][0]->status == 'Confirmed') selected @endif >Confirmed</option>
                                                    <option value="{{ $ordersData['orders_data'][0]->status }}" @if( $ordersData['orders_data'][0]->status == 'Completed') selected @endif >Completed</option>
                                                    <option value="{{ $ordersData['orders_data'][0]->status }}" @if( $ordersData['orders_data'][0]->status == 'Cancelled') selected @endif >Canceled</option>
                                                </select>
                                              </div>
                                            
                                            
                                               <div class="form-group">
                                                <label>Comments:</label>
                                                <textarea name="comments" class="form-control" id="comments" rows="4"></textarea>
                                                </div>
                                            
                                        <div class="btn-group pull-right">
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                        </div>
                                     
                                        <div class="btn-group pull-left">
                                            <a href="{{URL::to('admin/order')}}" class="btn btn-default"><i class="fa fa-angle-left"></i> Back</a>
                                        </div>
                                        </form>
                                    
                                </div>
                                <div class="table-responsive no-padding" style="overflow-x:unset;">
                                <p class="lead">Order History</p>
                               <table class="table table-hover grid-table">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Status</th>
                                        <th>Comments</th>
                                    </tr>
                                </thead>
                                <tbody>
                                  @foreach($orderHistory as $order)
                                    <tr>
                                        <td>
                							<?php
                								$date = new DateTime($order->date_added);
                								$status_date = $date->format('d-m-Y');
                								print $status_date;
                							?>
                                        </td>
                                        <td>
                                        	@if($order->status == 'Pending')
                                            	<span class="label label-warning">
                                            @elseif($order->status == 'Completed')
                                                <span class="label label-success">
                                            @elseif($order->status == 'Cancelled')
                                                 <span class="label label-danger">
                                            @elseif($order->status == 'Confirmed')
                                                 <span class="label label-primary">
                                            @endif
                                            {{ $order->status }}
                                            </span>
                                        </td>
                                        <td style="text-transform: initial;">{{ $order->comments }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                                  </div>
                            </div>
                          
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection