@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container"  style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>
                Gifts
                <small>Create</small>
            </h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>Auth</li>
                <li>Gifts</li>
                <li>Create</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Create</h3>
                                <div class="btn-group pull-right" style="margin-right: 5px">
                                    <a href="{{ route('gift.index') }}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><span class="hidden-xs">&nbsp;List</span></a>
                                </div>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form action="{{ route('gift.store') }}" method="POST" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                            {{ csrf_field() }}
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-12">
                                        <div class="form-group  @error('image') has-error @enderror">
                                            <label for="avatar" class="col-sm-2  asterisk  control-label">Gift Image</label>
                                            <div class="col-sm-8">
                                                <div class="input-group-btn input-group-append">
                                                    <input type="file" class="avatar" name="image">
                                                </div>
                                                @error('image') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('price') has-error @enderror">
                                            <label for="name" class="col-sm-2  asterisk control-label">Price</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                  <input type="text" name="price" class="form-control" value="{{ old('price') }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" autofocus>
                                                </div>
                                                @error('price') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        @foreach($languages as $language)
                                        <div class="form-group  @error('description_'.$language->code) has-error @enderror">
                                            <label for="name" class="col-sm-2 control-label">Description ({{ $language->name }})</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" id="description_<?=$language->code?>" name="description_<?=$language->code?>" class="form-control name" value="{{ old('description_'.$language->code) }}" autocomplete="off" autofocus>
                                                </div>
                                                @error('description_'.$language->code) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                 
                                    <div class="btn-group pull-left">
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection