@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Gift Colors<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li> Auth</li>
                <li>Gifts</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-4">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <span>Gift Colors for Gift</span>
                        </div>
                        <form action="{{ route('gift.storeColor') }}" method="post" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                        {{ csrf_field() }}
                        <input type="hidden"  name="gift_id"  value="{{$gift_id}}" >
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-12">
                                        @foreach($languages as $language)
                                        <div class="form-group  @error('name_'.$language->code) has-error @enderror" >
                                            <label for="name" class="col-md-12 asterisk control-label " style="text-align:left;">Color ({{ $language->name}})</label>
                                            <div class="col-md-12">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" id="name" name="name_<?=$language->code?>" class="form-control name" value="{{old('name_'.$language->code)}}" autocomplete="off" autofocus>
                                                </div>
                                                @error('name_'.$language->code) <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                 
                                    <div class="btn-group pull-left">
                                        
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="box grid-box">
                        <div class="box-header">
                           <h3 class="box-title">Colors</h3>
                                <div class="btn-group pull-right" style="margin-right: 5px">
                                    <a href="{{ route('gift.index') }}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><span
                                            class="hidden-xs">&nbsp;List</span></a>
                                </div>
                            @canany(['gift.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{URL::to('admin/gift/destroyColor')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table">
                                <thead>
                                    <tr>
                                        @canany(['gift.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th>ID</th>
                                        <th>Colors</th>
                                        @canany(['gift.destroy','all'])
                                        <th>Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($gifts)>0)
                                    @foreach($gifts as $data)
                                    
                                    <tr data-key="{{$data->color_id}}">
                                        @canany(['gift.destroy','gift.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{$data->color_id}}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{$data->color_id}}</td>
                                        <td dir="ltr">
                                            @foreach($data->data as $language)
                                                <p><strong>{{$language->name}}:</strong>
                                                    @if(count($language->colors)>0)
                                                        @foreach($language->colors as $value)
                                                            {{$value->name}}<br>
                                                        @endforeach
                                                    @else
                                                    --- <br>
                                                    @endif
                                                </p>
                                            @endforeach
                                           
                                        </td>
                                      
                                        @canany(['gift.destroy','all'])
                                        <td class="column-__actions__">
                                             @canany(['gift.destroy','all'])
                                                <a data-id="{{ $data->color_id }}" route="{{URL::to('admin/gift/destroyColor')}}/{{$data->color_id}}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger" style="font-size: 20px;background-color:#fff !important;color:#d9534f !important;"></i></a>
                                             @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                    @else
                                     <tr>
                                        <td colspan="4" class="text-center">No Record Found</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection