@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Edit Coupon<small>Edit</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>Auth</li>
                <li>Coupons</li>
                <li>Create</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Edit</h3>
                            <div class="box-tools">
                                <div class="btn-group pull-right" style="margin-right: 5px">
                                    <a href="{{ route('coupon.index') }}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><span
                                            class="hidden-xs">&nbsp;List</span></a>
                                </div>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form action="{{ route('coupon.update',$coupon->id) }}" method="POST" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                            {{ csrf_field() }}
                            {{ method_field('PATCH') }}
                            
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-12">
                                        <div class="form-group  @error('code') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Coupon Code</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="code" class="form-control" value="{{$coupon->code}}" autocomplete="off" autofocus>
                                                </div>
                                                @error('code') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('description') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Description (Optional)</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="description" class="form-control"  value="{{$coupon->description}}" autocomplete="off" autofocus>
                                                </div>
                                                @error('description') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('discount_type') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Discount Type</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select name="discount_type" class="form-control">
                                                        <option value="fixed_cart" @if($coupon->discount_type == 'fixed_cart') selected @endif>Cart Discount</option>
                                                        <option value="percent" @if($coupon->discount_type == 'percent') selected @endif>Cart % Discount</option>
                                                        <option value="fixed_product" @if($coupon->discount_type == 'fixed_product') selected @endif>Product Discount</option>
                                                        <option value="percent_product" @if($coupon->discount_type == 'percent_product') selected @endif>Product % Discount</option>
                                                    </select>
                                                    </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">Determines the type of discount that will be applied. Options: percent, fixed cart and fixed product. Default is fixed cart.</span>
                                	@error('discount_type') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('amount') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Coupon Amount</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="amount" class="form-control number-validate" value="{{$coupon->amount}}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" >
                                                </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">The amount of discount.</span>
                                                @error('amount') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('free_shipping') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Allow Free Shipping</label>
                                            <div class="col-sm-8">
                                                <input type="checkbox" name="free_shipping" @if($coupon->free_shipping == '1') checked @endif>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">Check this box if the coupon grants free shipping. A free shipping method must be enabled in your shipping zone and be set to require "a valid free shipping coupon" (see the "Free Shipping Requires" setting).</span>
                                                @error('free_shipping') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('expiry_date') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Coupon Expiry Date</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="expiry_date" class="form-control datepicker" value="{{ date('Y-m-d',strtotime($coupon->expiry_date)) }}" autocomplete="off" readonly>
                                                </div>
                                                @error('expiry_date') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('minimum_amount') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Minimum Spend</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input id="minimum_amount" type="text" name="minimum_amount" class="form-control" value="{{ $coupon->minimum_amount }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" >
                                                </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">Minimum order amount that needs to be in the cart before coupon applies.</span>
                                                @error('minimum_amount') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('maximum_amount') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Maximum Spend</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input id="maximum_amount" type="text" name="maximum_amount" class="form-control" value="{{ $coupon->maximum_amount }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" >
                                                </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">Maximum order amount allowed when using the coupon.</span>
                                                @error('maximum_amount') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('individual_use') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Individual Use Only</label>
                                            <div class="col-sm-8">
                                                <input type="checkbox" name="individual_use" value="{{$coupon->individual_use}}" @if($coupon->individual_use == '1') checked @endif>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;"> Check this box if the coupon cannot be used in conjunction with other coupons.</span>
                                                @error('individual_use') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('exclude_sale_items') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Exclude Sale Items</label>
                                            <div class="col-sm-8">
                                                <input type="checkbox" name="free_shipping" value="{{$coupon->free_shipping}}" @if($coupon->free_shipping == '1') checked @endif>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;"> Check this box if the coupon should not apply to items on sale. Per-item coupons will only work if the item is not on sale. Per-cart coupons will only work if there are no sale items in the cart.</span>
                                                @error('exclude_sale_items') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('product_ids') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Products</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select name="product_ids[]" class="form-control select2" multiple>
                                                        @foreach($products as $product)
                                                        <option value="{{$product->id}}" @if(in_array($product->id, explode(',', $coupon->product_ids))) selected @endif>{{$product->name}}</option>
                                                        @endforeach
                                                    </select>
                                                    </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">List of product the coupon can be used on.</span>
                                	            @error('product_ids') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('exclude_product_ids') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Exclude Products</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select name="exclude_product_ids[]" class="form-control select2" multiple>
                                                        @foreach($products as $product)
                                                        <option value="{{$product->id}}" @if(in_array($product->id, explode(',', $coupon->exclude_product_ids))) selected @endif>{{$product->name}}</option>
                                                        @endforeach
                                                    </select>
                                                    </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">List of product the coupon cannot be used on.</span>
                                	            @error('exclude_product_ids') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('product_categories') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Categories</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select name="product_categories[]" class="form-control select2">
                                                      @foreach($categories as $category)
                                                        <option value="{{$category->id}}" @if(in_array($category->id, explode(',', $coupon->product_categories))) selected @endif>{{$category->name}}</option>
                                                        @endforeach
                                                    </select>
                                                    </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">List of category the coupon applies to.</span>
                                	            @error('product_categories') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('excluded_product_categories') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Exclude Categories</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select name="excluded_product_categories[]" class="form-control select2" multiple>
                                                       @foreach($categories as $category)
                                                        <option value="{{$category->id}}" @if(in_array($category->id, explode(',', $coupon->excluded_product_categories))) selected @endif>{{$category->name}}</option>
                                                        @endforeach
                                                    </select>
                                                    </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">List of category does not the coupon applies to.</span>
                                	            @error('excluded_product_categories') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('email_restrictions') has-error @enderror">
                                            <label for="slug" class="col-sm-2 control-label">Email Restrictions</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <select name="email_restrictions[]" class="form-control select2" multiple>
                                                      @foreach($emails as $email)
                                                        <option value="{{$email->email}}" @if(in_array($email->id, explode(',', $coupon->email_restrictions))) selected @endif>{{$email->email}}</option>
                                                        @endforeach
                                                    </select>
                                                    </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">List of email addresses that can use this coupon.</span>
                                	            @error('email_restrictions') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('usage_limit') has-error @enderror">
                                            <label for="name" class="col-sm-2  control-label">Usage Limit Per Coupon</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input id="usage_limit" type="text" name="usage_limit" class="form-control" value="{{$coupon->usage_limit}}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" >
                                                </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">How many times the coupon can be used in total.</span>
                                                @error('usage_limit') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('usage_limit_per_user') has-error @enderror">
                                            <label for="name" class="col-sm-2 control-label">Usage Limit Per User</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input id="usage_limit_per_user" type="text" name="usage_limit_per_user" class="form-control" value="{{ $coupon->usage_limit_per_user }}" onkeypress="return (event.charCode == 8 || event.charCode == 0 || event.charCode == 13) ? null : event.charCode >= 48 &amp;&amp; event.charCode <= 57" autocomplete="off" >
                                                </div>
                                                <span class="help-block" style="font-weight: normal;font-size: 11px;margin-bottom:0;">How many times the coupon can be used per customer</span>
                                                @error('usage_limit_per_user') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        
                                        
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                    <div class="btn-group pull-left">
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
@include('admin.common.toastr')
</div>
@endsection