@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 474px;">
    <style type="text/css"></style>
    <div id="app" class=" ">
        <section class="content-header">
            <h1>
                Administrator
                <small>Create</small>
            </h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>
                    Auth
                </li>
                <li>
                    Categories
                </li>
                <li>
                    Update
                </li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Create</h3>
                            <div class="box-tools">
                                <div class="btn-group pull-right" style="margin-right: 5px">
                                    <a href="{{ route('category.index') }}" class="btn btn-sm btn-default" title="List"><i class="fa fa-list"></i><span
                                            class="hidden-xs">&nbsp;List</span></a>
                                </div>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form action="{{ route('category.update',$category->id) }}" method="post" class="form-horizontal model-form-5f6c9704b9434" accept-charset="UTF-8" enctype="multipart/form-data" pjax-container>
                        {{ csrf_field() }}
                        {{ method_field('PATCH') }}
                            <div class="box-body">
                                <div class="fields-group">
                                    <div class="col-md-12">
                                        <div class="form-group  @error('parent_id') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Main Category</label>
                                            <div class="col-sm-8">
                                                <select class="form-control select2" name="parent_id">
                                                    <option value="">Select Category</option>
                                                    @foreach($categories as $cate)
                                                    <option value="{{$cate->id}}" @if($cate->id == $category->parent_id) selected @endif>{{$cate->name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        @foreach($description as $description_data)
                                        <div class="form-group  @error('name') has-error @enderror">
                                            <label for="name" class="col-sm-2 asterisk control-label">Name ({{ $description_data['language_name'] }})</label>
                                            <div class="col-sm-8">
                                                <div class="input-group">
                                                    <span class="input-group-addon"><i class="fa fa-pencil fa-fw"></i></span>
                                                    <input type="text" name="name_<?=$description_data['language_id']?>" class="form-control name" placeholder="Input Name" value="{{$description_data['name']}}" autocomplete="off" autofocus>
                                                </div>
                                                @error('name') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        @endforeach
                                      <div class="form-group  @error('image') has-error @enderror">
                                            <label for="avatar" class="col-sm-2  control-label">Image</label>
                                            <div class="col-sm-8">
                                                <div class="input-group-btn input-group-append">
                                                    <input type="file" class="avatar" name="image" data-initial-preview="{{asset('').'/'.$category->image }}" data-initial-caption="{{ $category->image }}" id="1600892307492_72"> 
                                                </div>
                                                @error('image') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group  @error('icon') has-error @enderror">
                                            <label for="avatar" class="col-sm-2  control-label">Icon</label>
                                            <div class="col-sm-8">
                                                <div class="input-group-btn input-group-append">
                                                    <input type="file" class="avatar" name="icon" data-initial-preview="{{asset('').'/'.$category->icon }}" data-initial-caption="{{ $category->icon }}" id="1600892307492_72"> 
                                                </div>
                                                @error('icon') <span class="invalid-feedback" role="alert"><small>{{ $message }}</small></span> @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-8">
                                    <div class="btn-group pull-right">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                 
                                    <div class="btn-group pull-left">
                                        <button type="reset" class="btn btn-warning">Reset</button>
                                    </div>
                                </div>
                            </div>
                            <!-- /.box-footer -->
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection