@extends('admin.layout') @section('content')
<div class="content-wrapper" id="pjax-container" style="min-height: 524px;">
    <div id="app" class=" ">
        <section class="content-header">
            <h1>Brands<small>List</small></h1>
            <!-- breadcrumb start -->
            <ol class="breadcrumb" style="margin-right: 30px;">
                <li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-dashboard"></i> Home</a></li>
                <li>Auth</li>
                <li>Brands</li>
            </ol>
            <!-- breadcrumb end -->
        </section>
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box grid-box">
                        <div class="box-header with-border">
                            <div class="pull-right">
                                <div class="btn-group pull-right" style="margin-right: 10px">
                                    <a href="#" target="_blank" class="btn btn-sm btn-twitter" title="Export"><i
                                            class="fa fa-download"></i><span class="hidden-xs"> Export</span></a>
                                    <button type="button" class="btn btn-sm btn-twitter dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" target="_blank">All</a></li>
                                        <li><a href="#" target="_blank">Current page</a></li>
                                        <li><a href="#" target="_blank" class="export-selected">Selected rows</a></li>
                                    </ul>
                                </div>
                                @canany(['brand.create','all'])
                                <div class="btn-group pull-right grid-create-btn" style="margin-right: 10px">
                                    <a href="{{ route('brand.create') }}" class="btn btn-sm btn-success" title="New">
                                        <i class="fa fa-plus"></i><span class="hidden-xs">&nbsp;&nbsp;New</span>
                                    </a>
                                </div>
                                @endcanany
                            </div>
                            @canany(['brand.destroy','all'])
                            <div class="pull-left">
                                <div class="btn-group grid-select-all-btn" style="display:none;margin-right: 5px;">
                                    <a class="btn btn-sm btn-default hidden-xs"><span class="selected"></span></a>
                                    <button type="button" class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#" route="{{url('public/admin/brand')}}" class="grid-batch-0">Batch delete </a></li>
                                    </ul>
                                </div>
                            </div>
                            @endcanany
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-hover grid-table" id="example">
                                <thead>
                                    <tr>
                                        @canany(['brand.destroy','all'])
                                        <th class="column-__row_selector__">
                                            <input type="checkbox" class="grid-select-all" style="position: absolute; opacity: 0;">
                                        </th>
                                        @endcanany
                                        <th class="column-id">ID</th>
                                        <th class="column-name">Name</th>
                                        <th class="column-name">Image</th>
                                        
                                        @canany(['brand.destroy','brand.edit','all'])
                                        <th class="column-__actions__">Action</th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($brands as $brand)
                                    <tr data-key="{{ $brand->id }}">
                                        @canany(['brand.destroy','brand.edit','all'])
                                        <td class="column-__row_selector__">
                                            <input type="checkbox" class="grid-row-checkbox" data-id="{{ $brand->id }}" style="position: absolute; opacity: 0;">
                                        </td>
                                        @endcanany
                                        <td>{{ $brand->id }}</td>
                                        <td>{{ $brand->name }}</td>
                                        <td>@if(
            								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'jpeg' || 
            								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'JPEG' ||
            								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'jpg'  ||
            								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'JPG'  ||
            								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'png'  || 
            								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'PNG'  || 
            								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'gif'  || 
            								    pathinfo($brand->image, PATHINFO_EXTENSION) == 'svg') 
                                            <img src="{{asset('').$brand->image}}" width="25px" alt=""></td>
                                            @else
                                            <video playsinline="" autoplay="" muted="" loop="" poster="" id="herovid" style="width:25px;">
                                                <source src="{{asset('').$brand->image}}" type="video/webm">
                                            </video>
                                        @endif
                                        @canany(['brand.destroy','brand.edit','all'])
                                        <td class="column-__actions__">
                                            @canany(['brand.edit','all'])
                                            <a href="{{route('brand.edit',$brand->id)}}"><i class="fa fa-edit"></i></a>&nbsp;
                                            @endcan
                                            @canany(['brand.destroy','all'])
                                            <a data-id="{{ $brand->id }}" route="{{route('brand.destroy',$brand->id)}}" href="#" class="grid-batch-0"><i class="fa fa-trash label-danger"></i></a>
                                             @endcanany
                                        </td>
                                        @endcanany
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </section>
    </div>
    @include('admin.common.toastr')
</div>
@endsection