<?php

namespace Database\Seeders;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class SettinsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            //general setting
            ['name' => 'app_name','value' => 'Laravel'],
            ['name' => 'url','value' => 'http://localhost/l8blog/public'],
            ['name' => 'site_logo','value' => 'resources/assets/images/site_images/logo.png'],
            ['name' => 'app_logo','value' => 'resources/assets/images/site_images/logo.png'],
            ['name' => 'contact_us_email','value' => 'info@demo.com'],
            ['name' => 'phone','value' => '+974 56565656'],
            ['name' => 'address','value' => 'Doha Qatar'],
            ['name' => 'city','value' => 'Doha'],
            ['name' => 'state','value' => 'Qatar'],
            ['name' => 'zip','value' => '3434'],
            ['name' => 'country','value' => 'Qatar'],
            ['name' => 'latitude','value' => '25.54545454'],
            ['name' => 'longitude','value' => '52.34343444'],
            //social setting
            ['name' => 'google_login','value' => '#'],
            ['name' => 'google_app_id','value' => '#'],
            ['name' => 'google_secret_id','value' => '#'],
            ['name' => 'google_callback_url','value' => '#'],
            
            ['name' => 'facebook_login','value' => '#'],
            ['name' => 'facebook_app_id','value' => '#'],
            ['name' => 'facebook_secret_id','value' => '#'],
            ['name' => 'facebook_callback_url','value' => '#'],

            ['name' => 'apple_login','value' => '#'],
            ['name' => 'apple_app_id','value' => '#'],
            ['name' => 'apple_secret_id','value' => '#'],
            ['name' => 'apple_callback_url','value' => '#'],

            ['name' => 'google_url','value' => 'https://www.google.com'],
            ['name' => 'facebook_url','value' => 'https://www.facebook.com'],
            ['name' => 'instagram_url','value' => 'https://www.instagram.com'],
            ['name' => 'linkedin_url','value' => 'https://www.linkedin.com'],
            ['name' => 'twitter_url','value' => 'https://twitter.com'],
            ['name' => 'youtube_url','value' => 'https://www.youtube.com'],

           ];
        $insert_data = [];
        $time_stamp = Carbon::now()->toDateTimeString();
        foreach ($data as $d) {
            $d['created_at'] = $time_stamp;
            $insert_data[] = $d;
        }
        Setting::insert($insert_data);
    }
}
