<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use Carbon\Carbon;
class PermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            ['name' => 'All','slug' => 'all'],
            ['name' => 'Dashboard View','slug' => 'dashboard'],

            ['name' => 'Customers View','slug' => 'customer.index'],
            ['name' => 'Customers Create','slug' => 'customer.create'],
            ['name' => 'Customers Update','slug' => 'customer.edit'],
            ['name' => 'Customers Delete','slug' => 'customer.destroy'],

            ['name' => 'User View','slug' => 'user.index'],
            ['name' => 'User Create','slug' => 'user.create'],
            ['name' => 'User Update','slug' => 'user.edit'],
            ['name' => 'User Delete','slug' => 'user.destroy'],

            ['name' => 'User Profile View','slug' => 'user.profile'],
            ['name' => 'User Profile Update','slug' => 'user.profile.edit'],
            
            ['name' => 'Roles View','slug' => 'role.index'],
            ['name' => 'Role Create','slug' => 'role.create'],
            ['name' => 'Role Update','slug' => 'role.edit'],
            ['name' => 'Role Delete','slug' => 'role.destroy'],

            ['name' => 'Permissions View','slug' => 'permission.index'],
            ['name' => 'Permission Create','slug' => 'permission.create'],
            ['name' => 'Permission Update','slug' => 'permission.edit'],
            ['name' => 'Permission Delete','slug' => 'permission.destroy'],

            ['name' => 'Languages View','slug' => 'language.index'],
            ['name' => 'Language Create','slug' => 'language.create'],
            ['name' => 'Language Update','slug' => 'language.edit'],
            ['name' => 'Language Delete','slug' => 'language.destroy'],

            ['name' => 'Operation Logs','slug' => 'logs'],
            
            ['name' => 'Social Settings View','slug' => 'socialSettings.index'],
            ['name' => 'Social Settings Update','slug' => 'socialSettings.edit'],

            ['name' => 'General Settings View','slug' => 'generalSettings.index'],
            ['name' => 'General Settings Update','slug' => 'generalSettings.edit'],
            ['name' => 'Database Control','slug' => 'database'],

            ['name' => 'Pages View','slug' => 'page.index'],
            ['name' => 'Pages Create','slug' => 'page.create'],
            ['name' => 'Pages Update','slug' => 'page.edit'],
            ['name' => 'Pages Delete','slug' => 'page.destroy'],

            ['name' => 'Sliders View','slug' => 'slider.index'],
            ['name' => 'Sliders Create','slug' => 'slider.create'],
            ['name' => 'Sliders Update','slug' => 'slider.edit'],
            ['name' => 'Sliders Delete','slug' => 'slider.destroy'],
            
           
        ];
        $insert_data = [];
        $time_stamp = Carbon::now()->toDateTimeString();
        foreach ($data as $d) {
            $d['created_at'] = $time_stamp;
            $insert_data[] = $d;
        }
        Permission::insert($insert_data);
    }
}
