<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Menu;
use Carbon\Carbon;
class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            ['parent_id' => '0','order' => '1','title'=>'Dashboard','icon'=>'fa fa-dashboard','uri'=>'Dashboard'],
            ['parent_id' => '0','order' => '2','title'=>'Admin','icon'=>'fa-tasks','uri'=>'#'],
            ['parent_id' => '2','order' => '3','title'=>'Users','icon'=>'fa-users','uri'=>'admins'],
            ['parent_id' => '2','order' => '4','title'=>'Roles','icon'=>'fa-user','uri'=>'roles'],
            ['parent_id' => '2','order' => '5','title'=>'Permissions','icon'=>'fa-ban','uri'=>'permissions'],
            ['parent_id' => '2','order' => '6','title'=>'Menu','icon'=>'fa-bars','uri'=>'menu'],
            ['parent_id' => '0','order' => '7','title'=>'Languages','icon'=>'fa-language','uri'=>'languages'],
        ];
        $insert_data = [];
        $time_stamp = Carbon::now()->toDateTimeString();
        foreach ($data as $d) {
            $d['created_at'] = $time_stamp;
            $insert_data[] = $d;
        }
        Menu::insert($insert_data);
    }
}
