<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Language;
use Carbon\Carbon;
class LanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        
        $data = [
            ['name' => 'English','code' => 'en','direction'=>'ltr','isdefault'=>'1','status'=>'Active'],
            ['name' => 'العربية','code' => 'ar','direction'=>'rtl','isdefault'=>'0','status'=>'InActive'],
        ];
        $insert_data = [];
        $time_stamp = Carbon::now()->toDateTimeString();
        foreach ($data as $d) {
            $d['created_at'] = $time_stamp;
            $insert_data[] = $d;
        }
        Language::insert($insert_data);
    }
}
