<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLanguagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('languages', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name','50')->unique();
            $table->string('code','4')->unique();
            $table->string('directory')->nullable();
            $table->enum('direction', ['ltr', 'rtl'])->default('ltr');
            $table->enum('isdefault', ['1', '0'])->default('0');
            $table->string('image')->nullable();
            $table->enum('status', ['Active', 'InActive'])->default('InActive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('languages');
    }
}
