<?php

namespace App\Http\Middleware;
use Closure;
use Session;
use Config;
use App;
use DB;

class Language
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(Session::has('locale')){
			$locale = Session::get('locale', Config::get('app.locale'));
		}else{	   
		   $languages = DB::table('languages')->where('isdefault','=','1')->get();	   
		   $request->session()->put('direction', $languages[0]->direction);	 
		   
		   $lang = DB::table('languages')->where('isdefault','=','0')->get();	
		   $request->session()->put('lang_code', $lang[0]->code);
		   $request->session()->put('lang_name', $lang[0]->name);
		   $locale = $languages[0]->code;
		   $request->session()->put('locale', $languages[0]->code);
		}
		App::setLocale($locale);
        return $next($request);
    }
}
