<?php
/*
Project Name: NS JEWELRY
Author: Sadaqat Ali 
*/
namespace App\Http\Controllers\Web;
//use Mail;
//validator is builtin class in laravel
use Validator;

use DB;
//for password encryption or hash protected
use Hash;

//for authenitcate login data
use Auth;
use Illuminate\Foundation\Auth\ThrottlesLogins;
//for requesting a value 
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Input;
use App\Models\Language;
//for Carbon a value 
use Carbon;
use Lang;
use App;
use Illuminate\Support\Facades\Mail;


class WebSettingController extends DataController
{
	
    /**
     * Create a new controller instance.
     *
     * @return void
     */
  
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
	 
	 //contactUs
	public function changeLanguage(Request $request){
		if($request->ajax()){
		   $request->session()->put('locale', $request->code);
		   //set language
		   $languages = Language::where('code','=',$request->code)->get();	  
		   $request->session()->put('direction', $languages[0]->direction);		   
		   
		   $lang = Language::where('code','!=',$request->code)->get();
		   $request->session()->put('lang_name', $lang[0]->name);		   
		   $request->session()->put('lang_code', $lang[0]->code);
		   
            echo session('direction');
		}
	}
	
	//subscribe
	public function subscribe(Request $request){
		
		$msg = Lang::get("website.Some problem occurred, please try again.");
		$result['commonContent'] = $this->commonContent();
		
		if(!empty($result['commonContent']['setting'][89]->value) and !empty($result['commonContent']['setting'][88]->value)){

			$fname = '';
			$lname = '';
			$apikey = $result['commonContent']['setting'][87]->value;
			$list_id= $result['commonContent']['setting'][88]->value;

			$auth = base64_encode( 'user:'.$apikey );

			$data = array(
				'apikey'        => $apikey,
				'email_address' => $request->email,
				'status'        => 'subscribed',
				'merge_fields'  => array(
					'FNAME' => $fname,
					'LNAME' => $lname
				)
			);
			
			$json_data = json_encode($data);

			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, 'https://' . substr($apikey,strpos($apikey,'-')+1) . '.api.mailchimp.com/3.0/lists/' . $list_id . '/members/');
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json',
														'Authorization: Basic '.$auth));
			/*curl_setopt($ch, CURLOPT_USERAGENT, 'PHP-MCAPI/2.0');*/
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_TIMEOUT, 10);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);                                                                                                                  

			$result = curl_exec($ch);
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

			curl_close ($ch);
			$msg = '';
			$status = 0;
			if ($httpCode == 200) {
				$msg = Lang::get("website.You have successfully subscribed.");
				$status = 1;
			} else {
				switch ($httpCode) {
					case 400:
						$msg = Lang::get("website.You have already subscribed.");
						$status = 0;
						break;
					default:						
						
						$status = 0;
						break;
				}
				$status = 0;
			}

			
		}else{
			$status = 0;
		}
		$result = array('success'=>$status, 'message'=>$msg);
		print_r(json_encode($result));
		
		
	}
	public function imageType(){	
		$extensions = array('gif','jpg','jpeg','png');	
		return $extensions;
	}
	
}
