<?php

namespace App\Http\Controllers\Web;
use Illuminate\Support\Facades\Collection;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DatabaseNotification;
use App\Models\User;
use App\Models\Language;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Page;
use App\Models\Slider;
use App\Models\News;
use Illuminate\Http\Request;
use Lang;
use Session;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
class DefaultController extends DataController
{

    public function index(Request $request){
        $pageTitle = Lang::get('website.WebsiteName');
        $commonContent = $this->commonContent();
        if(!empty($request->limit)){
			$limit = $request->limit;
		}else{
			$limit = 12;
		}
		
		//min_price
		if(!empty($request->min_price)){
			$min_price = $request->min_price;
		}else{
			$min_price = '';
		}
		
		//max_price
		if(!empty($request->max_price)){
			$max_price = $request->max_price;
		}else{
			$max_price = '';
		}	
        //products
        $myVar = new DataController();
        $data = array('page_number'=>'0', 'type'=>'', 'limit'=>10, 'min_price'=>$min_price, 'max_price'=>$max_price );
        $products = $myVar->products($data);
        
        // //special products
        // $myVar = new DataController();
        // $data = array('page_number'=>'0', 'type'=>'special', 'limit'=>$limit, 'min_price'=>$min_price, 'max_price'=>$max_price );
        // $special_products = $myVar->products($data);
        // $result['special'] = $special_products;

        // //top seller
        // $myVar = new DataController();
        // $data = array('page_number'=>'0', 'type'=>'topseller', 'limit'=>$limit, 'min_price'=>$min_price, 'max_price'=>$max_price );
        // $top_seller = $myVar->products($data);
        // $result['top_seller'] = $top_seller;

        // //most liked
        // $myVar = new DataController();
        // $data = array('page_number'=>'0', 'type'=>'mostliked', 'limit'=>$limit, 'min_price'=>$min_price, 'max_price'=>$max_price );
        // $most_liked = $myVar->products($data);
        // $result['most_liked'] = $most_liked;

        // //is feature
        // $myVar = new DataController();
        // $data = array('page_number'=>'0', 'type'=>'is_feature', 'limit'=>$limit, 'min_price'=>$min_price, 'max_price'=>$max_price );
        // $featured = $myVar->products($data);
        // $result['featured'] = $featured;

        // //is feature
        // $myVar = new DataController();
        // $data = array('page_number'=>'0', 'type'=>'flashsale', 'limit'=>$limit, 'min_price'=>$min_price, 'max_price'=>$max_price );
        // $flash_sale = $myVar->products($data);
        // $result['flash_sale'] = $flash_sale;

        //current time
        $currentDate = Carbon::now();
        $currentDate = $currentDate->toDateTimeString();
        $sliders = Slider::where('status', '=', 'Active')->where('language_id', '=', session('locale'))->where('expires_date', '>', $currentDate)->get();
        $news = News::Leftjoin('news_description','news_description.news_id','=','news.id')
        ->select('news.image','news.slug','news.created_at','news_description.name')
        ->where('news.status', '=', 'Active')->where('news_description.language_id', '=', session('locale'))->get();
        
        return view('web.index',compact('pageTitle','commonContent','products','sliders','news'));
    }
     /**
     * Create a new controller instance.
     *
     * @return void
     */
   

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function brands(){
        
        $pageTitle = Lang::get('website.The Brand');
        $commonContent = $this->commonContent();
        
        $brands = Brand::leftjoin('brands_description','brands_description.brand_id','=','brands.id')->select('name','slug','image')->where('brands_description.language_id',Session::get('locale'))->get();
        
        return view("web.brands.brands", compact('pageTitle','commonContent','brands'));
    }
    
     //myContactUs
    public function contactUs(Request $request){
        
        $pageTitle = Lang::get('website.WebsiteName');
        $commonContent = $this->commonContent();
        return view("web.pages.contact-us", compact('pageTitle','commonContent'));
    }
    //processContactUs
    public function processContactUs(Request $request)
    {
          $data = $this->validate($request, [
            'name'          =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            'email'         =>  'required|string|email|max:50'
          ]);
        $name = $request->name;
        $email = $request->email;
        $subject = $request->subject;
        $message = $request->message;

        $commonContent = $this->commonContent();

        $data = array('name' => $name, 'email' => $email, 'subject' => $subject, 'message' => $message, 'adminEmail' => $commonContent['setting'][4]->value);

        Mail::send('/mail/contactUs', ['data' => $data], function ($m) use ($data) {
            $m->from($data['email'],'NS JEWELRY Customer');
            $m->to('ammalnaveed50@gmail.com')->subject(Lang::get("website.contact us title"));
            
                // ->getSwiftMessage()
                // ->getHeaders()
                // ->addTextHeader('x-mailgun-native-send', 'true');
        });
        return redirect()->back()->with('message', Lang::get("website.contact us message"));
    }
    
    public function notify(Request $request){
        exit;
        $users = User::all();
        $letter = collect(['title'=>'New policy added','body'=>'We have updated our TOC']);
        Notification::send($users,new DatabaseNotification($letter));
        return view('web.index');
    }
    //page
	public function page(Request $request){
		
		$pages = Page::leftJoin('pages_description','pages_description.page_id','=','pages.id')
					->where([['pages.status','Active'],['pages_description.language_id',Session::get('locale')],['pages.slug',$request->name]])->get();
		if(count($pages)>0){
	    $pageTitle = Lang::get('website.WebsiteName');
        $commonContent = $this->commonContent();
        return view("web.pages.index", compact('pageTitle','commonContent','pages'));
		}else{
			return redirect()->intended('/') ;
		}
	}
	
	public function newsDetail(Request $request){
		
		$news = News::leftJoin('news_description','news_description.news_id','=','news.id')
		->select('news.image','news.created_at','news_description.name','news_description.description')
		->where([['news.status','Active'],['news_description.language_id',Session::get('locale')],['news.slug',$request->slug]])->get();
	    $pageTitle = Lang::get('website.News Detail');
        $commonContent = $this->commonContent();
        return view("web.news-detail", compact('pageTitle','commonContent','news'));
		
	}
    
}
