<?php

namespace App\Http\Controllers\Web;
use App\Models\Language;
use App\Models\Category;
use App\Models\Product;
use App\Models\Page;
use App\Models\Slider;
use App\Models\Setting;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Session;
use Lang;
use App;
class DataController extends Controller
{
    public function commonContent(){
        $result = array();
        $data = array('type' => 'header');
        $cart = $this->cart($data);
        $result['cart'] = $cart;
        if (count($result['cart']) == 0) {
            session(['coupon' => array()]);
            session(['coupon_discount' => array()]);
            session(['payment_method' => array()]);
            session(['order_comments' => '']);
        }

        $result['setting'] = Setting::select('id','value')->orderby('id', 'ASC')->get();
        $settings = array();
        foreach($result['setting'] as $key=>$value){
          $settings[$value->name]=$value->value;
        }
        $result['settings'] = $settings;

        $result['pages'] = Page::leftJoin('pages_description', 'pages_description.page_id', '=', 'pages.id')
            ->select('pages.slug','pages_description.name','pages_description.description')
            ->where([ ['status', 'Active'], ['pages_description.language_id', Session::get('locale')]])
            ->orderBy('pages_description.name', 'ASC')->get();

        //product categories
        $result['categories'] = $this->categories();

        $total_wishlist = 0;
        if (!empty(session('customer_id'))) {
            $total_wishlist = DB::table('liked_products')->leftjoin('products', 'products.id', '=', 'liked_products.liked_product_id')->where('products.status', 'Active')->where('liked_customer_id', '=', session('customer_id'))->count();
        }
        $result['total_wishlist'] = $total_wishlist;
        return $result;
    }
    
    private function categories(){
        $result = array();
        $categories = Category::LeftJoin('categories_description', 'categories_description.categories_id', '=', 'categories.id')
            ->select('categories.id',
                'categories.image',
                'categories.icon',
                'categories.slug',
                'categories.parent_id',
                'categories_description.name'
            )
            ->where('categories_description.language_id', '=', Session::get('locale'))
            ->where('parent_id', '0')
            //->groupBy('categories.id')
            ->get();

        $index = 0;
        foreach ($categories as $categories_data) {

         
            $categories_id = $categories_data->id;
            $products = Category::LeftJoin('categories as sub_categories', 'sub_categories.parent_id', '=', 'categories.id')
                ->LeftJoin('product_category', 'product_category.category_id', '=', 'sub_categories.id')
                ->LeftJoin('products', 'products.id', '=', 'product_category.product_id')
                //->select('categories.id', DB::raw('COUNT(DISTINCT products.id) as total_products'))
                ->where('categories.id', '=', $categories_id)
                ->get();

            //$categories_data->total_products = $products[0]->total_products;
            array_push($result, $categories_data);
            $sub_categories = Category::LeftJoin('categories_description', 'categories_description.categories_id', '=', 'categories.id')
                ->select('categories.id as sub_id',
                    'categories.image as sub_image',
                    'categories.icon as sub_icon',
                    'categories.slug as sub_slug',
                    'categories.parent_id',
                    'categories_description.name as sub_name'
                )
                ->where('categories_description.language_id', '=', Session::get('locale'))
                ->where('parent_id', $categories_id)
                ->get();

            $data = array();
            $index2 = 0;
            foreach ($sub_categories as $sub_categories_data) {
                $sub_categories_id = $sub_categories_data->sub_id;
                $individual_products = DB::table('product_category')
                    ->LeftJoin('products', 'products.id', '=', 'product_category.product_id')
                    //->select('product_category.category_id', DB::raw('COUNT(DISTINCT products.id) as total_products'))
                    ->where('product_category.category_id', '=', $sub_categories_id)
                    ->get();
                //$sub_categories_data->total_products = $individual_products[0]->total_products;
                $data[$index2++] = $sub_categories_data;

            }
            $result[$index++]->sub_categories = $data;
        }
        return ($result);
    }
    
    public function cart($request){
        $cart = DB::table('customers_basket')
            ->join('products', 'products.id', '=', 'customers_basket.product_id')
            ->join('products_description', 'products_description.product_id', '=', 'products.id')
            ->select('customers_basket.*', 'products.image', 'products_description.name as product_name', 'products.quantity','products.price')
            ->where('customers_basket.is_order', '=', '0')->where('products_description.language_id', '=', Session::get('locale'));
        if (empty(session('customer_id'))) {
            $cart->where('customers_basket.session_id', '=', Session::getId());
        } else {
            $cart->where('customers_basket.customer_id', '=', session('customer_id'));
        }
        $baskit = $cart->get();
       return ($baskit);
    }
    //products
    public function products($data){
        if(empty($data['page_number']) or $data['page_number'] == 0 ){
			$skip	=   $data['page_number'].'0';
		}else{
			$skip	=   $data['limit']*$data['page_number'];
		}	
        $min_price = $data['min_price'];
        $max_price = $data['max_price'];
        
        $take = $data['limit'];
        
        $currentDate = time();
        
        $type = $data['type'];

        if ($type == "atoz") {
            $sortby = "name";
            $order = "ASC";
        } elseif ($type == "ztoa") {
            $sortby = "name";
            $order = "DESC";
        } elseif ($type == "hightolow") {
            $sortby = "price";
            $order = "DESC";
        } elseif ($type == "lowtohigh") {
            $sortby = "price";
            $order = "ASC";
        } elseif ($type == "topseller") {
            $sortby = "ordered";
            $order = "DESC";
        } elseif ($type == "mostliked") {
            $sortby = "liked";
            $order = "DESC";

        } elseif ($type == "special") {
            $sortby = "products_specials.product_id";
            $order = "desc";
        } elseif ($type == "flashsale") { //flashsale products
            $sortby = "flash_sale.flash_start_date";
            $order = "asc";
        } else {
            $sortby = "products.id";
            $order = "desc";
        }

        $filterProducts = array();
        $eliminateRecord = array();

        $categories = Product::leftJoin('brands', 'brands.id', '=', 'products.brand_id')
            ->leftJoin('brands_description', 'brands.id', '=', 'brands_description.brand_id')
            ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id');

        if (!empty($data['categories_id'])) {
            $categories->LeftJoin('product_category', 'products.id', '=', 'product_category.product_id')
                ->leftJoin('categories', 'categories.id', '=', 'product_category.category_id')
                ->LeftJoin('categories_description', 'categories_description.categories_id', '=', 'product_category.category_id');
        }
        
        if (!empty($data['filters']) and empty($data['search'])) {
            $categories->leftJoin('products_attributes', 'products_attributes.product_id', '=', 'products.id');
        }

        if (!empty($data['search'])) {
            $categories->leftJoin('products_attributes', 'products_attributes.product_id', '=', 'products.id')
                ->leftJoin('products_options', 'products_options.option_id', '=', 'products_attributes.option_id')
                ->leftJoin('products_options_values', 'products_options_values.option_value_id', '=', 'products_attributes.option_value_id');
        }
        //wishlist customer id
        if ($type == "wishlist") {
            $categories->LeftJoin('liked_products', 'liked_products.liked_product_id', '=', 'products.id')
                ->select('products.*','products_description.name','products_description.description','products_description.short_description','products_description.url','brands.image as brand_image','brands.slug as brand_slug','brands_description.name as brand_name');
        }
        
        //parameter special
        elseif ($type == "special") {
            $categories->LeftJoin('products_specials', 'products_specials.product_id', '=', 'products.id')
                ->select('products.*','products_description.name','products_description.description','products_description.short_description','products_description.url','brands.image as brand_image','brands.slug as brand_slug','brands_description.name as brand_name', 'products_specials.special_new_product_price as discount_price');
        // } elseif ($type == "flashsale") {
        //     //flash sale
        //     $categories->LeftJoin('flash_sale', 'flash_sale.products_id', '=', 'products.id')
        //         ->select(DB::raw(time() . ' as server_time'), 'products.*', 'image_categories.path as image_path', 'products_description.*', 'manufacturers.*', 'manufacturers_info.manufacturers_url', 'flash_sale.flash_start_date', 'flash_sale.flash_expires_date', 'flash_sale.flash_sale_products_price as flash_price');

        // } elseif ($type == "compare") {
        //     //flash sale
        //     $categories->LeftJoin('flash_sale', 'flash_sale.products_id', '=', 'products.id')
        //         ->select(DB::raw(time() . ' as server_time'), 'products.*', 'image_categories.path as image_path', 'products_description.*', 'manufacturers.*', 'manufacturers_info.manufacturers_url', 'flash_sale.flash_start_date', 'flash_sale.flash_expires_date', 'flash_sale.flash_sale_products_price as discount_price');

        } else {
            $categories->LeftJoin('products_specials', function ($join) use ($currentDate) {
                $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active')->where('expires_date', '>', $currentDate);
            })->select('products.*', 'products_description.name','products_description.description','products_description.short_description','products_description.url','brands.image as brand_image','brands.slug as brand_slug','brands_description.name as brand_name','products_specials.special_new_product_price as discount_price');
        }

        if ($type == "special") { //deals special products
            $categories->where('products_specials.status', '=', 'Active')->where('products_specials.expires_date', '>', $currentDate);
        }

        // if ($type == "flashsale") { //flashsale
        //     $categories->where('flash_sale.flash_status', '=', '1')->where('flash_expires_date', '>', $currentDate);

        // } elseif ($type != "compare") {
        //     $categories->whereNotIn('products.id', function ($query) use ($currentDate) {
        //         $query->select('flash_sale.products_id')->from('flash_sale')->where('flash_sale.flash_status', '=', '1');
        //     });

        // }
        
        if (!empty($data['brand_id']) && $data['brand_id'] != "") {
            $categories->where('products.brand_id', '=', $data['brand_id']);
        }
        //get single products
        if (!empty($data['product_id']) && $data['product_id'] != "") {
            $categories->where('products.id', '=', $data['product_id']);
        }

        //for min and maximum price
        if (!empty($max_price)) {
            $categories->whereBetween('products.price', [$min_price, $max_price]);
        }

        if (!empty($data['search'])) {

            $searchValue = $data['search'];
            
            $categories->where('products_options.option_name', 'LIKE', '%' . $searchValue . '%')->where('products.status', '=', 'Active');

            if (!empty($data['categories_id'])) {
                $categories->where('product_category.category_id', '=', $data['categories_id']);
            }

            if (!empty($data['filters'])) {
                $temp_key = 0;
                foreach ($data['filters']['filter_attribute']['option_values'] as $option_id_temp) {

                    if ($temp_key == 0) {

                        $categories->whereIn('products_attributes.option_id', [$data['filters']['options']])
                            ->where('products_attributes.option_value_id', $option_id_temp);
                        if (count($data['filters']['filter_attribute']['options']) > 1) {

                            $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`product_id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                        }

                    } else {
                        $categories->orwhereIn('products_attributes.options_id', [$data['filters']['options']])
                            ->where('products_attributes.option_value_id', $option_id_temp);

                        if (count($data['filters']['filter_attribute']['options']) > 1) {
                            $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                        }

                    }
                    $temp_key++;
                }

            }

            if (!empty($max_price)) {
                $categories->whereBetween('products.price', [$min_price, $max_price]);
            }
            // $categories->whereNotIn('products.id', function ($query) use ($currentDate) {
            //     $query->select('flash_sale.products_id')->from('flash_sale')->where('flash_sale.flash_status', '=', '1');
            // });
            $categories->orWhere('products_options_values.option_value_name', 'LIKE', '%' . $searchValue . '%')->where('products.status', '=', 'Active');
            if (!empty($data['categories_id'])) {
                $categories->where('product_category.category_id', '=', $data['categories_id']);
            }

            if (!empty($data['filters'])) {
                $temp_key = 0;
                foreach ($data['filters']['filter_attribute']['option_values'] as $option_id_temp) {

                    if ($temp_key == 0) {

                        $categories->whereIn('products_attributes.option_id', [$data['filters']['options']])
                            ->where('products_attributes.option_value_id', $option_id_temp);
                        if (count($data['filters']['filter_attribute']['options']) > 1) {

                            $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`product_id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                        }

                    } else {
                        $categories->orwhereIn('products_attributes.option_id', [$data['filters']['options']])
                            ->where('products_attributes.option_value_id', $option_id_temp);

                        if (count($data['filters']['filter_attribute']['options']) > 1) {
                            $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                        }

                    }
                    $temp_key++;
                }

            }

            if (!empty($max_price)) {
                $categories->whereBetween('products.price', [$min_price, $max_price]);
            }

            // $categories->whereNotIn('products.id', function ($query) use ($currentDate) {
            //     $query->select('flash_sale.products_id')->from('flash_sale')->where('flash_sale.flash_status', '=', '1');
            // });

            $categories->orWhere('products_description.name', 'LIKE', '%' . $searchValue . '%')->where('products.status', '=', 'Active');

            if (!empty($data['categories_id'])) {
                $categories->where('product_category.category_id', '=', $data['categories_id']);
            }

            if (!empty($data['filters'])) {
                $temp_key = 0;
                foreach ($data['filters']['filter_attribute']['option_values'] as $option_id_temp) {

                    if ($temp_key == 0) {

                        $categories->whereIn('products_attributes.option_id', [$data['filters']['options']])
                            ->where('products_attributes.option_value_id', $option_id_temp);
                        if (count($data['filters']['filter_attribute']['options']) > 1) {

                            $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`product_id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                        }

                    } else {
                        $categories->orwhereIn('products_attributes.options_id', [$data['filters']['options']])
                            ->where('products_attributes.option_value_id', $option_id_temp);

                        if (count($data['filters']['filter_attribute']['options']) > 1) {
                            $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`product_id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                        }

                    }
                    $temp_key++;
                }

            }

            if (!empty($max_price)) {
                $categories->whereBetween('products.price', [$min_price, $max_price]);
            }

            // $categories->whereNotIn('products.id', function ($query) use ($currentDate) {
            //     $query->select('flash_sale.products_id')->from('flash_sale')->where('flash_sale.flash_status', '=', '1');
            // });

            //$categories->orWhere('products_model', 'LIKE', '%' . $searchValue . '%')->where('products_status', '=', 1);

            if (!empty($data['categories_id'])) {
                $categories->where('product_category.category_id', '=', $data['categories_id']);
            }

            if (!empty($data['filters'])) {
                $temp_key = 0;
                foreach ($data['filters']['filter_attribute']['option_values'] as $option_id_temp) {

                    if ($temp_key == 0) {

                        $categories->whereIn('products_attributes.option_id', [$data['filters']['options']])
                            ->where('products_attributes.option_value_id', $option_id_temp);
                        if (count($data['filters']['filter_attribute']['options']) > 1) {

                            $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`product_id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                        }

                    } else {
                        $categories->orwhereIn('products_attributes.options_id', [$data['filters']['options']])
                            ->where('products_attributes.option_value_id', $option_id_temp);

                        if (count($data['filters']['filter_attribute']['options']) > 1) {
                            $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`product_id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                        }

                    }
                    $temp_key++;
                }

            }
            // $categories->whereNotIn('products.id', function ($query) use ($currentDate) {
            //     $query->select('flash_sale.products_id')->from('flash_sale')->where('flash_sale.flash_status', '=', '1');
            // });
        }

        if (!empty($data['filters'])) {
            $temp_key = 0;
            foreach ($data['filters']['filter_attribute']['option_values'] as $option_id_temp) {

                if ($temp_key == 0) {

                    $categories->whereIn('products_attributes.option_id', [$data['filters']['options']])
                        ->where('products_attributes.option_value_id', $option_id_temp);
                    if (count($data['filters']['filter_attribute']['options']) > 1) {

                        $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`product_id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                    }

                } else {
                    $categories->orwhereIn('products_attributes.option_id', [$data['filters']['options']])
                        ->where('products_attributes.option_value_id', $option_id_temp);

                    if (count($data['filters']['filter_attribute']['options']) > 1) {
                        $categories->where(DB::raw('(select count(*) from `products_attributes` where `products_attributes`.`product_id` = `products`.`id` and `products_attributes`.`option_id` in (' . $data['filters']['options'] . ') and `products_attributes`.`option_value_id` in (' . $data['filters']['option_value'] . '))'), '>=', $data['filters']['options_count']);
                    }

                }
                $temp_key++;
            }

        }

        //wishlist customer id
        if ($type == "wishlist") {
            $categories->where('liked_customer_id', '=', session('customer_id'));
        }

        //wishlist customer id
        if ($type == "is_feature") {
            $categories->where('products.is_feature', '=', 1);
        }

        $categories->where('products_description.language_id', '=', Session::get('locale'))->where('products.status', '=', 'Active');

        //get single category products
        if (!empty($data['categories_id'])) {
            $categories->where('product_category.category_id', '=', $data['categories_id']);
            $categories->where('categories_description.language_id', '=', Session::get('locale'));
        }else{
            $categories->LeftJoin('product_category', 'products.id', '=', 'product_category.product_id')
                 ->leftJoin('categories', 'categories.id', '=', 'product_category.category_id');
            $categories->whereIn('product_category.category_id', function ($query) use ($currentDate) {
                $query->select('categories.id as category_id')->from('categories');
            });
        }

        if ($type == "topseller") {
            $categories->where('products.ordered', '>', 0);
        }
        if ($type == "mostliked") {
            $categories->where('products.liked', '>', 0);
        }

        $categories->orderBy($sortby, $order)->groupBy('products.id');

        //count
        $total_record = $categories->get();
        $products = $categories->skip($skip)->take($take)->get();

        $result = array();
        $result2 = array();

        //check if record exist
        if (count($products) > 0) {

            $index = 0;
            foreach ($products as $products_data) {

                $reviews = DB::table('reviews')
                    ->leftjoin('users', 'users.id', '=', 'reviews.customer_id')
                    ->leftjoin('reviews_description', 'reviews.id', '=', 'reviews_description.review_id')
                    ->select('reviews.*', 'reviews_description.reviews_text')
                    ->where('product_id', $products_data->id)
                    ->where('reviews.status','Active')
                    ->where('read', '1')
                    ->get();

                $avarage_rate = 0;
                $total_user_rated = 0;

                if (count($reviews) > 0) {
                    $five_star = 0;
                    $five_count = 0;

                    $four_star = 0;
                    $four_count = 0;

                    $three_star = 0;
                    $three_count = 0;

                    $two_star = 0;
                    $two_count = 0;

                    $one_star = 0;
                    $one_count = 0;

                    foreach ($reviews as $review) {

                        //five star ratting
                        if ($review->reviews_rating == '5') {
                            $five_star += $review->reviews_rating;
                            $five_count++;
                        }

                        //four star ratting
                        if ($review->reviews_rating == '4') {
                            $four_star += $review->reviews_rating;
                            $four_count++;
                        }
                        //three star ratting
                        if ($review->reviews_rating == '3') {
                            $three_star += $review->reviews_rating;
                            $three_count++;
                        }
                        //two star ratting
                        if ($review->reviews_rating == '2') {
                            $two_star += $review->reviews_rating;
                            $two_count++;
                        }

                        //one star ratting
                        if ($review->reviews_rating == '1') {
                            $one_star += $review->reviews_rating;
                            $one_count++;
                        }
                    }

                    $five_ratio = round($five_count / count($reviews) * 100);
                    $four_ratio = round($four_count / count($reviews) * 100);
                    $three_ratio = round($three_count / count($reviews) * 100);
                    $two_ratio = round($two_count / count($reviews) * 100);
                    $one_ratio = round($one_count / count($reviews) * 100);
                    if(($five_star + $four_star + $three_star + $two_star + $one_star) > 0){
                        $avarage_rate = (5 * $five_star + 4 * $four_star + 3 * $three_star + 2 * $two_star + 1 * $one_star) / ($five_star + $four_star + $three_star + $two_star + $one_star);
                    }else{
                        $avarage_rate = 0;
                    }
                    $total_user_rated = count($reviews);
                    $reviewed_customers = $reviews;
                } else {
                    $reviewed_customers = array();
                    $avarage_rate = 0;
                    $total_user_rated = 0;

                    $five_ratio = 0;
                    $four_ratio = 0;
                    $three_ratio = 0;
                    $two_ratio = 0;
                    $one_ratio = 0;
                }

                $products_data->rating = number_format($avarage_rate, 2);
                $products_data->total_user_rated = $total_user_rated;

                $products_data->five_ratio = $five_ratio;
                $products_data->four_ratio = $four_ratio;
                $products_data->three_ratio = $three_ratio;
                $products_data->two_ratio = $two_ratio;
                $products_data->one_ratio = $one_ratio;

                //review by users
                $products_data->reviewed_customers = $reviewed_customers;
                $products_id = $products_data->id;
                
                //multiple images
                $products_images = DB::table('products_images')->where('product_id', '=', $products_id)->where('status','Active')->orderBy('sort_order', 'ASC')->get();
                $products_data->images = $products_images;

                //categories
                $categories = DB::table('product_category')
                    ->leftjoin('categories', 'categories.id', 'product_category.category_id')
                    ->leftjoin('categories_description', 'categories_description.id', 'product_category.category_id')
                    ->select('categories.id', 'categories_description.name', 'categories.image', 'categories.icon', 'categories.parent_id', 'categories.slug')
                    ->where('product_id', '=', $products_id)
                    ->where('categories_description.language_id', '=', Session::get('locale'))
                    ->orderby('parent_id', 'ASC')->get();

                $products_data->categories = $categories;
                array_push($result, $products_data);

                $options = array();
                $attr = array();

                $stocks = 0;
                $stockOut = 0;
                if ($products_data->type == 'Simple') {
                    $stocks = DB::table('inventory')->where('product_id', $products_data->id)->where('stock_type', 'in')->sum('stock');
                    $stockOut = DB::table('inventory')->where('product_id', $products_data->id)->where('stock_type', 'out')->sum('stock');
                }

                $result[$index]->defaultStock = $stocks - $stockOut;

                //like product
                if (!empty(session('customer_id'))) {
                    
                    $liked_customers_id = session('customer_id');
                    $categories = DB::table('liked_products')->where('liked_product_id', '=', $products_id)->where('liked_customer_id', '=', $liked_customers_id)->get();

                    if (count($categories) > 0) {
                        $result[$index]->isLiked = 1;
                    } else {
                        $result[$index]->isLiked = 0;
                    }
                } else {
                    $result[$index]->isLiked = 0;
                }

                // fetch all options add join from products_options table for option name
                $products_attribute = DB::table('products_attributes')->where('product_id', '=', $products_id)->groupBy('option_id')->get();
                if (count($products_attribute)) {
                    $index2 = 0;
                    foreach ($products_attribute as $attribute_data) {

                        $option_name = DB::table('products_options')
                            ->leftJoin('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
                            ->select('products_options.option_id', 'products_options_description.option_name as product_option_name', 'products_options_description.language_id')
                            ->where('language_id', '=', Session::get('locale'))->where('products_options.option_id', '=', $attribute_data->option_id)->get();

                        if (count($option_name) > 0) {

                            $temp = array();
                            $temp_option['id'] = $attribute_data->option_id;
                            $temp_option['name'] = $option_name[0]->product_option_name;
                            $temp_option['is_default'] = $attribute_data->is_default;
                            $attr[$index2]['option'] = $temp_option;

                            // fetch all attributes add join from products_options_values table for option value name
                            $attributes_value_query = DB::table('products_attributes')->where('product_id', '=', $products_id)->where('option_id', '=', $attribute_data->option_id)->get();
                            $k = 0;
                            foreach ($attributes_value_query as $products_option_value) {

                                $option_value = DB::table('products_options_values')
                                ->leftJoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                                ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name')
                                ->where('products_options_values_description.language_id', '=', Session::get('locale'))
                                ->where('products_options_values.option_value_id', '=', $products_option_value->option_value_id)->get();

                                $attributes = DB::table('products_attributes')->where([['product_id', '=', $products_id], ['option_id', '=', $attribute_data->option_id], ['option_value_id', '=', $products_option_value->option_value_id]])->get();

                                $temp_i['products_attributes_id'] = $attributes[0]->products_attributes_id;
                                $temp_i['id'] = $products_option_value->option_value_id;
                                $temp_i['value'] = $option_value[0]->option_value_name;
                                $temp_i['price'] = $products_option_value->option_value_price;
                                $temp_i['price_prefix'] = $products_option_value->price_prefix;
                                array_push($temp, $temp_i);
                            }
                            $attr[$index2]['values'] = $temp;
                            $result[$index]->attributes = $attr;
                            $index2++;
                        }
                    }
                } else {
                    $result[$index]->attributes = array();
                }
                $index++;
            }
           
            $responseData = array('success' => '1', 'product_data' => $result, 'message' => Lang::get('website.Returned all products'), 'total_record' => count($total_record));

        } else {
            $responseData = array('success' => '0', 'product_data' => $result, 'message' => Lang::get('website.Empty record'), 'total_record' => count($total_record));
        }

        return ($responseData);
    }
    
    

}
