<?php

namespace App\Http\Controllers\Web;
use App\Models\Customer;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Collection;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DatabaseNotification;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\File;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use PulkitJalan\GeoIP\GeoIP;
use Browser;
use Lang;
use Session;
use DB;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
class CustomerController extends DataController
{

    use AuthenticatesUsers;

    public function showlogin(Request $request){
        if(Auth::guard('customer')->check()){
            return redirect('/');
        }
        $pageTitle = Lang::get('website.Customer Login');
        $commonContent = $this->commonContent();
        return view('web.customer.login',compact('pageTitle','commonContent'));
    }

    public function login(Request $request){
        
        $pageTitle = Lang::get('website.Customer Login');
        $commonContent = $this->commonContent();
        
        $data = $this->validate($request, [
            'login_email'     =>  'required|string|email|max:50',
            'login_password'  =>  'required|string',
          ]);
        $data2['email'] = $request->login_email;
        $data2['password'] = $request->login_password;
        $old_session = Session::getId();
        //$data = $request->only('email', 'password');

        // if (method_exists($this, 'hasTooManyLoginAttempts') &&
        //     $this->hasTooManyLoginAttempts($request)) {
        //     $this->fireLockoutEvent($request);

        //     return $this->sendLockoutResponse($request);
        // }
        if (Auth::guard('customer')->attempt($data2)){
            $user = Customer::where('email',$request->login_email)->first();
            Auth::guard('customer')->login($user);
            //set session				
			session(['customer_id' => $user->id]);
			        $cart = DB::table('customers_basket')->where('session_id',$old_session)->get();
					if(count($cart)>0){					
						foreach($cart as $cart_data){						
							$exist = DB::table('customers_basket')->where([
								['customer_id', '=', $user->id],
								['product_id', '=', $cart_data->product_id],
								['is_order', '=', '0'],
							])->delete();
						}									
					}
					DB::table('customers_basket')->where('session_id','=', $old_session)->update([
						'customer_id'	=>	$user->id
						]);
	
					DB::table('customers_basket_attributes')->where('session_id','=', $old_session)->update([
						'customer_id'	=>	$user->id
						]);
            $request->session()->regenerate();
            $this->authenticated($request, $this->guard('customer')->user());
            return $request->wantsJson() ? new JsonResponse([], 204) : redirect()->route('web.viewCart');
        }
        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        //$this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

    // protected function sendLoginResponse(Request $request){
        
    //     if ($response = $this->authenticated($request, $this->guard('customer')->user())) {
    //         return $response;
    //     }

    //     return $request->wantsJson()
    //                 ? new JsonResponse([], 204)
    //                 : redirect()->route('web.index');
    // }
   
    protected function sendFailedLoginResponse(Request $request){

        throw ValidationException::withMessages([
            $this->username() => [trans('auth.failed')],
        ]);
    }
    
    public function username(){
        return 'login_email';
    }
    
    protected function authenticated(Request $request, $user){
        
        return redirect()->route('web.viewCart');
    }
    
    public function logout(Request $request){
        Auth::logout();
        Auth::guard('customer')->logout();
        session()->flush();
        $request->session()->forget('customer_id');
        return redirect()->route('web.signin');
        // $request->session()->invalidate();
        // $request->session()->regenerateToken();
        // if ($response = $this->loggedOut($request)) {
        //     return $response;
        // }
        // return $request->wantsJson() ? new JsonResponse([], 204) : redirect('/');
    }

    protected function loggedOut(Request $request){
        //
    }

    public function signup(Request $request){
    	 $data = $this->validate($request, [
            'first_name'        =>  'required|string|max:255',
            'last_name'         =>  'required|string|max:255',
            'email'             =>  'required|string|email|max:255|unique:customers',
            'phone'             =>  'required|numeric|min:8',
            'password'          =>  'required|string|min:6',
           // 'dob'             =>  'date|date_format:Y-m-d',
          ]);

        $request = app('request');
        if($request->hasfile('image')){
            $image = $request->file('image');
            $fileName = time() . '.' . $image->getClientOriginalExtension();
            $data['image'] = 'public/assets/customer_profile/'.$fileName;
            Image::make($profile_picture)->resize(100, 100)->save(public_path('/images/customer_images/' . $fileName));
        }else{
            $oldPath = public_path('/images/default_images/default_customer.png');
            $fileExtension = \File::extension($oldPath);
            $newName = time().'.'.$fileExtension;
            $newPathWithName =public_path('/images/customer_images/' .$newName);
            File::copy($oldPath , $newPathWithName);
            $data['image'] = '/images/customer_images/'.$newName;
            } 
            $data['password'] = Hash::make($request->password);  
            $data['phone'] = '+974'.$request->phone; 
            $data['dob'] = date('Y-m-d');  
            
            $geoip = new GeoIP();
            $All = $geoip->get();
            $ip  = $geoip->getIp();
            $data['city'] = $All['city'];
            $data['country'] = $All['country'];
            $data['country_code'] = $All['countryCode'];
            $data['region'] = $All['region'];
            $data['region_code'] = $All['regionCode'];
            $data['timezone'] = $All['timezone'];
            $data['postal_code'] = $All['postalCode'];
            $data['latitude'] = $All['latitude'];
            $data['longitude'] = $All['longitude'];
            $data['ip'] = $ip;
            $data['device'] = Browser::platformName();
            
            Customer::create($data);
            
            $data2['email'] = $request->email;
            $data2['password'] = $request->password;
            $old_session = Session::getId();
            if (Auth::guard('customer')->attempt($data2)){
                    $user = Customer::where('email',$request->email)->first();
                    Auth::guard('customer')->login($user);
                    //set session				
        			session(['customer_id' => $user->id]);
        			        $cart = DB::table('customers_basket')->where('session_id',$old_session)->get();
        					if(count($cart)>0){					
        						foreach($cart as $cart_data){						
        							$exist = DB::table('customers_basket')->where([
        								['customer_id', '=', $user->id],
        								['product_id', '=', $cart_data->product_id],
        								['is_order', '=', '0'],
        							])->delete();
        						}									
        					}
        					DB::table('customers_basket')->where('session_id','=', $old_session)->update([
        						'customer_id'	=>	$user->id
        						]);
        	
        					DB::table('customers_basket_attributes')->where('session_id','=', $old_session)->update([
        						'customer_id'	=>	$user->id
        						]);
                    $request->session()->regenerate();
                    $this->authenticated($request, $this->guard('customer')->user());
                    return $request->wantsJson() ? new JsonResponse([], 204) : redirect()->back();
                }
    }
    
    public function account(Request $request){
        $pageTitle = Lang::get('website.Customer Login');
        $commonContent = $this->commonContent();
        return view('web.customer.profile',compact('pageTitle','commonContent'));
    }
    
    public function updateAccount(Request $request){
        
        $id = Auth::guard('customer')->user()->id;
    	$data = $this->validate($request, [
            'first_name'        =>  'required|string|max:255',
            'last_name'         =>  'required|string|max:255',
            'email'             =>  'required|string|email|max:255|unique:customers,email,'.$id,
            'phone'             =>  'required|numeric|min:8',
           // 'dob'       =>  'date|date_format:Y-m-d',
         ]);
        if(!empty($request->password)){
            $data = $this->validate($request, [
                'password'          =>  'string|min:6',
            ]);  
        $data['password'] = Hash::make($request->password); 
        }
        $request = app('request');
        $request = app('request');
        if($request->hasfile('image')){
            File::delete(public_path(Auth::guard('customer')->image));
            $image = $request->file('image');
            $fileName = time() . '.' . $image->getClientOriginalExtension();
            $data['image'] = 'public/assets/customer_profile/'.$fileName;
            Image::make($profile_picture)->resize(100, 100)->save(public_path('/images/customer_images/' . $fileName));
        }else{
            $data;
            } 
            $data['phone'] = '+974'.$request->phone;
            $data['dob'] = date('Y-m-d');  
            $geoip = new GeoIP();
            $All = $geoip->get();
            $ip  = $geoip->getIp();
            $data['city'] = $All['city'];
            $data['country'] = $All['country'];
            $data['country_code'] = $All['countryCode'];
            $data['region'] = $All['region'];
            $data['region_code'] = $All['regionCode'];
            $data['timezone'] = $All['timezone'];
            $data['postal_code'] = $All['postalCode'];
            $data['latitude'] = $All['latitude'];
            $data['longitude'] = $All['longitude'];
            $data['ip'] = $ip;
            $data['device'] = Browser::platformName();
            Auth::guard('customer')->user()->update($data);
            $message = array('message' => Lang::get('website.Your Account has been updated successfully'));
            return redirect()->back()->with($message);
    }
  
    protected function guard(){
        return Auth::guard('customer');
    }
//====================Other customer methods===========================
    public function likeProduct(Request $request){
        
        if (!empty(Auth::guard('customer')->user()->id)) {
            $liked_product_id = $request->product_id;
            $liked_customer_id = Auth::guard('customer')->user()->id;
            
            //to avoide duplicate record
            $record = DB::table('liked_products')->where([
                'liked_product_id' => $liked_product_id,
                'liked_customer_id' => $liked_customer_id,
            ])->get();

            if (count($record) > 0) {
                
                DB::table('liked_products')->where([
                    'liked_product_id' => $liked_product_id,
                    'liked_customer_id' => $liked_customer_id,
                ])->delete();

                $total_wishlist = 0;
                if (!empty(session('customer_id'))) {
                    $total_wishlist = DB::table('liked_products')
                        ->leftjoin('products', 'products.id', '=', 'liked_products.liked_product_id')
                        ->where('products.status', 'Active')
                        ->where('liked_customer_id', '=', session('customer_id'))->count();
                }

                DB::table('products')->where('id', '=', $liked_product_id)->decrement('liked');
                $products = DB::table('products')->where('id', '=', $liked_product_id)->get();

                $responseData = array('success' => '1', 'message' => Lang::get('website.Product is unliked'), 'total_likes' => $products[0]->liked, 'id' => 'like_count_' . $liked_product_id, 'total_wishlist' => $total_wishlist);
            } else {

                DB::table('liked_products')->insert([
                    'liked_product_id' => $liked_product_id,
                    'liked_customer_id' => $liked_customer_id,
                    'date_liked' => date('Y-m-d H:i:s'),
                ]);
                DB::table('products')->where('id', '=', $liked_product_id)->increment('liked');

                $total_wishlist = 0;
                if (!empty(session('customer_id'))) {
                    $total_wishlist = DB::table('liked_products')
                        ->leftjoin('products', 'products.id', '=', 'liked_products.liked_product_id')
                        ->where('products.status', 'Active')
                        ->where('liked_customer_id', '=', session('customer_id'))->count();
                }
                $products = DB::table('products')->where('id', '=', $liked_product_id)->get();

                $responseData = array('success' => '2', 'message' => Lang::get("website.Product is liked"), 'total_likes' => $products[0]->liked, 'id' => 'like_count_' . $liked_product_id, 'total_wishlist' => $total_wishlist);

            }

        } else {
            $responseData = array('success' => '0', 'message' => Lang::get("website.Please login first to like this product"));
        }
        $cartResponse = json_encode($responseData);
        return $cartResponse;
    }

    public function unlikeMyProduct(Request $request, $id)
    {
        $liked_products_id = $id;
        $liked_customers_id = auth()->guard('customer')->user()->id;
        DB::table('liked_products')->where([
            'liked_product_id' => $liked_products_id,
            'liked_customer_id' => $liked_customers_id,
        ])->delete();
        DB::table('products')->where('id', '=', $liked_products_id)->decrement('liked');
        $message = array('message' => 'Product is unliked');
        return redirect()->back()->with($message);
    }

    public function wishlist(Request $request)
    
    {   $pageTitle = Lang::get('website.View Order');
        $commonContent = $this->commonContent();
        
        $result = array();
        if (!empty($request->limit)) {
            $limit = $request->limit;
        } else {
            $limit = 15;
        }
      
        $data = array('page_number' => 0, 'type' => 'wishlist', 'limit' => $limit, 'categories_id' => '', 'search' => '', 'min_price' => '', 'max_price' => '');
        $products = $this->products($data);
        $result['products'] = $products;
        $cart = '';
        $myVar = new ProductController();
        $result['cartArray'] = $myVar->cartIdArray($cart);
        //liked products
        $result['liked_products'] = $myVar->likedProducts();
        if ($limit > $result['products']['total_record']) {
            $result['limit'] = $result['products']['total_record'];
        } else {
            $result['limit'] = $limit;
        }
        return view('web.orders.wishlist',compact('pageTitle','commonContent','result'));
    }
    public function notify(Request $request){
        $users = User::all();
        $letter = collect(['title'=>'New policy added','body'=>'We have updated our TOC']);
        Notification::send($users,new DatabaseNotification($letter));
        return redirect()->back();
    }
}
