<?php

namespace App\Http\Controllers\Web;
use Illuminate\Support\Facades\Collection;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DatabaseNotification;
use App\Models\User;
use App\Models\Language;
use App\Models\Product;
use App\Models\Gift;
use Illuminate\Http\Request;
use Lang;
use Session;
use DB;
class CartController extends DataController
{

    public function viewCart(Request $request){
        $pageTitle = Lang::get('website.Cart');
        $commonContent = $this->commonContent();
        
        $cart = DB::table('customers_basket')
            ->join('products', 'products.id', '=', 'customers_basket.product_id')
            ->join('products_description', 'products_description.product_id', '=', 'products.id')
           ->leftjoin('gifts', 'gifts.id', '=', 'customers_basket.gift_id')
            ->select('customers_basket.*',
                'products.type', 'products.min_order', 'products.max_stock as max_order',
                'products.image', 'products_description.name','products_description.short_description', 'products.price','products.slug','gifts.image as gift_image','gifts.price as gift_price','gifts.id as gift_id'
                )
            ->where([
                ['customers_basket.is_order', '=', '0'],
                ['products_description.language_id', '=', Session::get('locale')],
            ]);

        if (empty(session('customer_id'))) {
            $cart->where('customers_basket.session_id', '=', Session::getId());
        } else {
            $cart->where('customers_basket.customer_id', '=', session('customer_id'));
        }

        if (!empty($baskit_id)) {
            $cart->where('customers_basket.basket_id', '=', $baskit_id);
        }

        $baskit = $cart->get();
        $total_carts = count($baskit);
        $result = array();
        $index = 0;
        if ($total_carts > 0) {
            foreach ($baskit as $cart_data) {
               //categories
                 $categories = DB::table('product_category')
                    ->leftjoin('categories', 'categories.id', 'product_category.category_id')
                    ->leftjoin('categories_description', 'categories_description.categories_id', 'product_category.category_id')
                    ->select('categories.id as category_id', 'categories_description.name as category_name', 'categories.image as category_image', 'categories.icon as category_icon', 'categories.parent_id')
                    ->where('product_category.product_id', '=', $cart_data->product_id)
                    ->where('categories_description.language_id', '=', Session::get('locale'))->get();
                if(!empty($categories) and count($categories)>0){
                    $cart_data->categories = $categories;
                }else{
                    $cart_data->categories = array();
                }
                
                
                array_push($result, $cart_data);

                //default product
                $stocks = 0;
                if ($cart_data->type == 'Simple') {

                    $currentStocks = DB::table('inventory')->where('product_id', $cart_data->product_id)->get();
                    if (count($currentStocks) > 0) {
                        foreach ($currentStocks as $currentStock) {
                            $stocks += $currentStock->stock;
                        }
                    }

                    if (!empty($cart_data->max_order) and $cart_data->max_order != 0) {
                        if ($cart_data->max_order >= $stocks) {
                            $result[$index]->max_order = $stocks;
                        }
                    } else {
                        $result[$index]->max_order = $stocks;
                    }
                    $index++;

                } else {

                    $attributes = DB::table('customers_basket_attributes')
                        ->join('products_options', 'products_options.option_id', '=', 'customers_basket_attributes.option_id')
                        ->join('products_options_description', 'products_options_description.option_id', '=', 'customers_basket_attributes.option_id')
                        ->join('products_options_values', 'products_options_values.option_value_id', '=', 'customers_basket_attributes.option_value_id')
                        ->leftjoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'customers_basket_attributes.option_value_id')
                        ->leftjoin('products_attributes', function ($join) {
                            $join->on('customers_basket_attributes.product_id', '=', 'products_attributes.product_id')->on('customers_basket_attributes.option_id', '=', 'products_attributes.option_id')->on('customers_basket_attributes.option_value_id', '=', 'products_attributes.option_value_id');
                        })
                        ->select('products_options_description.option_name as attribute_name', 'products_options_values_description.option_value_name as attribute_value', 'customers_basket_attributes.option_id', 'customers_basket_attributes.option_value_id', 'products_attributes.price_prefix as prefix', 'products_attributes.products_attributes_id', 'products_attributes.option_value_price as value_price')

                        ->where('customers_basket_attributes.product_id', '=', $cart_data->product_id)
                        ->where('basket_id', '=', $cart_data->basket_id)
                        ->where('products_options_description.language_id', '=', Session::get('locale'))
                        ->where('products_options_values_description.language_id', '=', Session::get('locale'));

                    if (empty(session('customer_id'))) {
                        $attributes->where('customers_basket_attributes.session_id', '=', Session::getId());
                    } else {
                        $attributes->where('customers_basket_attributes.customer_id', '=', session('customer_id'));
                    }

                    $attributes_data = $attributes->get();
                    //if($index==0){
                    $products_attributes_id = array();
                    //}

                    foreach ($attributes_data as $attributes_datas) {
                        if ($cart_data->type == 'Variable') {
                            $products_attributes_id[] = $attributes_datas->products_attributes_id;
                        }
                    }

                    $qunatity['product_id'] = $cart_data->product_id;
                    $qunatity['attributes'] = $products_attributes_id;

                    $content = $this->productQuantity($qunatity);
                    $stocks = $content['remainingStock'];
                    if (!empty($cart_data->max_order) and $cart_data->max_order != 0) {
                        if ($cart_data->max_order >= $stocks) {
                            $result[$index]->max_order = $stocks;
                        }
                    } else {
                        $result[$index]->max_order = $stocks;
                    }

                    $result[$index]->attributes_id = $products_attributes_id;

                    $result2 = array();
                    if (!empty($cart_data->coupon_id)) {
                        //coupon
                        $coupons = explode(',', $cart_data->coupon_id);
                        $index2 = 0;
                        foreach ($coupons as $coupons_data) {
                            $coupons = DB::table('coupons')->where('coupans_id', '=', $coupons_data)->get();
                            $result2[$index2++] = $coupons[0];
                        }

                    }

                    $result[$index]->coupons = $result2;
                    $result[$index]->attributes = $attributes_data;
                    $index++;
                }
            }
        }
        $result['cart'] = $baskit;
        
       
            $gifts = Gift::select('id','image','price','description_en as description')->get();
            foreach($gifts as $g_data){
                $gift_colors = DB::table('gifts_colors')->leftjoin('gifts_colors_description','gifts_colors_description.color_id','=','gifts_colors.color_id')
                ->where('gifts_colors.gift_id', '=', $g_data->id)->where('gifts_colors_description.language_id',Session::get('locale'))->select('name')->get();
                $g_data->colors = $gift_colors;
            }
        return view('web.products.cart',compact('pageTitle','commonContent','result','total_carts','gifts'));
    }
    //updateCart
	public function updateCart(Request $request){
		if(empty(session('customer_id'))){
			$customer_id					=	'0';
		}else{
			$customer_id					=	session('customer_id');
		}				
		$session_id							=	Session::getId();
		foreach($request->cart as $key=>$customers_basket_id){
			DB::table('customers_basket')->where('basket_id', '=', $customers_basket_id)->update(
			[
				 'customer_id'      => $customer_id,
				 'session_id'       => $session_id,
				 'basket_quantity'  => $request->quantity[$key],
				 'gift_id'          =>$request->gift_id[$key],
			]);
		}
		
		$message = Lang::get("website.Cart has been updated successfully");
		return redirect()->back()->with('message', $message);
	}	
		
    public function deleteCart(Request $request){
        session(['out_of_stock' => 0]);
        $baskit_id = $request->id;
        DB::table('customers_basket')->where('basket_id', $baskit_id)->delete();
        DB::table('customers_basket_attributes')->where('basket_id', $baskit_id)->delete();
        $check = DB::table('customers_basket')->where('customers_basket.session_id', '=', Session::getId())->first();
        
        $message = Lang::get("website.Cart item has been deleted successfully");
		return redirect()->back()->with(['message'=>$message,'$check'=>$check]);
        
    }
    
    public function addToCart(Request $request){
        
        $pageTitle = Lang::get('website.Cart');
        
        $products = Product::all();
        $product_id = $request->product_id;
        $vendor = Product::where('id',$request->product_id)->select('vendor_id')->get();
        $vendor_id = $vendor[0]->vendor_id;

        if (empty(session('customer_id'))) {
            $customer_id = '0';
        } else {
            $customer_id = session('customer_id');
        }

        $session_id = Session::getId();
        $customers_basket_date_added = date('Y-m-d H:i:s');

        if (!empty($request->limit)) {
            $limit = $request->limit;
        } else {
            $limit = 12;
        }

        //min_price
        if (!empty($request->min_price)) {
            $min_price = $request->min_price;
        } else {
            $min_price = '';
        }
        //max_price
        if (!empty($request->max_price)) {
            $max_price = $request->max_price;
        } else {
            $max_price = '';
        }
        if (empty($customer_id)) {
            $exist = DB::table('customers_basket')->where([
                ['session_id', '=', $session_id],
                ['product_id', '=', $product_id],
                ['is_order', '=', 0],
            ])->get();
        } else {
            $exist = DB::table('customers_basket')->where([
                ['customer_id', '=', $customer_id],
                ['product_id', '=', $product_id],
                ['is_order', '=', 0],
            ])->get();
        }
        // $isFlash = DB::table('flash_sale')->where('products_id', $product_id)
        //     ->where('flash_expires_date', '>=', time())->where('flash_status', '=', 1)
        //     ->get();
        // //get products detail  is not default
        // if (!empty($isFlash) and count($isFlash) > 0) {
        //     $type = "flashsale";
        // } else {
        //     $type = "";
        // }
        $type = "";
        $data = array('page_number' => '0', 'type' => $type, 'product_id' => $request->product_id, 'limit' => '15', 'min_price' => '', 'max_price' => '');
        $product = $this->products($data);
        
        if ($product['product_data'][0]->type == 'Simple') {

            //check lower value to match with added stock
            if ($product['product_data'][0]->max_stock != null and $product['product_data'][0]->max_stock < $product['product_data'][0]->defaultStock) {
                $default_stock = $product['product_data'][0]->max_stock;
            } else {
                $default_stock = $product['product_data'][0]->defaultStock;
            }

            if (!empty($exist) and count($exist) > 0) {
                $count = $exist[0]->basket_quantity + $request->quantity;
                $remain = $product['product_data'][0]->defaultStock - $exist[0]->basket_quantity;

                if ($count > $default_stock) {

                    return array('status' => 'exceed', 'defaultStock' => $product['product_data'][0]->defaultStock, 'already_added' => $exist[0]->basket_quantity, 'remain_pieces' => $remain);
                }

                // if ($count >= $product['product_data'][0]->defaultStock || $count > $product['product_data'][0]->products_max_stock and $product['product_data'][0]->products_max_stock != null) {

                //     return array('status' => 'exceed', 'defaultStock' => $product['product_data'][0]->defaultStock, 'already_added' => $exist[0]->customers_basket_quantity, 'remain_pieces' => $remain);
                // }
            } else {

                //if ($request->quantity > $product['product_data'][0]->defaultStock || $request->quantity > $product['product_data'][0]->products_max_stock and $product['product_data'][0]->products_max_stock != null) {
                if ($request->quantity > $default_stock) {
                    $count = $request->quantity;
                    $remain = $product['product_data'][0]->defaultStock - $count;
                    return array('status' => 'exceed');
                }
            }
        }

        // if (!empty($product['product_data'][0]->flash_price)) {
        //     $final_price = $product['product_data'][0]->flash_price + 0;
        // } else
        if (!empty($product['product_data'][0]->discount_price)) {
            $final_price = $product['product_data'][0]->discount_price + 0;
        } else {
            $final_price = $product['product_data'][0]->price + 0;
        }

        //$variables_prices = 0
        if ($product['product_data'][0]->type == 'Variable') {
            $attributeid = $request->attributeid;
            $attribute_price = 0;
            if (!empty($attributeid) and count($attributeid) > 0) {
                foreach ($attributeid as $attribute) {
                    $attribute = DB::table('products_attributes')->where('products_attributes_id', $attribute)->first();
                    $symbol = $attribute->price_prefix;
                    $values_price = $attribute->option_value_price;
                    if ($symbol == '+') {
                        $final_price = intval($final_price) + intval($values_price);
                    }
                    if ($symbol == '-') {
                        $final_price = intval($final_price) - intval($values_price);
                    }
                }
            }
        }

        //check quantity
        if ($product['product_data'][0]->type == 'Variable') {
            $qunatity['product_id'] = $request->product_id;
            $qunatity['attributes'] = $attributeid;
            	
            $content = $this->productQuantity($qunatity);
            //dd($content);
            $stocks = $content['remainingStock'];

        } else {
            $stocks = $product['product_data'][0]->defaultStock;

        }

        if ($stocks <= $product['product_data'][0]->max_stock or $product['product_data'][0]->max_stock == 0) {
            $stocksToValid = $stocks;
        } else {
            $stocksToValid = $product['product_data'][0]->max_stock;
        }

        //check variable stock limit
        if (!empty($exist) and count($exist) > 0) {
            $count = $exist[0]->basket_quantity + $request->quantity;
            if ($count > $stocksToValid) {
                return array('status' => 'exceed');
            }
        }

        if (empty($request->quantity)) {
            $customers_basket_quantity = 1;
        } else {
            $customers_basket_quantity = $request->quantity;
        }

        if ($stocksToValid > $customers_basket_quantity) {
            $customers_basket_quantity = $product['product_data'][0]->min_order;
        }

        //quantity is not default
        if (empty($request->quantity)) {
            $customers_basket_quantity = 1;
        } else {
            $customers_basket_quantity = $request->quantity;
        }

        if ($request->basket_id) {
            $basket_id = $request->basket_id;
            DB::table('customers_basket')->where('basket_id', '=', $basket_id)->update(
                [
                    'customer_id' => $customer_id,
                    'products_id' => $product_id,
                    'session_id' => $session_id,
                    'customers_basket_quantity' => $customers_basket_quantity,
                    'final_price' => $final_price,
                    'customers_basket_date_added' => $customers_basket_date_added,
                ]);

            if (count($request->option_id) > 0) {
                foreach ($request->option_id as $option_id) {

                    DB::table('customers_basket_attributes')->where([
                        ['basket_id', '=', $basket_id],
                        ['product_id', '=', $product_id],
                        ['option_id', '=', $option_id],
                    ])->update(
                        [
                            'customer_id' => $customer_id,
                            'option_value_id' => $request->$option_id,
                            'session_id' => $session_id,
                        ]);
                }

            }
        } else {
            //insert into cart
            if (count($exist) == 0) {

                $customers_basket_id = DB::table('customers_basket')->insertGetId([
                        'customer_id'       =>  $customer_id,
                        'vendor_id'         =>  $vendor_id,
                        'product_id'        =>  $product_id,
                        'session_id'        =>  $session_id,
                        'basket_quantity'   =>  $customers_basket_quantity,
                        'final_price'       =>  $final_price,
                        'basket_date_added' =>  $customers_basket_date_added,
                    ]);

                if (!empty($request->option_id) && count($request->option_id) > 0) {
                    foreach ($request->option_id as $option_id) {

                        DB::table('customers_basket_attributes')->insert(
                            [
                                'customer_id' => $customer_id,
                                'product_id' => $product_id,
                                'option_id' => $option_id,
                                'option_value_id' => $request->$option_id,
                                'session_id' => $session_id,
                                'basket_id' => $customers_basket_id,
                            ]);

                    }

                } else if (!empty($detail['product_data'][0]->attributes)) {

                    foreach ($detail['product_data'][0]->attributes as $attribute) {

                        DB::table('customers_basket_attributes')->insert(
                            [
                                'customer_id' => $customer_id,
                                'product_id' => $product_id,
                                'option_id' => $attribute['option']['id'],
                                'option_value_id' => $attribute['values'][0]['id'],
                                'session_id' => $session_id,
                                'basket_id' => $customers_basket_id,
                            ]);
                    }
                }
            } else {
                $existAttribute = '0';
                $totalAttribute = '0';
                $basket_id = '0';
                if (!empty($request->option_id)) {
                    if (count($request->option_id) > 0) {
                        foreach ($exist as $exists) {
                            $totalAttribute = '0';
                            foreach ($request->option_id as $option_id) {
                                $checkexistAttributes = DB::table('customers_basket_attributes')->where([
                                    ['basket_id', '=', $exists->basket_id],
                                    ['product_id', '=', $product_id],
                                    ['option_id', '=', $option_id],
                                    ['customer_id', '=', $customer_id],
                                    ['option_value_id', '=', $request->$option_id],
                                    ['session_id', '=', $session_id],
                                ])->get();
                                $totalAttribute++;
                                if (count($checkexistAttributes) > 0) {
                                    $existAttribute++;
                                } else {
                                    $existAttribute = 0;
                                }
                            }
                            if ($totalAttribute == $existAttribute) {
                                $basket_id = $exists->basket_id;
                            }
                        }
                    } else
                    if (!empty($detail['product_data'][0]->attributes)) {
                        foreach ($exist as $exists) {
                            $totalAttribute = '0';
                            foreach ($detail['product_data'][0]->attributes as $attribute) {
                                $checkexistAttributes = DB::table('customers_basket_attributes')->where([
                                    ['basket_id', '=', $exists->basket_id],
                                    ['product_id', '=', $product_id],
                                    ['option_id', '=', $attribute['option']['id']],
                                    ['customer_id', '=', $customer_id],
                                    ['option_value_id', '=', $attribute['values'][0]['id']],
                                    ['option_id', '=', $option_id],
                                ])->get();
                                $totalAttribute++;
                                if (count($checkexistAttributes) > 0) {
                                    $existAttribute++;
                                } else {
                                    $existAttribute = 0;
                                }
                                if ($totalAttribute == $existAttribute) {
                                    $basket_id = $exists->basket_id;
                                }
                            }
                        }

                    }

                    //attribute exist
                    if ($basket_id == 0) {

                        $customers_basket_id = DB::table('customers_basket')->insertGetId(
                            [
                                'customer_id'       =>  $customer_id,
                                'vendor_id'         =>  $vendor_id,
                                'product_id'        =>  $product_id,
                                'session_id'        =>  $session_id,
                                'basket_quantity'   =>  $customers_basket_quantity,
                                'final_price'       =>  $final_price,
                                'basket_date_added' =>  $customers_basket_date_added,
                            ]);

                        if (count($request->option_id) > 0) {
                            foreach ($request->option_id as $option_id) {

                                DB::table('customers_basket_attributes')->insert(
                                    [
                                        'customer_id' => $customer_id,
                                        'product_id' => $product_id,
                                        'option_id' => $option_id,
                                        'option_value_id' => $request->$option_id,
                                        'session_id' => $session_id,
                                        'basket_id' => $customers_basket_id,
                                    ]);

                            }

                        } else if (!empty($detail['product_data'][0]->attributes)) {

                            foreach ($detail['product_data'][0]->attributes as $attribute) {

                                DB::table('customers_basket_attributes')->insert(
                                    [
                                        'customer_id' => $customer_id,
                                        'product_id' => $product_id,
                                        'option_id' => $attribute['option']['id'],
                                        'option_value_id' => $attribute['values'][0]['id'],
                                        'session_id' => $session_id,
                                        'basket_id' => $customers_basket_id,
                                    ]);
                            }
                        }

                    } else {

                        //update into cart
                        DB::table('customers_basket')->where('basket_id', '=', $basket_id)->update(
                            [
                                'customer_id' => $customer_id,
                                'product_id' => $product_id,
                                'session_id' => $session_id,
                                'basket_quantity' => DB::raw('basket_quantity+' . $customers_basket_quantity),
                                'final_price' => $final_price,
                                'basket_date_added' => $customers_basket_date_added,
                            ]);

                        if (count($request->option_id) > 0) {
                            foreach ($request->option_id as $option_id) {

                                DB::table('customers_basket_attributes')->where([
                                    ['basket_id', '=', $basket_id],
                                    ['product_id', '=', $product_id],
                                    ['option_id', '=', $option_id],
                                ])->update(
                                    [
                                        'customer_id' => $customer_id,
                                        'option_value_id' => $request->$option_id,
                                        'session_id' => $session_id,
                                    ]);
                            }

                        } else if (!empty($detail['product_data'][0]->attributes)) {

                            foreach ($detail['product_data'][0]->attributes as $attribute) {

                                DB::table('customers_basket_attributes')->where([
                                    ['basket_id', '=', $basket_id],
                                    ['product_id', '=', $product_id],
                                    ['option_id', '=', $option_id],
                                ])->update(
                                    [
                                        'customer_id' => $customer_id,
                                        'product_id' => $product_id,
                                        'option_id' => $attribute['option']['id'],
                                        'option_value_id' => $attribute['values'][0]['id'],
                                        'session_id' => $session_id,
                                        'basket_id' => $customers_basket_id,
                                    ]);
                            }
                        }

                    }

                } else {
                    //update into cart
                    DB::table('customers_basket')->where('basket_id', '=', $exist[0]->basket_id)->update(
                        [
                            'customer_id' => $customer_id,
                            'product_id' => $product_id,
                            'session_id' => $session_id,
                            'basket_quantity' => DB::raw('basket_quantity+' . $customers_basket_quantity),
                            'final_price' => $final_price,
                            'basket_date_added' => $customers_basket_date_added,
                        ]);

                }
                //apply coupon
                if (count(session('coupon')) > 0) {
                    $session_coupon_data = session('coupon');
                    session(['coupon' => array()]);
                    $response = array();
                    if (!empty($session_coupon_data)) {
                        foreach ($session_coupon_data as $key => $session_coupon) {
                            $response = $this->common_apply_coupon($session_coupon->code);
                        }
                    }
                }

            }
        }
        $commonContent = $this->commonContent();
        return view('web.cartButton',compact('commonContent','product'));
       
    }
    
    //addToCartFixed
    public function addToCartFixed(Request $request)
    {
        $commonContent = $this->commonContent();   
        //return view("web.headers.cartButtons.cartButtonFixed")->with('result', $result);
    }
    public function addToCartResponsive(Request $request)
    {
        $commonContent = $this->commonContent();           
        //return view("web.headers.cartButtons.cartButton")->with('result', $result);
    }  
    public function myCart($baskit_id){
        
        $cart = DB::table('customers_basket')
            ->join('products', 'products.id', '=', 'customers_basket.product_id')
            ->join('products_description', 'products_description.product_id', '=', 'products.id')
            ->leftjoin('gifts', 'gifts.id', '=', 'customers_basket.gift_id')
            ->select('customers_basket.*','products.type', 'products.min_order', 'products.max_stock as max_order','products.image', 'products_description.name', 'products.price','products.slug','gifts.price as gift_price')
            ->where([
                ['customers_basket.is_order', '=', '0'],
                ['products_description.language_id', '=', Session::get('locale')],
            ]);

        if (empty(session('customer_id'))) {
            $cart->where('customers_basket.session_id', '=', Session::getId());
        } else {
            $cart->where('customers_basket.customer_id', '=', session('customer_id'));
        }

        if (!empty($baskit_id)) {
            $cart->where('customers_basket.basket_id', '=', $baskit_id);
        }

        $baskit = $cart->get();
        $total_carts = count($baskit);
        $result = array();
        $index = 0;
        if ($total_carts > 0) {
            foreach ($baskit as $cart_data) {
                //categories
                 $categories = DB::table('product_category')
                    ->leftjoin('categories', 'categories.id', 'product_category.category_id')
                    ->leftjoin('categories_description', 'categories_description.categories_id', 'product_category.category_id')
                    ->select('categories.id', 'categories_description.name', 'categories.image', 'categories.icon', 'categories.parent_id')
                    ->where('product_category.product_id', '=', $cart_data->product_id)
                    ->where('categories_description.language_id', '=', Session::get('locale'))->get();
                if(!empty($categories) and count($categories)>0){
                    $cart_data->categories = $categories;
                }else{
                    $cart_data->categories = array();
                }
                array_push($result, $cart_data);

                //default product
                $stocks = 0;
                if ($cart_data->type == 'Simple') {

                    $currentStocks = DB::table('inventory')->where('product_id', $cart_data->product_id)->get();
                    if (count($currentStocks) > 0) {
                        foreach ($currentStocks as $currentStock) {
                            $stocks += $currentStock->stock;
                        }
                    }

                    if (!empty($cart_data->max_order) and $cart_data->max_order != 0) {
                        if ($cart_data->max_order >= $stocks) {
                            $result[$index]->max_order = $stocks;
                        }
                    } else {
                        $result[$index]->max_order = $stocks;
                    }
                    $index++;

                } else {

                    $attributes = DB::table('customers_basket_attributes')
                        ->join('products_options', 'products_options.option_id', '=', 'customers_basket_attributes.option_id')
                        ->join('products_options_description', 'products_options_description.option_id', '=', 'customers_basket_attributes.option_id')
                        ->join('products_options_values', 'products_options_values.option_value_id', '=', 'customers_basket_attributes.option_value_id')
                        ->leftjoin('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'customers_basket_attributes.option_value_id')
                        ->leftjoin('products_attributes', function ($join) {
                            $join->on('customers_basket_attributes.product_id', '=', 'products_attributes.product_id')->on('customers_basket_attributes.option_id', '=', 'products_attributes.option_id')->on('customers_basket_attributes.option_value_id', '=', 'products_attributes.option_value_id');
                        })
                        ->select('products_options_description.option_name as attribute_name', 'products_options_values_description.option_value_name as attribute_value', 'customers_basket_attributes.option_id', 'customers_basket_attributes.option_value_id', 'products_attributes.price_prefix as prefix', 'products_attributes.products_attributes_id', 'products_attributes.option_value_price as value_price')
                        ->where('customers_basket_attributes.product_id', '=', $cart_data->product_id)
                        ->where('basket_id', '=', $cart_data->basket_id)
                        ->where('products_options_description.language_id', '=', Session::get('locale'))
                        ->where('products_options_values_description.language_id', '=', Session::get('locale'));

                    if (empty(session('customer_id'))) {
                        $attributes->where('customers_basket_attributes.session_id', '=', Session::getId());
                    } else {
                        $attributes->where('customers_basket_attributes.customer_id', '=', session('customer_id'));
                    }

                    $attributes_data = $attributes->get();

                    //if($index==0){
                    $products_attributes_id = array();
                    //}

                    foreach ($attributes_data as $attributes_datas) {
                        if ($cart_data->type == 'Variable') {
                            $products_attributes_id[] = $attributes_datas->products_attributes_id;

                        }

                    }
                    

                    $qunatity['product_id'] = $cart_data->product_id;
                    $qunatity['attributes'] = $products_attributes_id;

                    $content = $this->productQuantity($qunatity);
                    $stocks = $content['remainingStock'];
                    if (!empty($cart_data->max_order) and $cart_data->max_order != 0) {
                        if ($cart_data->max_order >= $stocks) {
                            $result[$index]->max_order = $stocks;
                        }
                    } else {
                        $result[$index]->max_order = $stocks;
                    }

                    $result[$index]->attributes_id = $products_attributes_id;

                    $result2 = array();
                    if (!empty($cart_data->coupon_id)) {
                        //coupon
                        $coupons = explode(',', $cart_data->coupon_id);
                        $index2 = 0;
                        foreach ($coupons as $coupons_data) {
                            $coupons = DB::table('coupons')->where('coupans_id', '=', $coupons_data)->get();
                            $result2[$index2++] = $coupons[0];
                        }

                    }

                    $result[$index]->coupons = $result2;
                    $result[$index]->attributes = $attributes_data;
                    $index++;
                }
            }
        }
        return ($result);
    }
    
    //addToCart
	public function cartButton(Request $request){		
		$commonContent = $this->commonContent();
		return view('web.cartButton',compact('commonContent'));
	}	
  
	function productQuantity($data){
		
		if(!empty($data['attributes'])){
			
		$inventory_ref_id = '';
		$product_id = $data['product_id'];
		$attributes = array_filter($data['attributes']);
		$attributeid = implode(',',$attributes);
		$postAttributes = count($attributes);
				
		$inventories = DB::table('inventory')->where('product_id',$product_id)->get();
		
		$reference_ids = array();
		$stockIn = 0;
		$stockOut = 0;
		$inventory_ref_id = array();
		foreach($inventories as $inventory){
			
			$totalAttribute = DB::table('inventory_detail')->where('inventory_detail.inventory_ref_id','=',$inventory->inventory_ref_id)->get();
			$totalAttributes = count($totalAttribute);
			
			if($postAttributes>$totalAttributes){
				$count = $postAttributes;
			}elseif($postAttributes<$totalAttributes or $postAttributes==$totalAttributes){
				$count = $totalAttributes;
			}			
			
			$individualStock = DB::table('inventory')
			    /*->leftjoin('inventory_detail','inventory_detail.inventory_ref_id','=','inventory.inventory_ref_id')
				->selectRaw('inventory.*')
				->whereIn('inventory_detail.attribute_id', [$attributeid])
				->where(DB::raw('(select count(*) from `inventory_detail` where `inventory_detail`.`attribute_id` in ('.$attributeid.') and `inventory_ref_id`= "'.$inventory->inventory_ref_id.'")'),'=',$count)
				->where('inventory.inventory_ref_id','=',$inventory->inventory_ref_id)				
				->groupBy('inventory_detail.inventory_ref_id')*/
				->get();		
				
			if(count($individualStock)>0){	
		
				if($individualStock[0]->stock_type=='in'){
					$stockIn += $individualStock[0]->stock;
				}
					
				if($individualStock[0]->stock_type=='out'){
					$stockOut += $individualStock[0]->stock;
				}
							
				$inventory_ref_id[] = $individualStock[0]->inventory_ref_id;
			}
			
		}
			
		//get option name and value
		$options_names  = array();
		$options_values = array(); 
		foreach($attributes as $attribute){
			$productsAttributes = DB::table('products_attributes')
					->leftJoin('products_options','products_options.option_id','=','products_attributes.option_id')
					->leftJoin('products_options_values','products_options_values.option_value_id','=','products_attributes.option_value_id')
					->select('products_attributes.*', 'products_options.option_name', 'products_options_values.option_value_name')
					->where('products_attributes_id',$attribute)->get();
			
			
			$options_names[] = $productsAttributes[0]->option_name;
			$options_values[] = $productsAttributes[0]->option_value_name;
		}
		
		$options_names_count = count($options_names);
		$options_names = implode ( "','", $options_names);
		$options_names = "'" . $options_names . "'";
		$options_values = "'" . implode ( "','", $options_values ) . "'";
				
		//orders products
		$orders_products = DB::table('orders_products')->where('product_id',$product_id)->get();
		//$stockOut = 0;
		/*foreach($orders_products as $orders_product){
			$totalAttribute = DB::table('orders_products_attributes')->where('orders_products_id','=',$orders_product->orders_products_id)->get();
			$totalAttributes = count($totalAttribute);
			
			if($postAttributes>$totalAttributes){
				$count = $postAttributes;
			}elseif($postAttributes<$totalAttributes or $postAttributes==$totalAttributes){
				$count = $totalAttributes;
			}	
						
			$products = DB::select("select orders_products.* from `orders_products` left join `orders_products_attributes` on `orders_products_attributes`.`orders_products_id` = `orders_products`.`orders_products_id` where `orders_products`.`products_id`='".$products_id."' and `orders_products_attributes`.`products_options` in (".$options_names.") and `orders_products_attributes`.`products_options_values` in (".$options_values.") and (select count(*) from `orders_products_attributes` where `orders_products_attributes`.`products_id` = '".$products_id."' and `orders_products_attributes`.`products_options` in (".$options_names.") and `orders_products_attributes`.`products_options_values` in (".$options_values.") and `orders_products_attributes`.`orders_products_id`= '".$orders_product->orders_products_id."') = ".$count." and `orders_products`.`orders_products_id` = '".$orders_product->orders_products_id."' group by `orders_products_attributes`.`orders_products_id`");
			
			if(count($products)>0){
				$stockOut += $products[0]->products_quantity;
			}			
		}*/
		
		$result = array();
	
		$result['remainingStock'] = $stockIn - $stockOut;
		
		if(!empty($inventory_ref_id)){
		$inventory_ref_id = implode(',',$inventory_ref_id);
		 $minMax = DB::table('manage_min_max')->where([['inventory_ref_id', $inventory_ref_id],['product_id',$product_id]])->get();		
		}else{
			$minMax = '';
		}
		
		$result['inventory_ref_id'] = $inventory_ref_id;		
		$result['minMax'] = $minMax;
		
		}else{
			$result['inventory_ref_id'] = 0;		
			$result['minMax'] = 0;
			$result['remainingStock'] = 0;
		}
		
		 return $result;
	}
	
	public function addGift(Request $request){
	    if(empty(session('customer_id'))){
			$customer_id					=	'0';
		}else{
			$customer_id					=	session('customer_id');
		}
	    $session_id							=	Session::getId();
	    if(!empty($request->basket_id) && !empty($request->product_id) && !empty($request->gift_id)){
	        
	      DB::table('customers_basket')->where('basket_id', '=', $request->basket_id)->where('product_id','=',$request->product_id)->update([
				 'customer_id'      => $customer_id,
				 'session_id'       => $session_id,
				 'gift_id'          => $request->gift_id,
				 'gift_comments'    => $request->gift_comments,
				 'gift_color'       => $request->gift_color
			]);  
		return array('message'=> Lang::get('Gift packing added successfully !'));
	    }else{
	    return array('message'=> Lang::get('Something went wrong try again !'));
	    }
	    
	}
	
	public function deleteGift(Request $request){
	    if(empty(session('customer_id'))){
			$customer_id					=	'0';
		}else{
			$customer_id					=	session('customer_id');
		}
	    $session_id							=	Session::getId();
	     DB::table('customers_basket')->where('basket_id', '=', $request->basket_id)->where('gift_id','=',$request->gift_id)->update([
				 'customer_id'      => $customer_id,
				 'session_id'       => $session_id,
				 'gift_id'          => 0,
				 'gift_comments'    => NULL,
				 'gift_color'       => NULL
			]); 
	    $message = Lang::get("website.Gift Packing has been removed successfully !");
		return redirect()->back()->with(['message'=>$message]);
	}
	
	
}
