<?php

namespace App\Http\Controllers\App;
use App\Models\Category;
use App\Models\Language;
use App\Models\Product;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Auth;
class ProductsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('product.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        
        $data = Product::leftJoin('products_description','products_description.product_id', '=', 'products.id')
            ->leftJoin('users','users.id', '=', 'products.user_id')
    		->LeftJoin('products_specials', function ($join) {
                $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');
            });
            // $data->leftJoin('product_category', 'products.id', '=', 'product_category.product_id')
            // ->leftJoin('categories', 'categories.id', '=', 'product_category.category_id')
            // ->leftJoin('categories_description', 'categories.id', '=', 'categories_description.categories_id');
	
		$data->select(
		    'products.*',
		    'products_description.name',
		    //'categories_description.name as category_name',
		    'products_specials.special_id',
		    'products_specials.product_id as special_product_id', 
		    'products_specials.special_new_product_price as special_price',
            'products_specials.special_date_added', 
            'products_specials.special_last_modified',
            'products_specials.expires_date',
            'users.first_name','users.last_name'
		    )
		->where('products_description.language_id', '1');//->where('categories_description.language_id', '1');
		$products = $data->orderBy('products.id', 'DESC')->get();
        return view('admin.products.index',compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('category.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $language_id = '1';
        $languages = Language::all();
        $myVar = new CategoriesController();
		$categories = $myVar->categories($language_id);

        return view('admin.products.create',compact('languages','categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // if (!Gate::allows('product.create') && !Gate::allows('all')) {
        //     $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
        //     return redirect('admin/dashboard')->with($message);
        // }
    $languages = Language::all();
    foreach($languages as $language){
        $data2 = $this->validate($request, [
            'name_'.$language->id => 'required|string|max:100|regex:/^[\pL\s\-]+$/u',
            'description_'.$language->id => 'required|string',
        ]);	
    }
    $data = $this->validate($request, [
        'type'          =>'in:Simple,Variable,External',
        'image'         => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        'price'         => 'required|numeric',
        //'categories'    => 'required|numeric',
        'min_order'     => 'required|numeric'
    ]);
    $data['user_id'] = Auth::user()->id;
    $data['quantity'] =0;
    $data['max_stock'] =$request->max_stock;
    $data['low_limit'] = 0;
    if($request->hasfile('image')){
        $image = $request->file('image');
        $filename = time() . '-image.' . $image->getClientOriginalExtension();
        Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
        $data['image'] = '/images/products_images/'.$filename;
    }else{
        $data;
        }
        $id = Product::create($data)->id;  
           
        foreach($request->categories as $c_id){
            DB::table('product_category')->Insert(['product_id'=>$id,'category_id'=>$c_id]);
        }
           
        $myVar = new SettingsController();
        $slug_flag = false;	
        //multiple lanugauge with record 
        foreach($languages as $language){

            $name = 'name_'.$language->id;
            $description = 'description_'.$language->id;
            $shoer_description = 'short_description_'.$language->id;
            $url = $name;
            //slug
            if($slug_flag==false){
                $slug_flag=true;
                $slug = $request->$name;
                $old_slug = $request->$name;
                $slug_count = 0;
                do{
                    if($slug_count==0){
                        $currentSlug = $myVar->slugify($old_slug);
                    }else{
                        $currentSlug = $myVar->slugify($old_slug.'-'.$slug_count);
                    }
                    $slug = $currentSlug;
                    $checkSlug = Product::where('slug',$currentSlug)->get();
                    $slug_count++;
                }
                while(count($checkSlug)>0);
                Product::where('id',$id)->update([
                    'slug'	 =>   $slug
                    ]);
            }			
            DB::table('products_description')->insert([
                    'name'              =>   $request->$name,
                    'description'       =>   $request->$description,
                    'short_description'       =>   $request->$shoer_description,
                    'url'               =>   $url,
                    'product_id'        =>   $id,
                    'language_id'       =>   $language->id
                ]);
        
        }
        //special product
        if($request->isSpecial == 'yes'){
          DB::table('products_specials')->where('product_id', '=', $id)->update([
              'special_last_modified' => time(),
              'date_status_change' => time(),
              'status' => 'InActive',
          ]);
          DB::table('products_specials')->insert([
              'product_id' => $id,
              'special_new_product_price' => $request->special_new_product_price,
              'special_date_added' => time(),
              'special_last_modified' => 0,
              'date_status_change'=>0,
              'expires_date' => 12321234,//strtotime(str_replace('/', '-', $request->expires_date)),
              'status' => $request->status,
          ]);
        }
    
    $message = array('message' => 'product has been added successfully','type' => 'success');
    return redirect()->back()->with($message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $product = product::find($id);
        //get function from other controller
		$language_id = '1';
		$languages = Language::all();
        $myVar = new CategoriesController();
		$categories = $myVar->categories($language_id);

		$product = product::find($id);
		$description = array();		
		foreach($languages as $language){
			$products_description= DB::table('products_description')->where([
					['language_id', '=', $language->id],
					['product_id', '=', $id],
				])->get();
				
			if(count($products_description)>0){								
				$description[$language->id]['name'] = $products_description[0]->name;
                $description[$language->id]['description'] = $products_description[0]->description;
                $description[$language->id]['short_description'] = $products_description[0]->short_description;
				$description[$language->id]['language_name'] = $language->name;
				$description[$language->id]['language_id'] = $language->id;										
			}else{
				$description[$language->id]['name'] = '';
                $description[$language->id]['description'] = '';
                $description[$language->id]['short_description'] = '';
				$description[$language->id]['language_name'] = $language->name;
				$description[$language->id]['language_id'] = $language->id;	
			}
		}

        $product_category = DB::table('product_category')
                    ->leftJoin('categories','categories.id','=','product_category.category_id')
                    ->leftJoin('categories_description','categories_description.categories_id', '=', 'categories.id')
                    ->select('categories.*','product_category.category_id')				
                    ->where('product_id','=', $id)->where('categories_description.language_id','=', $language_id )
                    ->get();

        $subCategories = array();
        $mainCategories = array();

        foreach($product_category as $category){
            if($category->parent_id==0){
                $mainCategories[] = $category->id;
            }
            if($category->parent_id!=0){
                $subCategories[] = $category->id;				
            }
        }
        
    $getSpecialProduct = DB::table('products_specials')->where('product_id', $id)->orderby('special_id', 'desc')->limit(1)->get();
    if(count($getSpecialProduct)>0){
        $specialProduct = $getSpecialProduct;
    }else{
        $specialProduct[0] = (object) array('special_id'=>'', 'product_id'=>'', 'special_new_product_price'=>'', 'status'=>'', 'expires_date' => '');
    }
    
        return view('admin.products.edit',compact('description','categories','product','subCategories','mainCategories','specialProduct'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        foreach($languages as $language){
            $data2 = $this->validate($request, [
                'name_'.$language->id => 'required|string|max:100|',
                'description_'.$language->id => 'required|string',
            ]);	
        }
        $data = $this->validate($request, [
            'type'          =>'in:Simple,Variable,External',
            'image'         => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            'price'         => 'required|numeric',
            //'categories'    => 'required|numeric',
            'min_order'     => 'required|numeric'
        ]);
        $product = Product::find($id);
        if($request->hasfile('image')){
            File::delete(public_path($product->image));
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
            $data['image'] = '/images/products_images/'.$filename;
        }else{
            $data;
            }
            $data['quantity'] =0;
            $data['max_stock'] =$request->max_stock;
            $data['low_limit'] = 0;
            $data['updated_at']=date('Y-m-d H:i:s');
            Product::where('id', $id)->update($data);
            
            foreach($request->categories as $c_id){
                DB::table('product_category')->insertOrIgnore(['product_id'=>$id,'category_id'=>$c_id]);
            }
		foreach($languages as $language){
			$name = 'name_'.$language->id;
            $desription = 'description_'.$language->id;
            $short_desription = 'short_description_'.$language->id;
			$checkExist = DB::table('products_description')->where('product_id','=',$id)->where('language_id','=',$language->id)->get();			
			if(count($checkExist)>0){
				DB::table('products_description')->where('product_id','=',$id)->where('language_id','=',$language->id)->update([
					'name'  	    		 =>   $request->$name,
                    'description'            =>   $request->$desription,
                    'short_description'      =>   $request->$short_desription,
                    'url'                    =>   $request->$name
					]);
			}else{
				DB::table('products_description')->insert([
					'name'  	             =>   $request->$name,
                    'description'            =>   $request->$desription,
                    'short_description'      =>   $request->$short_desription,
					'language_id'			 =>   $language->id,
					'service_id'			 =>   $id,
					'url'                    =>   $request->$name
					]);
			}
		}
		//special product
        if($request->isSpecial == 'yes'){
          DB::table('products_specials')->where('product_id', '=', $id)->update([
              'special_last_modified' => time(),
              'date_status_change' => time(),
              'status' => 'InActive',
          ]);
          DB::table('products_specials')->insert([
              'product_id' => $id,
              'special_new_product_price' => $request->special_new_product_price,
              'special_date_added' => time(),
              'expires_date' => strtotime(str_replace('/', '-', $request->expires_date)),
              'status' => $request->status,
          ]);
        }
        $message = array('message' => 'Service has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('product.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $get = Product::whereIn('id',$ids)->get();
        $get2 = DB::table('products_images')->whereIn('product_id',$ids)->get();
        foreach($get as $g){
            File::delete(public_path($g->image));
        }
        foreach($get2 as $g){
            File::delete(public_path($g->image));
        }
        Product::whereIn('products.id', $ids)->delete(); 
        DB::table('products_description')->whereIn('product_id', $ids)->delete();
        DB::table('product_category')->whereIn('product_id', $ids)->delete();
        DB::table('products_specials')->whereIn('product_id', $ids)->delete();
        DB::table('products_images')->whereIn('product_id', $ids)->delete();
        $message = array('message' => 'Delete Succeeded','type' => 'success');
        return $message; 
    }
    
    public function productStatus(Request $request){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $product =Product::find($request->id);
        if($product->status =='Active'){
            $product->update(['status' => 'InActive']);	
        }elseif($product->status =='InActive'){
            $product->update(['status' => 'Active']);	
        }
        $message = array('message' => 'Admin Status has been updated successfully','type' => 'success');
        return $message;
       
    }
//=====================Products Attributes=================

    public function createAttributes(Request $request){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $product_id = $request->id;
        $images = DB::table('products_images')->where('product_id', '=', $product_id)->orderBy('sort_order', 'asc')->get();
        return view('admin.products.images.index',compact('images','product_id'));
    }
    
    public function storeAttributes(Request $request){
        if (!Gate::allows('product.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
         $data = $this->validate($request, [
            'product_id'        =>'required|numeric',
            'image'             => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $count = DB::table('products_images')->where('product_id',$request->product_id)->count();
        $data['sort_order'] = $count+1;
        $data['htmlcontent'] = $request->htmlcontent;
         if($request->hasfile('image')){
        $image = $request->file('image');
        $filename = time() . '-image.' . $image->getClientOriginalExtension();
        Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
        $data['image'] = '/images/products_images/'.$filename;
        }
        DB::table('products_images')->insert($data);
        $message = array('message' => 'Product images has been added successfully','type' => 'success');
        return redirect('admin/product/createImage/'.$request->product_id)->with($message);
       
    }
    
    public function editAttributes($id){
         if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $image = DB::table('products_images')->where('id','=', $id)->get();
        return view('admin.products.images.edit',compact('image'));
    }
    
    public function updateAttributes(Request $request){
       if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
         $data = $this->validate($request, [
            'id'        =>'required|numeric',
            'image'     => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $data['htmlcontent'] = $request->htmlcontent;
        $path = DB::table('products_images')->where('id',$request->id)->select('image','product_id')->get();
        if($request->hasfile('image')){
            File::delete(public_path($path[0]->image));
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
            $data['image'] = '/images/products_images/'.$filename;
        }else{
            $data;
        }
        DB::table('products_images')->where('id',$request->id)->update($data);
        $message = array('message' => 'Product images has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
    }
    
    public function destroyAttributes($id){
        if (!Gate::allows('product.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $get = DB::table('products_images')->whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(public_path($g->image));
        }
        DB::table('products_images')->whereIn('id', $ids)->delete();
        $message = array('message' => 'Delete Succeeded','type' => 'success');
        return $message;
    }
    
//=====================Products images=====================

    public function images(Request $request){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $product_id = $request->id;
        $images = DB::table('products_images')->where('product_id', '=', $product_id)->orderBy('sort_order', 'asc')->get();
        return view('admin.products.images.index',compact('images','product_id'));
    }
    
    public function createImage(Request $request){
        if (!Gate::allows('product.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $product_id = $request->id;
        return view('admin.products.images.create',compact('product_id'));
    }
    
    public function storeImage(Request $request){
        if (!Gate::allows('product.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
         $data = $this->validate($request, [
            'product_id'        =>'required|numeric',
            'image'             => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $count = DB::table('products_images')->where('product_id',$request->product_id)->count();
        $data['sort_order'] = $count+1;
        $data['htmlcontent'] = $request->htmlcontent;
         if($request->hasfile('image')){
        $image = $request->file('image');
        $filename = time() . '-image.' . $image->getClientOriginalExtension();
        Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
        $data['image'] = '/images/products_images/'.$filename;
        }
        DB::table('products_images')->insert($data);
        $message = array('message' => 'Product images has been added successfully','type' => 'success');
        return redirect('admin/product/createImage/'.$request->product_id)->with($message);
       
    }
    
    public function editImage($id){
         if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $image = DB::table('products_images')->where('id','=', $id)->get();
        return view('admin.products.images.edit',compact('image'));
    }
    
    public function updateImage(Request $request){
       if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
         $data = $this->validate($request, [
            'id'        =>'required|numeric',
            'image'     => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $data['htmlcontent'] = $request->htmlcontent;
        $path = DB::table('products_images')->where('id',$request->id)->select('image','product_id')->get();
        if($request->hasfile('image')){
            File::delete(public_path($path[0]->image));
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/products_images/' . $filename));
            $data['image'] = '/images/products_images/'.$filename;
        }else{
            $data;
        }
        DB::table('products_images')->where('id',$request->id)->update($data);
        $message = array('message' => 'Product images has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
    }
    
    public function destroyImage($id){
        if (!Gate::allows('product.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $get = DB::table('products_images')->whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(public_path($g->image));
        }
        DB::table('products_images')->whereIn('id', $ids)->delete();
        $message = array('message' => 'Delete Succeeded','type' => 'success');
        return $message;
    }
    
    public function statusImage(Request $request){
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $image = DB::table('products_images')->where('id',$request->id)->select('status')->get();
        if($image[0]->status =='Active'){
            DB::table('products_images')->where('id',$request->id)->update(['status' => 'InActive']);
        }elseif($image[0]->status =='InActive'){
            DB::table('products_images')->where('id',$request->id)->update(['status' => 'Active']);
        }
        $message = array('message' => 'Product Image Status has been updated successfully','type' => 'success');
        return $message;
       
    }
    
    //==================inventory===================
    public function inventory(Request $request){
       
        if (!Gate::allows('product.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        
     $setting = DB::table('currencies')->get();
    // $myVarsetting = new SiteSettingController($setting);
    // $myVaralter = new AlertController($setting);
    $language_id      =   '1';
    $result = array();
    
    $message = array();
    $errorMessage = array();
    //$result['currency'] = $myVarsetting->getSetting();
    $product = DB::table('products')
                ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
                ->LeftJoin('products_specials', function ($join) {
                    $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');

                })
                ->select('products.*', 'products_description.name', 'products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price as special_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
                ->where('products_description.language_id', '=', $language_id);

    $product =  $product->get();
    $result['products'] = $product;
    $products = $product;
    $result['message'] = $message;
    $result['errorMessage'] = $errorMessage;
    $result2 = array();
    $index = 0;
    $stocks = 0;
    $min_level = 0;
    $max_level = 0;
    $purchase_price  = 0;
    if(count($product)>0){
        $product_id = $result['products'][0]->id;
    if($result['products'][0]->type!='Variable'){

      $currentStocks = DB::table('inventory')->where('product_id', $result['products'][0]->id)->get();
      $purchase_price = DB::table('inventory')->where('product_id', $result['products'][0]->id)->sum('purchase_price');

        if(count($currentStocks)>0){
            foreach($currentStocks as $currentStock){
                $stocks += $currentStock->stock;
            }
        }

          $manageLevel = DB::table('manage_min_max')->where('product_id', $result['products'][0]->id)->get();
        if(count($manageLevel)>0){
            $min_level = $manageLevel[0]->min_level;
            $max_level = $manageLevel[0]->max_level;
        }

    }

    $result['purchase_price'] = $purchase_price;
    $result['stocks'] = $stocks;
    $result['min_level'] = $min_level;
    $result['max_level'] = $max_level;
    $products_attribute = DB::table('products_attributes')->where('product_id', '=', 1)->get();
    $products_attribute = $products_attribute->unique('option_id')->keyBy('option_id');
    if(count($products_attribute)>0){
        $index2 = 0;
        foreach($products_attribute as $attribute_data){
          $option_name = DB::table('products_options')
              ->join('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
              ->select('products_options.option_id', 'products_options_description.option_name', 'products_options_description.language_id')
              ->where('products_options_description.language_id', $language_id)
              ->where('products_options.option_id', $attribute_data->option_id)
              ->get();
            if(count($option_name)>0){

                $temp = array();
                $temp_option['id'] = $attribute_data->option_id;
                $temp_option['name'] = $option_name[0]->option_name;
                $attr[$index2]['option'] = $temp_option;
                // fetch all attributes add join from products_options_values table for option value name
                $attributes_value_query = DB::table('products_attributes')
                ->where('product_id', '=', $product_id)
                ->where('option_id', '=', $attribute_data->option_id)
                ->get();
                foreach($attributes_value_query as $products_option_value){
                    $option_value = DB::table('products_options_values')
                    ->join('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                    ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name')
                    ->where('products_options_values_description.language_id', '=', $language_id)
                    ->where('products_options_values.option_value_id', '=', $products_option_value->option_value_id)
                    ->get();
                    if(count($option_value)>0){
                        $attributes = DB::table('products_attributes')
                        ->where([['products_id', '=', $products_id], ['options_id', '=', $attribute_data->option_id], ['options_values_id', '=', $products_option_value->option_value_id]])
                        ->get();
                        $temp_i['products_attributes_id'] = $attributes[0]->products_attributes_id;
                        $temp_i['id'] = $products_option_value->option_value_id;
                        $temp_i['value'] = $option_value[0]->option_value_name;
                        $temp_i['price'] = $products_option_value->option_value_price;
                        $temp_i['price_prefix'] = $products_option_value->price_prefix;
                        array_push($temp,$temp_i);
                    }

                }

                $attr[$index2]['values'] = $temp;
                $result['attributes'] = 	$attr;
                $index2++;

            }
        }

    }else{
        $result['attributes'] = 	array();
    }

    }else{
        $result['attributes'] = 	array();
    }

      return view('admin.products.inventory',compact('result','setting'));
  }
  
    public function addInventory(Request $request){
        $data = $this->validate($request, [
            'product_id'        => 'required|numeric',
            'stock'             => 'required|numeric',
            'purchase_price'    => 'required|numeric'
        ]);
        $language_id     =   1;
        $product = DB::table('products')
            ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
            ->LeftJoin('products_specials', function ($join) {
                $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');
            })
            ->select('products.*', 'products_description.name',  'products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
            ->where('products_description.language_id', '=', $language_id);
            if ($data['product_id'] != null) {
                $product->where('products.id', '=', $data['product_id']);
            } else {
                $product->orderBy('products.id', 'DESC');
            }

        $product =  $product->get();
        $products = $product;
        $date_added	= date('Y-m-d h:i:s');
        $inventory_ref_id = DB::table('inventory')->insertGetId([
            'product_id' => $data['product_id'],
            'reference_code' => $request->reference_code,
            'stock' => $data['stock'],
            'admin_id' => auth()->user()->id,
            'created_at' => $date_added,
            'added_date' => strtotime(date('Y-m-d h:i:s')),
            'purchase_price' => $data['purchase_price'],
            'stock_type'  			=>   'in'
        ]);
        if($products[0]->type=='Variable'){
            foreach($request->attributeid as $attribute){
                if(!empty($attribute)){
                  DB::table('inventory_detail')->insert([
                      'inventory_ref_id' => $inventory_ref_id,
                      'product_id' => $data['product_id'],
                      'attribute_id' => $attribute,
                  ]);
                }
            }
        }
    $message = array('message' => 'Product Stock has been added successfully','type' => 'success');
    return redirect()->back()->with('message');
    }
    
    public function ajax_attr($id){
        $setting = DB::table('currencies')->get();
        $language_id      =   '1';
        $products_id      =   $id;
        $result = array();
        $result['currency'] = $setting;
        $message = array();
        $errorMessage = array();
        $product = DB::table('products')
                    ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
                    ->LeftJoin('products_specials', function ($join) {
                        $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');
                    })
                    ->select('products.*', 'products_description.name','products_description.description',  'products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
                    ->where('products_description.language_id', '=', $language_id);
                if ($products_id != null) {
                    $product->where('products.id', '=', $products_id);
                } else {
                    $product->orderBy('products.id', 'DESC');
                }
    
        $product =  $product->get();
        $result['products'] = $product;
        $products = $product;
        $result['message'] = $message;
        $result['errorMessage'] = $errorMessage;
        $result2 = array();
        $index = 0;
        $stocks = 0;
        $min_level = 0;
        $max_level = 0;
        $purchase_price  = 0;
        if($result['products'][0]->type!='Variable'){
    
          $stocksin = DB::table('inventory')->where('product_id', $result['products'][0]->id)->where('stock_type', 'in')->sum('stock');
          $stockOut = DB::table('inventory')->where('product_id', $result['products'][0]->id)->where('stock_type', 'out')->sum('stock');
          $stocks = $stocksin - $stockOut;
    
              $manageLevel = DB::table('manage_min_max')->where('product_id', $result['products'][0]->id)->get();
            if(count($manageLevel)>0){
                $min_level = $manageLevel[0]->min_level;
                $max_level = $manageLevel[0]->max_level;
            }
    
        }
    
        $result['purchase_price'] = $purchase_price;
        $result['stocks'] = $stocks;
        $result['min_level'] = $min_level;
        $result['max_level'] = $max_level;
        $products_attribute = DB::table('products_attributes')->where('product_id', '=', $products_id)->get();
        $products_attribute = $products_attribute->unique('option_id')->keyBy('option_id');
        if(count($products_attribute)>0){
            $index2 = 0;
            foreach($products_attribute as $attribute_data){
              $option_name = DB::table('products_options')
                  ->join('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
                  ->select('products_options.option_id', 'products_options_description.option_name', 'products_options_description.language_id')
                  ->where('products_options_description.language_id', $language_id)
                  ->where('products_options.option_id', $attribute_data->option_id)
                  ->get();
                if(count($option_name)>0){
    
                    $temp = array();
                    $temp_option['id'] = $attribute_data->option_id;
                    $temp_option['name'] = $option_name[0]->option_name;
                    $attr[$index2]['option'] = $temp_option;
                    // fetch all attributes add join from products_options_values table for option value name
                    $attributes_value_query = DB::table('products_attributes')
                    ->where('products_id', '=', $products_id)
                    ->where('options_id', '=', $attribute_data->option_id)
                    ->get();
                    foreach($attributes_value_query as $products_option_value){
                        $option_value = DB::table('products_options_values')
                        ->join('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                        ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name')
                        ->where('products_options_values_description.language_id', '=', $language_id)
                        ->where('products_options_values.option_value_id', '=', $products_option_value->option_value_id)
                        ->get();
                        if(count($option_value)>0){
                            $attributes = DB::table('products_attributes')
                            ->where([['product_id', '=', $products_id], ['option_id', '=', $attribute_data->option_id], ['option_value_id', '=', $products_option_value->option_value_id]])
                            ->get();
                            $temp_i['products_attributes_id'] = $attributes[0]->products_attributes_id;
                            $temp_i['id'] = $products_option_value->option_value_id;
                            $temp_i['value'] = $option_value[0]->option_value_name;
                            $temp_i['price'] = $products_option_value->option_value_price;
                            $temp_i['price_prefix'] = $products_option_value->price_prefix;
                            array_push($temp,$temp_i);
                        }
    
                    }
    
                    $attr[$index2]['values'] = $temp;
                    $result['attributes'] = 	$attr;
                    $index2++;
    
                }
            }
    
        }else{
    
            $result['attributes'] = 	array();
    
        }
          return $result;
      }
      
    public function ajax_min_max($id){
        $setting = DB::table('currencies')->get();
        $language_id      =   '1';
        $products_id      =   $id;
        $result = array();
        $message = array();
        $errorMessage = array();
        $result['setting'] = $setting;
        $product = DB::table('products')
                    ->leftJoin('products_description', 'products_description.product_id', '=', 'products.id')
                    ->LeftJoin('products_specials', function ($join) {
                        $join->on('products_specials.product_id', '=', 'products.id')->where('products_specials.status', '=', 'Active');
                    })
                    ->select('products.*', 'products_description.name','products_description.description','products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
                    ->where('products_description.language_id', '=', $language_id);
                if ($products_id != null) {
                    $product->where('products.id', '=', $products_id);
                } else {
                    $product->orderBy('products.id', 'DESC');
                }
        $product =  $product->get();
        $result['products'] = $product;
        $products = $product;
        $result['message'] = $message;
        $result['errorMessage'] = $errorMessage;
        $result2 = array();
        $index = 0;
        $stocks = 0;
        $min_level = 0;
        $max_level = 0;
        $purchase_price = DB::table('inventory')->where('product_id', $result['products'][0]->id)->sum('purchase_price');
    
        if($result['products'][0]->type!='Variable'){
    
          $stocksin = DB::table('inventory')->where('product_id', $result['products'][0]->id)->where('stock_type', 'in')->sum('stock');
          $stockOut = DB::table('inventory')->where('product_id', $result['products'][0]->id)->where('stock_type', 'out')->sum('stock');
          $stocks = $stocksin - $stockOut;
    
            $manageLevel = DB::table('manage_min_max')->where('product_id', $result['products'][0]->id)->get();
            if(count($manageLevel)>0){
                $min_level = $manageLevel[0]->min_level;
                $max_level = $manageLevel[0]->max_level;
            }
    
        }
    
        $result['purchase_price'] = $purchase_price;
        $result['stocks'] = $stocks;
        $result['min_level'] = $min_level;
        $result['max_level'] = $max_level;
        $products_attribute = DB::table('products_attributes')->where('product_id', '=', $products_id)->get();
        $products_attribute = $products_attribute->unique('option_id')->keyBy('option_id');
        if(count($products_attribute)>0){
            $index2 = 0;
            foreach($products_attribute as $attribute_data){
              $option_name = DB::table('products_options')
                  ->join('products_options_description', 'products_options_description.option_id', '=', 'products_options.option_id')
                  ->select('products_options.option_id', 'products_options_description.option_name', 'products_options_description.language_id')
                  ->where('products_options_description.language_id', $language_id)
                  ->where('products_options.option_id', $attribute_data->option_id)
                  ->get();
                if(count($option_name)>0){
    
                    $temp = array();
                    $temp_option['id'] = $attribute_data->option_id;
                    $temp_option['name'] = $option_name[0]->option_name;
                    $attr[$index2]['option'] = $temp_option;
                    // fetch all attributes add join from products_options_values table for option value name
                    $attributes_value_query = DB::table('products_attributes')
                    ->where('product_id', '=', $products_id)
                    ->where('option_id', '=', $attribute_data->option_id)
                    ->get();
                    foreach($attributes_value_query as $products_option_value){
                        $option_value = DB::table('products_options_values')
                        ->join('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'products_options_values.option_value_id')
                        ->select('products_options_values.option_value_id', 'products_options_values_description.option_value_name')
                        ->where('products_options_values_description.language_id', '=', $language_id)
                        ->where('products_options_values.option_value_id', '=', $products_option_value->option_value_id)
                        ->get();
                        if(count($option_value)>0){
                            $attributes = DB::table('products_attributes')
                            ->where([['product_id', '=', $products_id], ['option_id', '=', $attribute_data->option_id], ['option_value_id', '=', $products_option_value->option_value_id]])
                            ->get();
                            $temp_i['products_attributes_id'] = $attributes[0]->products_attributes_id;
                            $temp_i['id'] = $products_option_value->option_value_id;
                            $temp_i['value'] = $option_value[0]->option_value_name;
                            $temp_i['price'] = $products_option_value->option_value_price;
                            $temp_i['price_prefix'] = $products_option_value->price_prefix;
                            array_push($temp,$temp_i);
                        }
    
                    }
    
                    $attr[$index2]['values'] = $temp;
                    $result['attributes'] = 	$attr;
                    $index2++;
    
                }
            }
    
        }else{
    
            $result['attributes'] = 	array();
    
        }
          return $result;
      }
      
    public function addminmax($request){
        $data = $this->validate($request, [
            'product_id'        => 'required|numeric',
            'inventory_ref_id'  => 'required|numeric',
            'min_level'         => 'required|numeric',
            'max_level'         => 'required|numeric',
        ]);
    $products_id = $request->product_id;
    $language_id     =   1;
    $product = DB::table('products')
                ->leftJoin('products_description', 'products_description.products_id', '=', 'products.id')
                ->LeftJoin('specials', function ($join) {
                    $join->on('products_specials.products_id', '=', 'products.products_id')->where('status', '=', '1');
                })
                ->select('products.*', 'products_description.name',  'products_specials.special_id', 'products_specials.product_id as special_product_id', 'products_specials.special_new_product_price', 'products_specials.special_date_added', 'products_specials.special_last_modified', 'products_specials.expires_date')
                ->where('products_description.language_id', '=', $language_id);
            if ($products_id != null) {
                $product->where('products.id', '=', $products_id);
            } else {
                $product->orderBy('products.id', 'DESC');
            }
            $product =  $product->get();

            $products = $product;
    if($products[0]->type=='Variable'){
        $inventory_ref_id = $request->inventory_ref_id;
    }else{
        $inventory_ref_id = 0;
    }
    $checkExist = DB::table('manage_min_max')
                    ->where('product_id', $products_id)
                    ->where('inventory_ref_id', $inventory_ref_id)
                    ->get();
    if(count($checkExist)==0){
      $manageMaxandMin = DB::table('manage_min_max')->insertGetId([
          'product_id' => $products_id,
          'min_level' => $request->min_level,
          'max_level' => $request->max_level,
          'inventory_ref_id' => $inventory_ref_id,
      ]);
    }else{
      $minandmax = DB::table('manage_min_max')->where('product_id', $products_id)->update([
          'min_level' => $request->min_level,
          'max_level' => $request->max_level,
          'inventory_ref_id' => $inventory_ref_id,
      ]);
    }
    $message = array('message' => 'Product Min Max Level has been added successfully','type' => 'success');
    return redirect()->back()->with('message');
  }
}
