<?php

namespace App\Http\Controllers\App;
use App\Models\Customer;
use App\Models\Country;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Collection;
use Illuminate\Support\Facades\Notification;
use App\Notifications\DatabaseNotification;
use Illuminate\Support\Facades\Hash;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use PulkitJalan\GeoIP\GeoIP;
use Browser;
class CustomerController extends Controller
{
    public function countries(Request $request){
        $data = Country::all();
    return response()->json([
        "status" => "Success", 
        "message" => "Success! Countries returned successfully",
        "countries" => $data
        ]);
        
    }
    
    public function login(Request $request){
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
            //'device_name' => 'required',
        ]);
        $customer = Customer::where('email',$request->email)->first();
    
        if (!$customer || ! Hash::check($request->password, $customer->password)) {
            return  response()->json([
                        'status' => 'Fail',
                        'message' => 'Email or password is incorrect !'
                    ]);
        } 
         $token = $customer->createToken('api-token')->plainTextToken;
            return  response()->json([
                'user' => $customer,
                'token' => $token
            ]);
        
    }

    public function signup(Request $request){
        $data = $this->validate($request, [
            'first_name'=>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            'last_name' =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            'email'     =>  'required|string|email|max:50|unique:customers',
            'password'  =>  'required|string|min:6|confirmed',
            'gender'    =>  'in:Male,Female',
            'dob'       =>  'date|date_format:Y-m-d'
            //'phone'     =>  'string|max:15|unique:customers'
          ]);

          $data['phone'] =$request->phone;
        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(100, 100)->save(public_path('/images/customer_images/' . $filename));
            $data['image'] = '/images/customer_images/'.$filename;
        }else{
            $oldPath = public_path('/images/default_images/default_customer.png');
            $fileExtension = \File::extension($oldPath);
            $newName = time().'.'.$fileExtension;
            $newPathWithName =public_path('/images/customer_images/' .$newName);
            File::copy($oldPath , $newPathWithName);
            $data['image'] = '/images/customer_images/'.$newName;
        } 
        $data['password'] = Hash::make($request->password);
            // $geoip = new GeoIP();
            // $geoip->setIp('37.211.144.40');
            // $All = $geoip->get();
            // $ip  = $geoip->getIp();
            // $data['city'] = $All['city'];
            // $data['country'] = $All['country'];
            // $data['country_code'] = $All['countryCode'];
            // $data['region'] = $All['region'];
            // $data['region_code'] = $All['regionCode'];
            // $data['timezone'] = $All['timezone'];
            // $data['postal_code'] = $All['postalCode'];
            // $data['latitude'] = $All['latitude'];
            // $data['longitude'] = $All['longitude'];
            // $data['ip'] = $ip;
            // $data['device'] = Browser::platformName();
            Customer::create($data);

            return  response()->json([
                'status' => 'Success',
                'message' => 'Account has beed created successully !'
            ]);
    }
    public function updateProfile(Request $request){
        $customer = request()->user();
        $data = $this->validate($request, [
            'first_name'=>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            // 'last_name' =>  'required|string|max:20|regex:/^[\pL\s\-]+$/u',
            // 'email'     =>  'required|string|email|max:50|unique:customers,email,'.$customer->id,
            // 'gender'    =>  'in:Male,Female',
            // 'dob'       =>  'date|date_format:Y-m-d',
            'image'     => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
          ]);

        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(100, 100)->save(public_path('/images/customer_images/' . $filename));
            $data['image'] = '/images/customer_images/'.$filename;
        }else{
            $oldPath = public_path('/images/default_images/default_customer.png');
            $fileExtension = \File::extension($oldPath);
            $newName = time().'.'.$fileExtension;
            $newPathWithName =public_path('/images/customer_images/' .$newName);
            File::copy($oldPath , $newPathWithName);
            $data['image'] = '/images/customer_images/'.$newName;
        } 
       
            // $geoip = new GeoIP();
            // $geoip->setIp('37.211.144.40');
            // $All = $geoip->get();
            // $ip  = $geoip->getIp();
            // $data['city'] = $All['city'];
            // $data['country'] = $All['country'];
            // $data['country_code'] = $All['countryCode'];
            // $data['region'] = $All['region'];
            // $data['region_code'] = $All['regionCode'];
            // $data['timezone'] = $All['timezone'];
            // $data['postal_code'] = $All['postalCode'];
            // $data['latitude'] = $All['latitude'];
            // $data['longitude'] = $All['longitude'];
            // $data['ip'] = $ip;
            // $data['device'] = Browser::platformName();
            Customer::where('id',$customer->id)->update($data);
            return  response()->json([
                'status' => 'Success',
                'message' => 'Account has beed updated successully !'
            ]);
    }
    public function updatePassword(Request $request){
        $customer = request()->user();
        $this->validate($request, [
            'old_password' => 'required|string', 
          ]);
        if (! $customer || ! Hash::check($request->old_password, $customer->password)) {
            return  response()->json(['status' => 'Fail','message' => 'Old password is incorrect !']);  
        }
        $data = $this->validate($request, [
            'password' => 'required|string|min:6', 
          ]);
        $data['password'] = Hash::make($request->password);
        Customer::where('id',$customer->id)->update($data);
        return  response()->json(['status' => 'Success','message' => 'Password has beed updated successully !']);
    
    }
    public function logout(Request $request){
        $customer = request()->user();
        $customer->tokens()->where('id', $customer->currentAccessToken()->id)->delete();
        return  response()->json([
            'status' => 'Success',
            'message' => 'Your are logged out successully !'
        ]);
    }
    public function notify(Request $request){
        $users = User::all();
        $letter = collect(['title'=>'New policy added','body'=>'We have updated our TOC']);
        Notification::send($users,new DatabaseNotification($letter));
        return redirect()->back();
    }
}
