<?php

namespace App\Http\Controllers\Admin;
use App\Models\Slider;
use App\Models\Language;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class SlidersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('slider.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $sliders = Slider::all();
        return view('admin.sliders.index',compact('sliders'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('slider.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
       

        return view('admin.sliders.create',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!Gate::allows('slider.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
            $data = $this->validate($request, [
                'title'=>'required|string',
                'language_id'=>'required|string|max:2',
                'type'=>'required|string',
                'expires_date'=>'date|date_format:Y-m-d',
                'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]); 
            
        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '-slider.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(1800, 846)->save(public_path('/images/slider_images/' . $filename));
            $data['image'] = '/images/slider_images/'.$filename;
        }else{
            $data;
            }
            Slider::create($data);    
        $message = array('message' => 'Slider has been added successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('slider.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $slider = Slider::find($id);
		$languages = Language::all();
		
        return view('admin.sliders.edit',compact('slider','languages'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('slider.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
            $data = $this->validate($request, [
                 'title'=>'required|string',
                'language_id'=>'required|string|max:2',
                'type'=>'required|string',
                'expires_date'=>'date|date_format:Y-m-d',
                'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]); 
            
        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '-slider.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(1800, 846)->save(public_path('/images/slider_images/' . $filename));
            $data['image'] = '/images/slider_images/'.$filename;
        }else{
            $data;
            }
        Slider::where('id',$id)->update($data);    
        $message = array('message' => 'Slider has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('slider.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $get = Slider::whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(public_path($g->image));
        }
        Slider::whereIn('id', $ids)->delete();
        return $message = array('message' => 'Delete Success','type' => 'success');
    }

    public function Status(Request $request){
        if (!Gate::allows('slider.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this action !','type' => 'error');
            return $message;
        }
        $slider =Slider::find($request->id);
        if($slider->status =='Active'){
            $slider->update(['status' => 'InActive']);	
        }elseif($slider->status =='InActive'){
            $slider->update(['status' => 'Active']);	
        }
        $message = array('message' => 'Slider Status has been updated successfully','type' => 'success');
        return $message;
       
    }
}
