<?php

namespace App\Http\Controllers\Admin;
use App\User;
use App\Models\Role;
use App\Models\Permission;
use DB;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class RoleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
     if (!Gate::allows('role.index') && !Gate::allows('all')) {
        $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
        return redirect()->back()->with($message);
    }
        $roles = Role::with('permissions')->get();
        return view("admin.roles.index")->with('roles', $roles);  
    }
     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
         if (!Gate::allows('role.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $permissions = Permission::all();
        return view('admin.roles.create',compact('permissions'));
    }
    public function store(Request $request){
      if (!Gate::allows('role.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }  
        $data = $this->validate($request, [
            'name' => 'required|string|max:50|unique:roles',
            'slug' => 'required|string|max:50|unique:roles',
          ]);
         $role_id=Role::create($data)->id;
       
        if(!empty($request->permission_id)){
            foreach($request->permission_id as $id){
                DB::table('role_permissions')->Insert(['permission_id'=>$id,'role_id'=>$role_id]);
            }
        }
        if($role_id){
            $message = array('message' => 'Admin role has been added successfully !','type' => 'success');
            return redirect()->back()->with($message);
        }else{
            $message = array('message' => 'Some thing went wrong try again !','type' => 'warning');
            return redirect()->back()->with($message);
        }
       
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id){
        if (!Gate::allows('role.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }  
        $role = Role::find($id);
        $permissions = Permission::all();
        $role_permissions = DB::table('role_permissions')->where('role_id',$id)->pluck('permission_id');
        $role->role_permissions=$role_permissions;
        return view('admin.roles.edit',compact('role','permissions'));
      
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
     if (!Gate::allows('role.edit') && !Gate::allows('all')) {
        $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
        return redirect()->back()->with($message);
    }  
        $data = $this->validate($request, [
            'name' => 'required|string|max:50|unique:roles,name,'.$id,
            'slug' => 'required|string|max:50|unique:roles,slug,'.$id,
          ]);
          $data['updated_at']=date('Y-m-d H:i:s');
          Role::find($id)->update($data);
          
            DB::table('role_permissions')->where('role_id',$id)->delete();
            if(!empty($request->permission_id)){
            foreach($request->permission_id as $d){
                DB::table('role_permissions')->Insert([
                    'role_id'=>$id,
                    'permission_id'=>$d,
                  
                ]);
                }
            }
            $message = array('message' => 'Admin role has been updated successfully','type' => 'success');
            return redirect()->back()->with($message);
        
    }
    public function roleStatus(Request $request){
        if (!Gate::allows('role.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }  
        if($request->id==1){
			$message = array('message' => 'You do not have permission to access this action !','type' => 'error');
            return $message;
		}else{
        $status = DB::table('roles')->where('role_id',$request->id)->get();
        if($status[0]->isActive==1){
            $status = 0;
        }else{
            $status = 1;
        }
        DB::table('roles')->where('role_id',$request->id)->update([				
			'isActive'	=>$status,	
			]);		
        $message = array('message' => 'Role Status has been updated successfully','type' => 'success');
        return $message;
        }
         
    }
    public function destroy($id){
       if (!Gate::allows('role.destroy') && !Gate::allows('all')) {
        $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
        return redirect()->back()->with($message);
        }  
        $ids = explode(',', $id);
        Role::whereIn('id',$ids)->delete();
        DB::table('role_user')->whereIn('role_id',$ids)->delete();
        $message = array('message' => 'Delete Succeeded','type' => 'success');
        return   $message;
    }
}
