<?php

namespace App\Http\Controllers\Admin;
use App\Models\Page;
use App\Models\Language;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class PagesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('page.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $pages = Page::leftjoin('pages_description','pages_description.page_id','=','pages.id')
        ->select('pages.*','pages_description.name')
        ->where('pages_description.language_id','en')
        ->get();
        return view('admin.pages.index',compact('pages'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('page.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        return view('admin.pages.create',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!Gate::allows('page.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        foreach($languages as $language){
        $this->validate($request, [
                'name_'.$language->id => 'required|string|max:50',
                'description_'.$language->id => 'required|string'
            ]);
        }
        $data = $this->validate($request, [
            'slug' => 'required|string|max:50|unique:pages',
        ]);
        $slug = str_replace(' ','-' ,trim($request->slug));
		$slug = str_replace('_','-' ,$slug);
        $data['slug'] =  $slug;
		$id = Page::create($data)->id;
		foreach($languages as $language){
			$name = 'name_'.$language->code;
			$description = 'description_'.$language->code;
			DB::table('pages_description')->insert([
					'name'  	    		 =>   $request->$name,
                    'description'			 =>   addslashes($request->$description),
					'language_id'			 =>   $language->code,
					'page_id'				 =>   $id,
                    'created_at'			 =>   date('Y-m-d H:i:s')
					]);
		}	
        $message = array('message' => 'Page has been added successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('page.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $languages = Language::all();
        $page = Page::find($id);
        $description = array();		
		foreach($languages as $language){
			$pages_description= DB::table('pages_description')->where([
					['language_id', '=', $language->code],
					['page_id', '=', $id],
				])->get();
				
			if(count($pages_description)>0){								
				$description[$language->code]['name'] = $pages_description[0]->name;
                $description[$language->code]['description'] = $pages_description[0]->description;
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;										
			}else{
				$description[$language->code]['name'] = '';
                $description[$language->code]['description'] = '';
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;	
			}
		}
        return view('admin.pages.edit',compact('description','page'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('page.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        foreach($languages as $language){
        $this->validate($request, [
                'name_'.$language->code => 'required|string|max:50',
                'description_'.$language->code => 'required|string'
            ]);
        }
        $data = $this->validate($request, [
            'slug' => 'required|string|max:50|unique:pages,slug,'.$id,
        ]);
        $slug = str_replace(' ','-' ,trim($request->slug));
		$slug = str_replace('_','-' ,$slug);
        $data['slug'] =  $slug;
        $data['updated_at']=date('Y-m-d H:i:s');
		Page::where('id', $id)->update($data);
		foreach($languages as $language){
			$name = 'name_'.$language->code;
			$description = 'description_'.$language->code;
			DB::table('pages_description')->where('page_id',$id)->where('language_id',$language->code)->update([
					'name'  	    		 =>   $request->$name,
                    'description'			 =>   addslashes($request->$description),
					'language_id'			 =>   $language->code,
					'page_id'				 =>   $id,
                    'updated_at'			 =>   date('Y-m-d H:i:s')
					]);
		}	
        $message = array('message' => 'Page has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('page.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this action !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $ids = explode(',', $id);
        Page::whereIn('id',$ids)->delete();
        DB::table('pages_description')->whereIn('page_id',$ids)->delete();
        $message = array('message' => 'Delete Successed','type' => 'success');
        return $message;
    }

    public function pageStatus(Request $request){
        if (!Gate::allows('page.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this action !','type' => 'error');
            return $message;
        }
        $page =Page::find($request->id);
        if($page->status =='Active'){
            $page->update(['status' => 'InActive']);	
        }elseif($page->status =='InActive'){
            $page->update(['status' => 'Active']);	
        }
        $message = array('message' => 'Page Status has been updated successfully','type' => 'success');
        return $message;
    }
}
