<?php

namespace App\Http\Controllers\Admin;
use App\Models\Order;
use App\Models\Language;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Auth;
class OrdersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('order.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $language_id = '1';
        $orders = Order::orderBy('created_at', 'DESC')->where('customer_id', '!=', '');

        $orders = $orders->get();
        $index = 0;
        $total_price = array();
        foreach ($orders as $orders_data) {
            if(Auth::user()->user_type == 'Vendor'){
            $orders_products = DB::table('orders_products')->where('order_id',$orders_data->id)->where('vendor_id',Auth::user()->id)->sum(DB::raw('orders_products.final_price + orders_products.gift_price'));//->sum('orders_products.final_price + orders_products.gift_price');
            }else{
            $orders_products = DB::table('orders_products')->where('order_id',$orders_data->id)->sum('orders_products.final_price');  
            }
            $orders[$index]->total_price = $orders_products;
            
            $orders_status_history = DB::table('orders_status_history')
                ->where('order_id', '=', $orders_data->id)
                ->orderby('orders_status_history.date_added', 'DESC')->limit(1)->get();
                
            $orders[$index]->status = $orders_status_history[0]->status;
            $orders[$index]->date_added = $orders_status_history[0]->date_added;
            $orders[$index]->comments = $orders_status_history[0]->comments;
            $index++;
        }
        return view('admin.orders.index',compact('orders'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('category.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        $categories = Category::leftJoin('categories_description','categories_description.categories_id', '=', 'categories.id')
		->select('categories.id', 'categories.image',  'categories.icon', 'categories_description.name')
		->where('categories_description.language_id', '1')->where('parent_id','=',0)->get();

        return view('admin.categories.create',compact('languages','categories'));
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('order.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $order = Order::find($id);
        $language_id = 'en';
        $ordersData = array();       
        $subtotal  = 0;
        Order::where('id',$id)->where('customer_id', '!=', '')->update(['is_seen' => 1]);
        $datas = Order::LeftJoin('orders_status_history', 'orders_status_history.order_id', '=', 'orders.id')
        ->where('orders.id',$id)->orderby('orders_status_history.date_added', 'DESC')->get();

        foreach ($datas as $data) {
            $orders_id = $data->id;
                if(Auth::user()->user_type == 'Vendor'){
                    $orders_products = DB::table('orders_products')
                    ->join('products', 'products.id', '=', 'orders_products.product_id')
                    ->Leftjoin('users', 'users.id', '=', 'orders_products.vendor_id')
                    ->select('orders_products.*','products.image','users.first_name','users.last_name')
                    ->where('orders_products.order_id', '=', $orders_id)
                    ->where('orders_products.vendor_id',Auth::user()->id)->get();
                }else{
                     $orders_products = DB::table('orders_products')
                    ->join('products', 'products.id', '=', 'orders_products.product_id')
                    ->Leftjoin('users', 'users.id', '=', 'products.vendor_id')
                    ->select('orders_products.*','products.image','users.first_name','users.last_name')
                    ->where('orders_products.order_id', '=', $orders_id)->get();
                }
            $i = 0;
            $total_price = 0;
            $total_tax = 0;
            $product = array();
            $subtotal = 0;
           
            foreach ($orders_products as $orders_products_data) {
                $product_attribute = DB::table('orders_products_attributes')
                    ->where([
                        ['product_id', '=', $orders_products_data->product_id],
                        ['order_id', '=', $orders_products_data->order_id],
                    ])
                    ->get();
                $orders_products_data->attribute = $product_attribute;
                
                $product[$i] = $orders_products_data;
                $total_price += $orders_products[$i]->final_price + $orders_products[$i]->gift_price;
                $subtotal += $orders_products[$i]->final_price + $orders_products[$i]->gift_price;
                $i++;
            }
            $data->data = $product;
            $orders_data[] = $data;
        }
        $ordersData['orders_data'] = $orders_data;
        $ordersData['total_price'] = $total_price;
        $ordersData['subtotal'] = $subtotal;
        
        $orderHistory = DB::table('orders_status_history')->orderBy('orders_status_history.date_added', 'DESC')->where('order_id', '=', $id)->get();
            
        return view('admin.orders.edit',compact('order','ordersData','orderHistory'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('order.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        
        
        $old_status = $request->old_status;
      //orders status history
        $orders_history_id = DB::table('orders_status_history')->insertGetId(
            ['order_id' => $id,
                'status' => $request->order_status,
                'date_added' => date('Y-m-d h:i:s'),
                'customer_notified' => '1',
                'comments' => $request->comments,
            ]);
        if ($request->orders_status == 'Completed') {
            $orders_products = DB::table('orders_products')->where('order_id', '=', $id)->get();
            foreach ($orders_products as $products_data) {
                DB::table('products')->where('products_id', $products_data->product_id)->update([
                    'quantity' => DB::raw('product_quantity - "' . $products_data->product_quantity . '"'),
                    'ordered' => DB::raw('ordered + 1'),
                ]);
            }
        }
        if ($request->orders_status == 'Canceled') {
            $orders_products = DB::table('orders_products')->where('order_id', '=', $id)->get();
            foreach ($orders_products as $products_data) {
                $product_detail = DB::table('products')->where('id', $products_data->product_id)->first();
                $inventory_ref_id = DB::table('inventory')->insertGetId([
                    'product_id' => $products_data->product_id,
                    'stock' => $products_data->product_quantity,
                    'admin_id' => auth()->user()->id,
                    'created_at' => date('Y-m-d h:i:s'),
                    'stock_type' => 'in',
                ]);
               
                if ($product_detail->type == 'Variable') {
                    $product_attribute = DB::table('orders_products_attributes')
                        ->where([
                            ['product_id', '=', $products_data->product_id],
                            ['order_id', '=', $products_data->order_id],
                        ])
                        ->get();

                    foreach ($product_attribute as $attribute) {
                      
                        $prodocuts_attributes = DB::table('products_attributes')
                            ->join('products_options_description', 'products_options_description.option_id', '=', 'products_attributes.option_id')
                            ->join('products_options_values_description', 'products_options_values_description.option_value_id', '=', 'option_value_id')
                            ->where('products_options_values_description.option_value_name', $attribute->product_option_value)
                            ->where('products_options_description.option_name', $attribute->product_option)
                            ->select('products_attributes.products_attributes_id')
                            ->first();

                        DB::table('inventory_detail')->insert([
                            'inventory_ref_id' => $inventory_ref_id,
                            'product_id' => $products_data->product_id,
                            'attribute_id' => $prodocuts_attributes->products_attributes_id,
                        ]);

                    }

                }
            }
        }

        $orders = DB::table('orders')->where('id', '=', $id)->where('customer_id', '!=', '')->get();
        $data = array();
        $data['customer_id'] = $orders[0]->customer_id;
        $data['order_id'] = $id;
        $data['status'] = $request->orders_status;
        $message = array('message' => 'Order has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);  
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('order.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        Order::whereIn('id',$ids)->delete();
        DB::table('orders_products')->whereIn('order_id', $ids)->delete();
        DB::table('orders_status_history')->whereIn('order_id', $ids)->delete();
        DB::table('orders_products_attributes')->whereIn('order_id', $ids)->delete();
        
        return $message = array('message' => 'Delete Successed','type' => 'success');
    }
   
}
