<?php

namespace App\Http\Controllers\Admin;
use App\Models\News;
use App\Models\Language;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class NewsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('news.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $news = News::leftJoin('news_description','news_description.news_id', '=', 'news.id')
		->select('news.*','news_description.name')
		->where('news_description.language_id', 'en')->get();

        return view('admin.news.index',compact('news'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('news.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        return view('admin.news.create',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!Gate::allows('category.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        foreach($languages as $language){
            $data2 = $this->validate($request, [
                'name_'.$language->code => 'required|string',
                'description_'.$language->code => 'required|string',
            ]);	
        }
        $data = $this->validate($request, [
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        
        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/news_images/' . $filename));
            $data['image'] = '/images/news_images/'.$filename;
        }else{
            $data;
            }
            $data['slug'] = $request->name_en;
            $data['is_feature'] = $request->is_feature;
            $id = News::create($data)->id;    
            $myVar = new SettingsController();
            
            $slug_flag = false;	
            //multiple lanugauge with record 
            foreach($languages as $language){
                $name= 'name_'.$language->code;
                $description= 'description_'.$language->code;
                //slug
                if($slug_flag==false){
                    $slug_flag=true;
                    $slug = $request->$name;
                    $old_slug = $request->$name;
                    $slug_count = 0;
                    do{
                        if($slug_count==0){
                            $currentSlug = $myVar->slugify($old_slug);
                        }else{
                            $currentSlug = $myVar->slugify($old_slug.'-'.$slug_count);
                        }
                        $slug = $currentSlug;
                        $checkSlug = News::where('slug',$currentSlug)->get();
                        $slug_count++;
                    }
                    while(count($checkSlug)>0);
                    News::where('id',$id)->update([
                        'slug'	 =>   $slug
                        ]);
                }			
                    
                DB::table('news_description')->insert([
                        'name'              =>   $request->$name,
                        'description'       =>   $request->$description,
                        'news_id'           =>   $id,
                        'language_id'       =>   $language->code
                    ]);
            }
        
        $message = array('message' => 'News has been added successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('news.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        
		$languages = Language::all();
		$news = news::find($id);
		$description = array();		
		foreach($languages as $language){
			$news_description= DB::table('news_description')->where([
					['language_id', '=', $language->code],
					['news_id', '=', $id],
				])->get();
			if(count($news_description)>0){								
				$description[$language->code]['name'] = $news_description[0]->name;
				$description[$language->code]['description'] = $news_description[0]->description;
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;										
			}else{
				$description[$language->code]['name'] = '';
				$description[$language->code]['description'] = $news_description[0]->description;
				$description[$language->code]['language_name'] = $language->name;
				$description[$language->code]['language_id'] = $language->code;	
			}
		}
        return view('admin.news.edit',compact('description','news'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('ctegory.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
       $languages = Language::all();
        foreach($languages as $language){
            $data2 = $this->validate($request, [
                'name_'.$language->code => 'required|string',
                'description_'.$language->code => 'required|string',
            ]);	
        }
        $data = $this->validate($request, [
            'image' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $news = News::find($id);
        if($request->hasfile('image')){
            File::delete(public_path($news->image));
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(600, 600)->save(public_path('/images/news_images/' . $filename));
            $data['image'] = '/images/news_images/'.$filename;
        }else{
            $data;
            }
            $data['is_feature'] = $request->is_feature;
            $data['updated_at']=date('Y-m-d H:i:s');
            News::where('id', $id)->update($data);
		foreach($languages as $language){
			$name = 'name_'.$language->code;
			$description = 'description_'.$language->code;
			$checkExist = DB::table('news_description')->where('news_id','=',$id)->where('language_id','=',$language->code)->get();			
			if(count($checkExist)>0){
				DB::table('news_description')->where('news_id','=',$id)->where('language_id','=',$language->code)->update([
					'name'  	    		 =>   $request->$name,
					]);
			}else{
				DB::table('news_description')->insert([
					'name'  	             =>   $request->$name,
					'description'  	         =>   $request->$description,
					'language_id'			 =>   $language->code,
					'news_id'			     =>   $id,
                    'created_at'             =>   date('Y-m-d H:i:s')
					]);
			}
		}
        $message = array('message' => 'News has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);  
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('news.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $get = News::whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(public_path($g->image));
        }
        News::whereIn('id',$ids)->delete();
        DB::table('news_description')->whereIn('news_id', $ids)->delete();
        return $message = array('message' => 'Delete Successed','type' => 'success');
    }
    public function Status(Request $request){
        if (!Gate::allows('news.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this action !','type' => 'error');
            return $message;
        }
        $news = News::find($request->id);
        if($news->status =='Active'){
            $news->update(['status' => 'InActive']);	
        }elseif($news->status =='InActive'){
            $news->update(['status' => 'Active']);	
        }
        $message = array('message' => 'News Status has been updated successfully','type' => 'success');
        return $message;
    }	
    
}
