<?php

namespace App\Http\Controllers\Admin;
use DB;
use App\Models\Menu;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    public function menu(Request $request){
        $menus = Menu::orderBy('order','ASC')->get();
        return view('admin.menu')->with('menus',$menus);
    }
    public function addMenu(Request $request){
        $data = $this->validate($request, [
            'title' => 'required|string|max:50',
          ]);
        $data['parent_id'] =$request->parent_id;
        $data['uri'] =$request->uri;
        $data['icon'] =$request->icon;

        Menu::create($data);
       
        $message = array('message' => 'Menu has been added successfully','type' => 'success');
        return redirect()->back()->with($message); 
    }
    public function editMenu($id){
        $menu = Menu::find($id);
        return view('admin.editMenu')->with(['menu'=>$menu]);
      
    }
    public function updateMenu(Request $request){
     
        $data = $this->validate($request, [
            'title'=>'string'
          ]);
            $data['parent_id'] =$request->parent_id;
            $data['uri'] =$request->uri;
            $data['icon'] =$request->icon;
            DB::table('menus')->where('id',$request->id)->update($data);
          
            $message = array('message' => 'Menu has been updated successfully','type' => 'success');
            return redirect()->back()->with($message);
        
    }
    public function deleteMenu($id){
        $ids = explode(',', $id);
        if (DB::table('menus')->whereIn('id',$ids)->delete()) {
            $message = array('message' => 'Delete Succeeded','type' => 'success');
        } else {
            $message = array('message' => 'Delete Failed','type' => 'error');
        }
        return $message;
    }
}
