<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Admin;
use Auth;
use DB;
use session;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Illuminate\Validation\ValidationException;
class LoginController extends Controller
{
    
    public function showLoginForm(){
        if (Auth::guard('admin')->check()) { 
            
            return redirect('/admin/dashboard');
        }else{ 
            return view('admin.login');
        }
    }

    public function login(Request $request){
       
        
    	$this->validate($request, [
        'email'   => 'required|email',
        'password' => 'required|min:8'
      ]);
      
      if ($this->attemptLogin($request)) {
        return $this->sendLoginResponse($request);
    }
        //return redirect()->intended('admin/dashboard');

        return $this->sendFailedLoginResponse($request);
    }
	
    protected function attemptLogin(Request $request){
        return $this->guard('admin')->attempt(
            $this->credentials($request)
        );
    }
    protected function credentials(Request $request){
        
        return $request->only('email', 'password');
    }
    protected function sendLoginResponse(Request $request){
        $request->session()->regenerate();

        //$this->clearLoginAttempts($request);

        if ($response = $this->authenticated($request, $this->guard('admin')->user())) {  
            $query1 = DB::table('admin_roles')
            ->join('admin_role_users','admin_roles.id','=','admin_role_users.role_id')
            ->select('admin_roles.*','admin_role_users.user_id as pivot_user_id'.'admin_role_users.role_id as pivot_role_id')
            ->where('admin_role_users.user_id',Auth::guard('admin')->user()->id)
            ->get();
            $query2 = DB::table('admin_permissions')
            ->join('admin_role_permissions','admin_permissions.id','=','admin_role_permissions.permission_id')
            ->select('admin_permissions.*','admin_role_permissions.role_id as pivot_role_id'.'admin_role_permissions.permission_id as pivot_permission_id')
            ->where('admin_role_permissions.role_id',1)
            ->get();
            $query3 = DB::table('admin_permissions')
            ->join('admin_user_permissions','admin_permissions.id','=','admin_user_permissions.permission_id')
            ->select('admin_permissions.*','admin_user_permissions.user_id as pivot_user_id','admin_user_permissions.permission_id as pivot_permission_id')
            ->where('admin_user_permissions.user_id',Auth::guard('admin')->user()->id)
            ->get();
            
        return $response;
        }
       
        return $request->wantsJson()
                    ? new Response('', 204)
                    : redirect()->intended('admin/dashboard');
        
    }
    protected function sendFailedLoginResponse(Request $request){
        throw ValidationException::withMessages([
            'email' => [trans('auth.failed')],
        ]);
    }
    protected function authenticated(Request $request, $user){
        
        
    }
    public function logout(Request $request){
        $this->guard('admin')->logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        if ($response = $this->loggedOut($request)) {
            return $response;
        }
        return $request->wantsJson()
            ? new Response('', 204)
            : redirect('/admin');
    }
    protected function loggedOut(Request $request){
        //
    }
 	
 	protected function guard(){
        return Auth::guard('admin');
    }
}
