<?php

namespace App\Http\Controllers\Admin;
use App\Models\Gift;
use App\Models\Language;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class GiftController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        
        if (!Gate::allows('gift.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $search = request()->search;
        if(request()->search){
            $gifts = Gift::where('price', request()->search)
            ->orWhere('created_at', 'like', '%' . request()->search. '%')
            ->orWhere('updated_at', 'like', '%' . request()->search. '%')
            ->paginate(20);
        }else{
            $gifts = Gift::paginate(20);
        }
    
		foreach($gifts as $gift){
		    $languages = Language::select('name','code')->get();
		    $result2 = array();
    		$index2 = 0;
    		foreach($languages as $language){
    		    array_push($result2, $language);
    		    $colors = DB::table('gifts_colors')->leftjoin('gifts_colors_description','gifts_colors.color_id','=','gifts_colors_description.color_id')
    		    ->where('gifts_colors.gift_id',$gift->id)->where('language_id',$language->code)->select('gifts_colors_description.name')->get();
    		    $result2[$index2]->colors = $colors;
    		    $index2++;
    		}
    		$gift->data = $result2;
			
		}
		
        return view('admin.gifts.index',compact('gifts','search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!Gate::allows('gift.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages = Language::all();
        return view('admin.gifts.create',compact('languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        if (!Gate::allows('gift.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
       $data = $this->validate($request, [
            'image' => 'required|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'price' => 'required|numeric'
        ]);
        
        if($request->hasfile('image')){
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(300, 300)->save(public_path('/images/gift_images/' . $filename));
            $data['image'] = 'images/gift_images/'.$filename;
        }else{
            $data;
            }
            $data['description_en'] = $request->description_en;
            $data['description_ar'] = $request->description_ar;
            Gift::create($data);
           
        $message = array('message' => 'Gift has been added successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('gift.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
		$languages = Language::all();
		$gift = Gift::find($id);
		
        return view('admin.gifts.edit',compact('languages','gift'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('ctegory.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
      
        $data = $this->validate($request, [
            'price' => 'required|numeric'
        ]);
        $news = Gift::find($id);
        if($request->hasfile('image')){
            File::delete(public_path($news->image));
            $image = $request->file('image');
            $filename = time() . '-image.' . $image->getClientOriginalExtension();
            Image::make($image)->resize(300, 300)->save(public_path('/images/gift_images/' . $filename));
            $data['image'] = 'images/gift_images/'.$filename;
        }else{
            $data;
            }
            $data['description_en'] = $request->description_en;
            $data['description_ar'] = $request->description_ar;
            $data['updated_at']=date('Y-m-d H:i:s');
            Gift::where('id', $id)->update($data);
		
        $message = array('message' => 'Gift has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);  
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('gift.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        $get = Gift::whereIn('id',$ids)->get();
        foreach($get as $g){
            File::delete(public_path($g->image));
        }
        Gift::whereIn('id',$ids)->delete();
        DB::table('gifts_colors')->whereIn('gift_id',$ids)->delete();
        return $message = array('message' => 'Delete Successed','type' => 'success');
    }
    
    public function colors($id)
    {
        if (!Gate::allows('gift.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
    $gift_id = $id;
      $gifts = DB::table('gifts_colors')->where('gift_id',$id)->select('color_id')->get($id);
      foreach($gifts as $gift){
		    $languages = Language::select('name','code')->get();
		    $result2 = array();
    		$index2 = 0;
    		foreach($languages as $language){
    		    array_push($result2, $language);
    		    $colors = DB::table('gifts_colors_description')
    		    ->where('color_id',$gift->color_id)->where('language_id',$language->code)->select('gifts_colors_description.name')->get();
    		    $result2[$index2]->colors = $colors;
    		    $index2++;
    		}
    		$gift->data = $result2;
		}
		$languages = Language::select('name','code')->get();
        return view('admin.gifts.colors',compact('gifts','languages','gift_id'));
    }
    
    public function storeColor(Request $request){
         if (!Gate::allows('gift.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $languages =  Language::select('name','code')->get();
        foreach($languages as $language){
            $this->validate($request, [
                'name_'.$language->code => 'required|string|max:100|',
            ]);	
        }
        $i = 0;
        //multiple lanugauge with record
        foreach($languages as $language){
            $color_name = 'name_'.$language->code;
            if($i==0){
                $color_id = DB::table('gifts_colors')->insertGetId([
                    'color_name'   => $request->$color_name,
                    'gift_id'           => $request->gift_id
                ]); 
            $i++;
            }
            DB::table('gifts_colors_description')->insert([
                'name'   => $request->$color_name,
                'color_id'     => $color_id,
                'language_id'         => $language->code
          ]);
         }
        $message = array('message' => 'Gift Color has been added successfully','type' => 'success');
        return redirect()->back()->with($message);
    }
    
    public function destroyColor($id){
        if (!Gate::allows('gift.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        DB::table('gifts_colors')->whereIn('color_id',$ids)->delete();
        DB::table('gifts_colors_description')->whereIn('color_id',$ids)->delete();
        $message = array('message' => 'Delete Succeeded','type' => 'success');
        return $message;
    }
  
}
