<?php

namespace App\Http\Controllers\Admin;
use App\Models\Coupon;
use App\Models\Category;
use App\Models\Product;
use App\Models\Customer;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Auth;
class CouponsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (!Gate::allows('coupon.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
       $coupons = Coupon::orderBy('created_at', 'DESC')->get();
        return view('admin.coupons.index',compact('coupons'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        
        if (!Gate::allows('coupon.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $categories = Category::LeftJoin('categories_description', 'categories_description.categories_id', '=', 'categories.id')->select('categories_description.name', 'categories.id')->where('parent_id','>',0)->get();
        $products = Product::LeftJoin('products_description', 'products_description.product_id', '=', 'products.id')->select('products_description.name', 'products.id')->get();
        $emails = Customer::select('email')->get();
        
        return view('admin.coupons.create',compact('categories','products','emails'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!Gate::allows('coupon.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
            $data = $this->validate($request, [
                'code'              =>  'required|string|unique:coupons',
                'expiry_date'       =>  'date|date_format:Y-m-d',
                'minimum_amount'    =>  'required|string',
                'maximum_amount'    =>  'required|string'
            ]);
        $data['description'] = $request->description;
        $data['discount_type'] = $request->discount_type;
        if ($request->individual_use !== null) {
            $data['individual_use'] = $request->individual_use;
        } else {
            $data['individual_use'] = 0;
        }
        //include products
        if ($request->product_ids !== null) {
            $data['product_ids'] = implode(',', $request->product_ids);
        } else {
            $data['product_ids'] = '';
        }

        if ($request->exclude_product_ids !== null) {
            $data['exclude_product_ids'] = implode(',', $request->exclude_product_ids);
        } else {
            $data['exclude_product_ids'] = '';
        }
        //limit
        $data['usage_limit'] = $request->usage_limit;
        $data['usage_limit_per_user'] = $request->usage_limit_per_user;

        //$limit_usage_to_x_items = $request->limit_usage_to_x_items;

        if ($request->product_categories !== null) {
            $data['product_categories'] = implode(',', $request->product_categories);
        } else {
            $data['product_categories'] = '';
        }

        if ($request->excluded_product_categories !== null) {
            $data['excluded_product_categories'] = implode(',', $request->excluded_product_categories);
        } else {
            $data['excluded_product_categories'] = '';
        }

        if ($request->exclude_sale_items !== null) {
            $data['exclude_sale_items'] = $request->exclude_sale_items;
        } else {
            $data['exclude_sale_items'] = 0;
        }

        if ($request->email_restrictions !== null) {
            $data['email_restrictions'] = implode(',', $request->email_restrictions);
        } else {
            $data['email_restrictions'] = '';
        }

        $data['minimum_amount'] = $request->minimum_amount;
        $data['maximum_amount'] = $request->maximum_amount;

        if ($request->usage_count !== null) {
            $data['usage_count'] = $request->usage_count;
        } else {
            $data['usage_count'] = 0;
        }

        if ($request->used_by !== null) {
            $data['used_by'] = $request->used_by;
        } else {
            $data['used_by'] = '';
        }

        if ($request->limit_usage_to_x_items !== null) {
            $data['limit_usage_to_x_items'] = $request->limit_usage_to_x_items;
        } else {
            $data['limit_usage_to_x_items'] = 0;
        }
        Coupon::create($data);    
        $message = array('message' => 'Coupon has been created successfully','type' => 'success');
        return redirect()->back()->with($message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!Gate::allows('coupon.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $coupon = Coupon::find($id);
        $categories = Category::LeftJoin('categories_description', 'categories_description.categories_id', '=', 'categories.id')->select('categories_description.name', 'categories.id')->where('parent_id','>',0)->get();
        $products = Product::LeftJoin('products_description', 'products_description.product_id', '=', 'products.id')->select('products_description.name', 'products.id')->get();
        $emails = Customer::select('email')->get();
        
        return view('admin.coupons.edit',compact('coupon','categories','products','emails'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('coupon.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        
        $data = $this->validate($request, [
                'code'              =>  'required|string|unique:coupons,code,'.$id,
                'expiry_date'       =>  'date|date_format:Y-m-d',
                'minimum_amount'    =>  'required|string',
                'maximum_amount'    =>  'required|string'
            ]);
        $data['description'] = $request->description;
        $data['discount_type'] = $request->discount_type;
        if ($request->individual_use !== null) {
            $data['individual_use'] = $request->individual_use;
        } else {
            $data['individual_use'] = 0;
        }
        //include products
        if ($request->product_ids !== null) {
            $data['product_ids'] = implode(',', $request->product_ids);
        } else {
            $data['product_ids'] = '';
        }

        if ($request->exclude_product_ids !== null) {
            $data['exclude_product_ids'] = implode(',', $request->exclude_product_ids);
        } else {
            $data['exclude_product_ids'] = '';
        }
        //limit
        $data['usage_limit'] = $request->usage_limit;
        $data['usage_limit_per_user'] = $request->usage_limit_per_user;

        //$limit_usage_to_x_items = $request->limit_usage_to_x_items;

        if ($request->product_categories !== null) {
            $data['product_categories'] = implode(',', $request->product_categories);
        } else {
            $data['product_categories'] = '';
        }

        if ($request->excluded_product_categories !== null) {
            $data['excluded_product_categories'] = implode(',', $request->excluded_product_categories);
        } else {
            $data['excluded_product_categories'] = '';
        }

        if ($request->exclude_sale_items !== null) {
            $data['exclude_sale_items'] = $request->exclude_sale_items;
        } else {
            $data['exclude_sale_items'] = 0;
        }

        if ($request->email_restrictions !== null) {
            $data['email_restrictions'] = implode(',', $request->email_restrictions);
        } else {
            $data['email_restrictions'] = '';
        }

        $data['minimum_amount'] = $request->minimum_amount;
        $data['maximum_amount'] = $request->maximum_amount;

        if ($request->usage_count !== null) {
            $data['usage_count'] = $request->usage_count;
        } else {
            $data['usage_count'] = 0;
        }

        if ($request->used_by !== null) {
            $data['used_by'] = $request->used_by;
        } else {
            $data['used_by'] = '';
        }

        if ($request->limit_usage_to_x_items !== null) {
            $data['limit_usage_to_x_items'] = $request->limit_usage_to_x_items;
        } else {
            $data['limit_usage_to_x_items'] = 0;
        }
        Coupon::where('id',$id)->update($data);    
        $message = array('message' => 'Coupon has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);  
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (!Gate::allows('coupon.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect('admin/dashboard')->with($message);
        }
        $ids = explode(',', $id);
        Coupon::whereIn('id',$ids)->delete();
        return $message = array('message' => 'Delete Successed','type' => 'success');
    }
   
}
