<?php

namespace App\Http\Controllers\Admin;
use App\Models\Country;
use App\Models\Role;
use App\Models\Permission;
use DB;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CountriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
         if (!Gate::allows('country.index') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $countries = Country::all();
        return view('admin.countries.index',compact('countries'));
        
    }
     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        if (!Gate::allows('country.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        } 
        return view('admin.countries.create');  
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        if (!Gate::allows('country.create') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        } 
        $data = $this->validate($request, [
            'name'          => 'required|string|max:50|unique:countries',
            'iso_code_2'    => 'required|string|max:2',
            'iso_code_3'    => 'required|string|max:3'
          ]);
          Country::create($data);
            $message = array('message' => 'Country has been created successfully !','type' => 'success');
            return redirect()->back()->with($message); 
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id){
        if (!Gate::allows('permission.edit') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $country = Country::find($id);
        return view('admin.countries.edit',compact('country'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (!Gate::allows('permission.edit') && !Gate::allows('all')) {
        
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
      $data = $this->validate($request, [
            'name'          => 'required|string|max:50|unique:countries,name,'.$id,
            'iso_code_2'    => 'required|string|max:2',
            'iso_code_3'    => 'required|string|max:3'
          ]);
        $data['updated_at']=date('Y-m-d H:i:s');
        Country::find($id)->update($data);
        $message = array('message' => 'Country has been updated successfully','type' => 'success');
        return redirect()->back()->with($message);
        
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
       if (!Gate::allows('country.destroy') && !Gate::allows('all')) {
            $message = array('message' => 'You are not allowed to access this page !','type' => 'error');
            return redirect()->back()->with($message);
        }
        $ids = explode(',', $id);
        Country::whereIn('id',$ids)->delete();
       
        $message = array('message' => 'Delete Successed','type' => 'success');
        return $message;
        
    }
}
